/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.api.asset;

import io.adminshell.aas.v3.model.AssetKind;
import io.adminshell.aas.v3.model.IdentifierType;
import io.adminshell.aas.v3.model.impl.DefaultAsset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aas.api.communications.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asset
extends DefaultAsset {
    private static final Logger logger = LoggerFactory.getLogger(Asset.class);
    private AssetKind kind;
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();

    public Asset(String idShort) {
        super.setIdShort(idShort);
        logger.info("Asset initialised with just idShort.");
    }

    public Asset(String idShort, AssetKind kind) {
        super.setIdShort(idShort);
        this.kind = kind;
        logger.info("Asset initialised with idShort and AssetKind.");
    }

    public Asset(String idShort, AssetKind kind, Endpoint endpoint) {
        super.setIdShort(idShort);
        this.kind = kind;
        this.endpoints.add(endpoint);
        logger.info("Asset Administration Shell Class initialised with idShort, AssetKind and Endpoint.");
    }

    public AssetKind getKind() {
        return this.kind;
    }

    public void setKind(AssetKind kind) {
        this.kind = kind;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public void setEndpoints(Endpoint ... endpoints) {
        Endpoint[] endpointArray = endpoints;
        int n = endpoints.length;
        int n2 = 0;
        while (n2 < n) {
            Endpoint endpoint = endpointArray[n2];
            this.endpoints.add(endpoint);
            ++n2;
        }
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public IdentifierType getIdType() {
        return super.getIdentification().getIdType();
    }

    public void setIdType(IdentifierType idType) {
        this.identification.setIdType(idType);
    }

    public String getId() {
        return super.getIdentification().getIdentifier();
    }

    public void setId(String id) {
        this.identification.setIdentifier(id);
    }
}

