/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.resource;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Brokering.DeviceBroker;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Brokering.MemoryBroker;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>On Device Resource</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getBase_Class <em>Base Class</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getDeviceBroker <em>Device Broker</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getMemoryBroker <em>Memory Broker</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.iotml.software.resource.ResourcePackage#getOnDeviceResource()
 * @model
 * @generated
 */
public interface OnDeviceResource extends EObject {
	/**
	 * Returns the value of the '<em><b>Base Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Base Class</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Base Class</em>' reference.
	 * @see #setBase_Class(org.eclipse.uml2.uml.Class)
	 * @see org.eclipse.papyrus.iotml.software.resource.ResourcePackage#getOnDeviceResource_Base_Class()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	org.eclipse.uml2.uml.Class getBase_Class();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getBase_Class <em>Base Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Base Class</em>' reference.
	 * @see #getBase_Class()
	 * @generated
	 */
	void setBase_Class(org.eclipse.uml2.uml.Class value);

	/**
	 * Returns the value of the '<em><b>Device Broker</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Device Broker</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Device Broker</em>' reference.
	 * @see #setDeviceBroker(DeviceBroker)
	 * @see org.eclipse.papyrus.iotml.software.resource.ResourcePackage#getOnDeviceResource_DeviceBroker()
	 * @model ordered="false"
	 * @generated
	 */
	DeviceBroker getDeviceBroker();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getDeviceBroker <em>Device Broker</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Device Broker</em>' reference.
	 * @see #getDeviceBroker()
	 * @generated
	 */
	void setDeviceBroker(DeviceBroker value);

	/**
	 * Returns the value of the '<em><b>Memory Broker</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Memory Broker</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Memory Broker</em>' reference.
	 * @see #setMemoryBroker(MemoryBroker)
	 * @see org.eclipse.papyrus.iotml.software.resource.ResourcePackage#getOnDeviceResource_MemoryBroker()
	 * @model ordered="false"
	 * @generated
	 */
	MemoryBroker getMemoryBroker();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.software.resource.OnDeviceResource#getMemoryBroker <em>Memory Broker</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Memory Broker</em>' reference.
	 * @see #getMemoryBroker()
	 * @generated
	 */
	void setMemoryBroker(MemoryBroker value);

} // OnDeviceResource
