/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.PapyrusDSMLValidationRule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Severity implements Enumerator
{
    ERROR(0, "ERROR", "ERROR"),
    WARNING(1, "WARNING", "WARNING"),
    INFO(2, "INFO", "INFO"),
    CANCEL(3, "CANCEL", "CANCEL");

    public static final int ERROR_VALUE = 0;
    public static final int WARNING_VALUE = 1;
    public static final int INFO_VALUE = 2;
    public static final int CANCEL_VALUE = 3;
    private static final Severity[] VALUES_ARRAY;
    public static final List<Severity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Severity[]{ERROR, WARNING, INFO, CANCEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Severity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Severity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Severity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Severity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Severity get(int value) {
        switch (value) {
            case 0: {
                return ERROR;
            }
            case 1: {
                return WARNING;
            }
            case 2: {
                return INFO;
            }
            case 3: {
                return CANCEL;
            }
        }
        return null;
    }

    private Severity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

