/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.xmi;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.papyrus.interoperability.rpy.xmi.XMI_ID_Helper;
import org.eclipse.papyrus.uml.m2m.qvto.common.utils.TraceHelper;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PreserveRpySemanticIDHelper {
    private Context context;
    private static final String ID_FEATURE_NAME = "id";
    private TraceHelper helper = new TraceHelper();

    public PreserveRpySemanticIDHelper(Context context) {
        this.context = context;
    }

    public void keepIdForUMLResource(XMIResource res) {
        String value;
        HashSet<String> knownIds = new HashSet<String>();
        ArrayList<EObject> eobjectForSecondRun = new ArrayList<EObject>();
        ArrayList<EObject> eobjectForThirdRun = new ArrayList<EObject>();
        TreeIterator iter = res.getAllContents();
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            if (this.isStereotypeApplication(current)) {
                eobjectForThirdRun.add(current);
                continue;
            }
            if (this.requiredToBeManagedInASecondRun(current)) {
                eobjectForSecondRun.add(current);
                continue;
            }
            Object result = this.helper.traceFrom((IContext)this.context, (Object)current, null);
            String rpyId = this.getRpyId(result);
            if (PreserveRpySemanticIDHelper.isValidId(rpyId) && !knownIds.contains(rpyId)) {
                knownIds.add(rpyId);
                res.setID(current, rpyId);
                continue;
            }
            eobjectForSecondRun.add(current);
        }
        for (EObject current : eobjectForSecondRun) {
            value = XMI_ID_Helper.calculateXMI_ID(current);
            if (PreserveRpySemanticIDHelper.isValidId(value) && !knownIds.contains(value)) {
                knownIds.add(value);
                res.setID(current, value);
                continue;
            }
            System.out.println("It is not possible to found an id for " + current.toString());
        }
        for (EObject current : eobjectForThirdRun) {
            value = XMI_ID_Helper.calculateXMI_ID(current);
            if (PreserveRpySemanticIDHelper.isValidId(value) && !knownIds.contains(value)) {
                knownIds.add(value);
                res.setID(current, value);
                continue;
            }
            System.out.println("It is not possible to found an id for " + current.toString());
        }
    }

    protected boolean requiredToBeManagedInASecondRun(EObject eobject) {
        return eobject instanceof ConnectorEnd;
    }

    protected String getRpyId(Object object) {
        EObject eobject;
        EStructuralFeature idFeature;
        if (object instanceof EObject && (idFeature = (eobject = (EObject)object).eClass().getEStructuralFeature(ID_FEATURE_NAME)) != null) {
            String value = (String)eobject.eGet(idFeature);
            return value;
        }
        return null;
    }

    protected boolean isStereotypeApplication(EObject eobject) {
        return UMLUtil.getBaseElement((EObject)eobject) != null;
    }

    public static final boolean isValidId(String id) {
        return id != null && (id.contains("GUID") || id.contains("OLDID"));
    }
}

