/*****************************************************************************
 * Copyright (c) 2016 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.rpy.transformations;

import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.interoperability.rpy.importer.SelectedRpyFilesImporter;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.AbstractImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IDependencyAnalysisHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IImportTransformation;
import org.eclipse.swt.widgets.Control;

/**
 * @author Vincent Lorenzo
 *
 */
public class RpyImportTransformationLauncher extends AbstractImportTransformationLauncher {

	private SelectedRpyFilesImporter importer;

	public RpyImportTransformationLauncher(ThreadConfig config) {
		super(config, null);
	}

	public RpyImportTransformationLauncher(ThreadConfig config, Control baseControl) {
		super(config, baseControl);
	}

	/**
	 * @see org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IImportTransformationLauncher#run(java.util.List)
	 *
	 * @param urisToImport
	 */
	@Override
	public void run(List<URI> urisToImport) {
		importer = new SelectedRpyFilesImporter(urisToImport);
		super.run(importer.getRpyFilesToImportURI());
	}

	/**
	 * @see org.eclipse.papyrus.interoperability.rpy..transformations.NEW_AbstractImportTransformationLauncher__NEW#createDependencyAnalysisHelper(org.eclipse.papyrus.migration.common.MigrationParameters.Config)
	 *
	 * @param config
	 * @return
	 */
	@Override
	protected IDependencyAnalysisHelper createDependencyAnalysisHelper(ThreadConfig config) {
		return new RpyDependencyAnalysisHelper(config);
	}

	/**
	 * @see org.eclipse.papyrus.interoperability.rpy..transformations.NEW_AbstractImportTransformationLauncher__NEW#createTransformation(org.eclipse.emf.common.util.URI, org.eclipse.papyrus.migration.common.MigrationParameters.Config,
	 *      org.eclipse.papyrus.migration.common.transformation.IDependencyAnalysisHelper)
	 *
	 * @param transformationURI
	 * @param config
	 * @param analysisHelper
	 * @return
	 */
	@Override
	protected IImportTransformation createTransformation(URI transformationURI, ThreadConfig config, IDependencyAnalysisHelper analysisHelper) {
		return new RpyImportTransformation(transformationURI, config, analysisHelper);
	}

}
