/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.ILayersStackApplicationEventListener;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.LayersStackApplicationEventNotifier;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model.ILayersModelRootEventListener;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model.LayersModelEventRootNotifier;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model.LayersModelResource;

public class LayersStackAndApplicationLifeCycleEventNotifier {
    protected State state;
    protected LayersModelResource layersModel;
    protected LayersStackApplicationEventNotifier layersStackApplicationEventNotifier;
    protected LayersModelEventRootNotifier layersModelEventRootNotifier;
    protected ILayersModelRootEventListener layersStackApplicationLifeCycleEventListener = new ILayersModelRootEventListener(){

        @Override
        public void layersModelRootRemoved(Notification msg) {
            if (LayersStackAndApplicationLifeCycleEventNotifier.this.state == State.ApplicationCreated) {
                LayersStackAndApplicationLifeCycleEventNotifier.this.transitionApplicationCreatedToNoApplicationState();
            }
        }

        @Override
        public void layersModelRootAdded(Notification msg) {
            if (LayersStackAndApplicationLifeCycleEventNotifier.this.state == State.NoApplication) {
                LayersStackAndApplicationLifeCycleEventNotifier.this.layersModel.shouldSave(true);
                LayersStackAndApplicationLifeCycleEventNotifier.this.transitionNoApplicationToApplicationCreatedState();
            }
        }
    };

    public LayersStackAndApplicationLifeCycleEventNotifier(LayersModelResource layersModel) {
        this.layersModel = layersModel;
        this.createListeners();
        this.initState();
    }

    private void initState() {
        if (this.layersModel.lookupLayerStackApplication() != null) {
            this.transitionInitToApplicationCreatedState();
        } else {
            this.transitionInitToNoApplicationState();
        }
    }

    private void transitionInitToApplicationCreatedState() {
        this.activateLayersStackLifeCycleEventNotifier();
        this.state = State.ApplicationCreated;
    }

    private void transitionInitToNoApplicationState() {
        this.state = State.NoApplication;
    }

    private void transitionNoApplicationToApplicationCreatedState() {
        this.activateLayersStackLifeCycleEventNotifier();
        this.state = State.ApplicationCreated;
    }

    private void transitionApplicationCreatedToNoApplicationState() {
        this.deactivateLayersStackLifeCycleEventNotifier();
        this.state = State.NoApplication;
    }

    protected void activate() {
        this.createListeners();
    }

    protected void deactivate() {
        this.deleteListeners();
    }

    public void dispose() {
        this.deleteListeners();
        this.layersModel = null;
        this.state = State.disposed;
    }

    public boolean isDisposed() {
        return this.state == State.disposed;
    }

    private void activateLayersStackLifeCycleEventNotifier() {
        this.layersStackApplicationEventNotifier.activate();
    }

    private void deactivateLayersStackLifeCycleEventNotifier() {
        this.layersStackApplicationEventNotifier.deactivate();
    }

    private void createListeners() {
        this.createLayersModelAndDiagramDeletionNotifiers();
        this.createLayersModelRootNotifier();
    }

    private void deleteListeners() {
        this.deleteLayersModelAndDiagramDeletionNotifiers();
        this.deleteLayersModelRootNotifier();
    }

    private void createLayersModelRootNotifier() {
        this.layersModelEventRootNotifier = new LayersModelEventRootNotifier(this.layersModel);
        this.layersModelEventRootNotifier.addEventListener(this.layersStackApplicationLifeCycleEventListener);
    }

    private void deleteLayersModelRootNotifier() {
        if (this.layersModelEventRootNotifier != null) {
            this.layersModelEventRootNotifier.removeEventListener(this.layersStackApplicationLifeCycleEventListener);
            this.layersModelEventRootNotifier.dispose();
            this.layersModelEventRootNotifier = null;
        }
    }

    private void createLayersModelAndDiagramDeletionNotifiers() {
        this.layersStackApplicationEventNotifier = new LayersStackApplicationEventNotifier(this.layersModel, false);
    }

    protected void deleteLayersModelAndDiagramDeletionNotifiers() {
        if (this.layersStackApplicationEventNotifier != null) {
            this.layersStackApplicationEventNotifier.dispose();
            this.layersStackApplicationEventNotifier = null;
        }
    }

    public void addLayersModelEventListener(ILayersStackApplicationEventListener listener) {
        this.layersStackApplicationEventNotifier.addLayersModelEventListener(listener);
    }

    public void removeLayersModelEventListener(ILayersStackApplicationEventListener listener) {
        this.layersStackApplicationEventNotifier.removeLayersModelEventListener(listener);
    }

    public void addLayersStackApplicationLifeCycleEventListener(ILayersModelRootEventListener listener) {
        this.layersModelEventRootNotifier.addEventListener(listener);
    }

    public void removeLayersStackApplicationLifeCycleEventListener(ILayersModelRootEventListener listener) {
        this.layersModelEventRootNotifier.removeEventListener(listener);
    }

    protected static enum State {
        NoApplication,
        ApplicationCreated,
        disposed;

    }
}

