/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.realtime.pycpa.ui.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.papyrus.designer.realtime.pycpa.m2m.executors.RTMLToPyCPATransformExecutor;
import org.eclipse.papyrus.designer.realtime.pycpa.m2t.executors.PyCPAModelToPythonCodeTransformExecutor;
import org.eclipse.papyrus.designer.realtime.pycpa.ui.Activator;
import org.eclipse.papyrus.designer.realtime.pycpa.ui.json.JsonBackpropagation;
import org.eclipse.papyrus.designer.realtime.pycpa.ui.python.PythonExecutor;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.uml2.uml.Activity;

public class AnalyzeSchedulability
extends CmdHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Activity) {
            Activity activity = (Activity)this.selectedEObject;
            URI uri = activity.eResource().getURI();
            if (uri.segmentCount() < 2) {
                return null;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project = root.getProject(uri.segment(1));
            IFile umlModelFile = project.getFile(activity.eResource().getURI().lastSegment().toString());
            IContainer container = umlModelFile.getParent();
            RTMLToPyCPATransformExecutor.run((Activity)activity);
            IFile pycpaModelFile = container.getFile((IPath)new Path(activity.getName() + ".pycpa"));
            if (pycpaModelFile.exists()) {
                URI pycpaModelUri = URI.createPlatformResourceURI((String)pycpaModelFile.getFullPath().toString(), (boolean)true);
                PyCPAModelToPythonCodeTransformExecutor generator = new PyCPAModelToPythonCodeTransformExecutor(pycpaModelUri, container, new ArrayList());
                try {
                    generator.doGenerate(null);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
                try {
                    project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
                IFile pyAnalysisFile = container.getFile((IPath)new Path(activity.getName() + "_analysis.py"));
                PythonExecutor.executePython(pyAnalysisFile, event);
                IFile jsonResultsFile = container.getFile((IPath)new Path(activity.getName() + "_result.json"));
                JsonBackpropagation.backpropagateResult(jsonResultsFile, activity);
                try {
                    activity.eResource().save(AnalyzeSchedulability.getDefaultSaveOptions());
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        return null;
    }

    public static Map<Object, Object> getDefaultSaveOptions() {
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("USE_FILE_BUFFER", true);
        saveOptions.put("FLUSH_THRESHOLD", 0x400000);
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        return saveOptions;
    }
}

