/*******************************************************************************
 * Copyright (c) 2006 - 2012 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.c.codegen.preferences;

import java.util.regex.Pattern;

import org.eclipse.papyrus.designer.infra.base.StringConstants;

public class CCodeGenConstants {

	/**
	 * Suffix for generated header files (key + default-value)
	 */
	public static final String P_HEADER_SUFFIX_KEY = "headSuffix"; //$NON-NLS-1$
	public static final String P_HEADER_SUFFIX_DVAL = "h"; //$NON-NLS-1$

	/**
	 * Suffix for generated body/implementation files
	 */
	public static final String P_IMPLEM_SUFFIX_KEY = "implSuffix"; //$NON-NLS-1$
	public static final String P_IMPLEM_SUFFIX_DVAL = "c"; //$NON-NLS-1$

	/**
	 * Suffix for generated body/implementation files
	 */
	public static final String P_OUT_INOUT_OP_KEY = "outInoutOp"; //$NON-NLS-1$
	public static final String P_OUT_INOUT_OP_DVAL = "*"; //$NON-NLS-1$

	/**
	 * User defined comment header in generated files
	 */
	public static final String P_COMMENT_HEADER_KEY = "commentHeader"; //$NON-NLS-1$
	public static final String P_COMMENT_HEADER_DVAL =
			"// --------------------------------------------------------" + StringConstants.NL + //$NON-NLS-1$
			"// Code generated by Papyrus C" + StringConstants.NL + //$NON-NLS-1$
			"// --------------------------------------------------------" + StringConstants.NL + StringConstants.NL; //$NON-NLS-1$

	/**
	 * Project prefix to use
	 */
	public static final String P_PROJECT_PREFIX_KEY = "projectPrefix"; //$NON-NLS-1$
	public static final String P_PROJECT_PREFIX_DVAL = "org.eclipse.papyrus.cgen."; //$NON-NLS-1$

	/**
	 * If true (default), format the generated code
	 */
	public static final String P_FORMAT_CODE_KEY = "formatCode"; //$NON-NLS-1$
	public static final boolean P_FORMAT_CODE_DVAL = true;
	
	/**
	 *  Supported languages: "C/C++", "c", and "C". The '+' needs to be escaped in a regular expression
	 */
	public static final Pattern supportedLanguages = Pattern.compile("C/C\\+\\+|c|C"); //$NON-NLS-1$
}
