/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.library.AbstractIterationManager;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IterableValue;
import org.eclipse.ocl.pivot.values.MapValue;

public abstract class AbstractEvaluatorIterableIterationManager<IV extends IterableValue>
extends AbstractIterationManager {
    protected final @NonNull IV iterableValue;
    protected final CallExp callExp;
    protected final @NonNull OCLExpression body;
    protected final @Nullable TypedElement accumulatorVariable;
    private @Nullable Object accumulatorValue;

    protected AbstractEvaluatorIterableIterationManager(@NonNull Executor executor, CallExp callExp, @NonNull OCLExpression body, @NonNull IV iterableValue, @Nullable TypedElement accumulatorVariable, @Nullable Object accumulatorValue) {
        super(executor);
        this.iterableValue = iterableValue;
        this.callExp = callExp;
        this.body = body;
        this.accumulatorVariable = accumulatorVariable;
        this.accumulatorValue = accumulatorValue;
        if (accumulatorVariable != null) {
            this.getEvaluationEnvironment().add(accumulatorVariable, accumulatorValue);
        }
        ((Executor.ExecutorExtension)this.executor).pushEvaluationEnvironment((NamedElement)body, (Object)callExp);
    }

    public AbstractEvaluatorIterableIterationManager(@NonNull AbstractEvaluatorIterableIterationManager<IV> iterationManager, @NonNull IV iterableValue) {
        super(iterationManager.executor);
        this.callExp = iterationManager.callExp;
        this.body = iterationManager.body;
        this.iterableValue = iterableValue;
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.accumulatorVariable = iterationManager.accumulatorVariable;
        ((Executor.ExecutorExtension)this.executor).pushEvaluationEnvironment((NamedElement)this.body, (Object)this.callExp);
    }

    @Override
    public void dispose() {
        this.executor.popEvaluationEnvironment();
    }

    @Override
    public @Nullable Object evaluateBody() {
        return this.executor.evaluate(this.body);
    }

    @Override
    public @Nullable Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public @NonNull EvaluationEnvironment getEvaluationEnvironment() {
        return this.executor.getEvaluationEnvironment();
    }

    @Override
    public boolean advanceIterators() {
        return false;
    }

    @Override
    public @NonNull IterableValue getSourceIterable() {
        return this.iterableValue;
    }

    public String toString() {
        return this.body.toString();
    }

    @Override
    public @Nullable Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        TypedElement accumulatorVariable2 = this.accumulatorVariable;
        if (accumulatorVariable2 != null) {
            this.getEvaluationEnvironment().replace(accumulatorVariable2, this.accumulatorValue);
        }
        return null;
    }

    protected static abstract class AbstractValueIterator<IV extends IterableValue> {
        protected final EvaluationEnvironment evaluationEnvironment;
        protected final @NonNull IV iterableValue;
        private final @NonNull TypedElement iteratorVariable;
        private Iterator<? extends Object> javaIter;
        private Object iteratorValue;

        public AbstractValueIterator(@NonNull Executor executor, @NonNull IV iterableValue, @NonNull TypedElement iteratorVariable) {
            this.evaluationEnvironment = executor.getEvaluationEnvironment();
            this.iterableValue = iterableValue;
            this.iteratorVariable = iteratorVariable;
        }

        public @Nullable Object get() {
            return this.iteratorValue;
        }

        public boolean hasCurrent() {
            return this.iteratorValue != this;
        }

        public @Nullable Object next() {
            if (!this.javaIter.hasNext()) {
                this.iteratorValue = this;
            } else {
                this.iteratorValue = this.javaIter.next();
                this.evaluationEnvironment.replace(this.iteratorVariable, this.iteratorValue);
            }
            return this.iteratorValue;
        }

        public Object reset() {
            this.javaIter = this.iterableValue.iterator();
            return this.next();
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.iteratorVariable)) + " = " + (this.iteratorValue != this ? String.valueOf(this.iteratorValue) : "<<END>>");
        }
    }

    protected static class CollectionValueIterator
    extends AbstractValueIterator<CollectionValue> {
        public CollectionValueIterator(@NonNull Executor executor, @NonNull CollectionValue collectionValue, @NonNull TypedElement keyVariable) {
            super(executor, collectionValue, keyVariable);
            this.reset();
        }
    }

    protected static class MapValueIterator
    extends AbstractValueIterator<MapValue> {
        private final @Nullable TypedElement valueVariable;

        public MapValueIterator(@NonNull Executor executor, @NonNull MapValue mapValue, @NonNull TypedElement keyVariable, @Nullable TypedElement valueVariable) {
            super(executor, mapValue, keyVariable);
            this.valueVariable = valueVariable;
            this.reset();
        }

        @Override
        public @Nullable Object next() {
            TypedElement valueVariable2;
            Object keyValue = super.next();
            if (keyValue != this && (valueVariable2 = this.valueVariable) != null) {
                Object valueValue = ((MapValue)this.iterableValue).at(keyValue);
                this.evaluationEnvironment.replace(valueVariable2, valueValue);
            }
            return keyValue;
        }
    }
}

