/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.interpreter.console;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ocl.examples.interpreter.OCLExamplePlugin;
import org.eclipse.ocl.examples.interpreter.console.OCLConsolePage;
import org.eclipse.ocl.examples.interpreter.console.TargetMetamodel;
import org.eclipse.ocl.examples.interpreter.internal.l10n.OCLInterpreterMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;

public class OCLConsole
extends AbstractConsole {
    private static OCLConsole instance;
    private OCLConsolePage page;
    private boolean disposed = false;

    private OCLConsole() {
        super(OCLInterpreterMessages.console_title, ImageDescriptor.createFromURL((URL)OCLExamplePlugin.getDefault().getBundle().getEntry("/icons/ocl.gif")));
    }

    protected void dispose() {
        this.disposed = true;
        super.dispose();
    }

    public static OCLConsole getInstance() {
        if (instance == null) {
            instance = new OCLConsole();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{instance});
        }
        return instance;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        this.page = new OCLConsolePage();
        return this.page;
    }

    public void setTargetMetamodel(final TargetMetamodel metamodel) {
        if (!this.disposed && instance != null) {
            if (this.page == null) {
                Display.getCurrent().timerExec(1000, new Runnable(){

                    public void run() {
                        OCLConsole.this.setTargetMetamodel(metamodel);
                    }
                });
            } else {
                this.page.setTargetMetamodel(metamodel);
            }
        }
    }

    void close() {
        try {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
            this.dispose();
        }
        finally {
            instance = null;
        }
    }
}

