/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.incremental.compare;

import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class EmfCompare
extends AbstractWorkflowComponent {
    private String oldModelSlot;
    private String newModelSlot;
    private String diffModelSlot;
    private String snapshotModelSlot;

    public void setOldModelSlot(String oldModelSlot) {
        this.oldModelSlot = oldModelSlot;
    }

    public void setNewModelSlot(String newModelSlot) {
        this.newModelSlot = newModelSlot;
    }

    public void setDiffModelSlot(String diffModelSlot) {
        this.diffModelSlot = diffModelSlot;
    }

    public void setSnapshotModelSlot(String snapshotModelSlot) {
        this.snapshotModelSlot = snapshotModelSlot;
    }

    public void checkConfiguration(Issues issues) {
        if (this.oldModelSlot == null) {
            issues.addError("No oldModelSlot given.");
        }
        if (this.newModelSlot == null) {
            issues.addError("No newModelSlot given.");
        }
        if (this.diffModelSlot == null) {
            issues.addError("No diffModelSlot given.");
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        MatchModel matchModel;
        EObject newModel = (EObject)ctx.get(this.newModelSlot);
        if (newModel == null) {
            issues.addWarning((WorkflowComponent)this, "Sot '" + this.newModelSlot + "' is empty. Not computing model diff.");
            return;
        }
        EObject oldModel = (EObject)ctx.get(this.oldModelSlot);
        if (oldModel == null) {
            issues.addWarning((WorkflowComponent)this, "Sot '" + this.oldModelSlot + "' is empty. Not computing model diff.");
            return;
        }
        try {
            matchModel = MatchService.doMatch((EObject)newModel, (EObject)oldModel, null);
        }
        catch (InterruptedException e) {
            issues.addError((WorkflowComponent)this, "cannot compute diff", (Object)e);
            return;
        }
        DiffModel diffModel = DiffService.doDiff((MatchModel)matchModel);
        ctx.set(this.diffModelSlot, (Object)diffModel);
        if (this.snapshotModelSlot != null) {
            ComparisonResourceSnapshot snapshotModel = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
            snapshotModel.setMatch(matchModel);
            snapshotModel.setDiff(diffModel);
            ctx.set(this.snapshotModelSlot, (Object)snapshotModel);
        }
    }
}

