/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.xsd;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.ListType;
import org.eclipse.xtend.backend.types.emf.EmfTypesystem;
import org.eclipse.xtend.backend.types.xsd.internal.EFeatureMapEntryType;
import org.eclipse.xtend.backend.types.xsd.internal.EFeatureType;
import org.eclipse.xtend.backend.types.xsd.internal.EMapEntryType;
import org.eclipse.xtend.backend.types.xsd.internal.EMapType;
import org.eclipse.xtend.backend.types.xsd.internal.QNameType;
import org.eclipse.xtend.backend.types.xsd.internal.XMLEClassType;
import org.eclipse.xtend.backend.types.xsd.internal.XMLFeatureMapType;
import org.eclipse.xtend.backend.util.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsdTypesystem
implements BackendTypesystem {
    private BackendTypesystem _rootTs;
    private final EmfTypesystem _emfTypesystem = new EmfTypesystem();
    public static final String EFEATURE_MAP_ENTRY = "EFeatureMapEntry";
    public static final String EFEATURE_MAP = "EFeatureMap";
    public static final String EFEATURE = "EFeature";
    public static final String EMAP = "EMap";
    public static final String EMAP_ENTRY = "EMapEntry";
    public static final String QNAME = "QName";
    public static final String XSD_TYPE_PREFIX = "{xsd}";
    private EFeatureMapEntryType featureMapEntry;
    private EFeatureType featureType;
    private QNameType qnameType;
    private final Map<EClassifier, BackendType> _cache = new HashMap<EClassifier, BackendType>();
    private Cache<EClassifier, EMapEntryType> mapEntryCache = new Cache<EClassifier, EMapEntryType>(){

        protected EMapEntryType create(EClassifier key) {
            return new EMapEntryType(XsdTypesystem.EMAP_ENTRY, XsdTypesystem.this, key);
        }
    };
    private Cache<EClassifier, EMapType> eMapCache = new Cache<EClassifier, EMapType>(){

        protected EMapType create(EClassifier c) {
            return new EMapType(XsdTypesystem.EMAP, XsdTypesystem.this, c);
        }
    };
    private Cache<EClass, XMLFeatureMapType> featueMapCache = new Cache<EClass, XMLFeatureMapType>(){

        protected XMLFeatureMapType create(EClass c) {
            return new XMLFeatureMapType(XsdTypesystem.EFEATURE_MAP, XsdTypesystem.this, c);
        }
    };

    public static String getFullyQualifiedName(EClass clazz) {
        return EmfTypesystem.getFullyQualifiedName((ENamedElement)clazz);
    }

    public static String getUniqueIdentifier(EClassifier cls) {
        return "{xsd}{" + cls.getEPackage().getNsURI() + "}" + cls.getName();
    }

    public BackendType findType(Object o) {
        AbstractType r = null;
        if (o instanceof FeatureMap) {
            FeatureMap m = (FeatureMap)o;
            EClass c = ((EStructuralFeature.Setting)m).getEObject().eClass();
            r = this.getEFeatureMapType(c);
        } else if (o instanceof FeatureMap.Entry) {
            r = this.getEFeatureMapEntryType();
        } else if (o instanceof EStructuralFeature) {
            r = this.getEFeatureType();
        } else if (EMapType.isEMapObject(o)) {
            EClassifier c = ((EStructuralFeature.Setting)o).getEStructuralFeature().getEType();
            r = this.getEMapType(c);
        } else if (EMapEntryType.isEMapEntryObject(o)) {
            EClass i = o instanceof EObject ? ((EObject)o).eClass() : null;
            r = this.getEMapEntryType((EClassifier)i);
        } else if (o instanceof QName) {
            r = this.getQNameType();
        } else if (o instanceof EObject) {
            EClass eCls = ((EObject)o).eClass();
            EList anns = eCls.getEAnnotations();
            for (EAnnotation eAnn : anns) {
                EMap details = eAnn.getDetails();
                String kind = (String)details.get((Object)"kind");
                if (!eAnn.getSource().endsWith("ExtendedMetaData") || kind == null) continue;
                return this.getTypeForEClassifier((EClassifier)eCls);
            }
        } else {
            r = this._emfTypesystem.findType(o);
        }
        return r;
    }

    public BackendType findType(Class<?> cls) {
        if (FeatureMap.class.isAssignableFrom(cls)) {
            return this.getEFeatureMapType(null);
        }
        if (FeatureMap.Entry.class.isAssignableFrom(cls)) {
            return this.getEFeatureMapEntryType();
        }
        if (EStructuralFeature.class.isAssignableFrom(cls)) {
            return new EFeatureType(EFEATURE, this);
        }
        if (EMap.class.isAssignableFrom(cls)) {
            return this.getEMapType(null);
        }
        if (Map.Entry.class.isAssignableFrom(cls)) {
            return this.getEMapEntryType(null);
        }
        if (QName.class.isAssignableFrom(cls)) {
            return this.getQNameType();
        }
        return this._emfTypesystem.findType(cls);
    }

    public BackendType findType(String uniqueRepresentation) {
        if (!uniqueRepresentation.startsWith(XSD_TYPE_PREFIX)) {
            return null;
        }
        if (EFEATURE_MAP.equals(uniqueRepresentation = uniqueRepresentation.substring(XSD_TYPE_PREFIX.length()))) {
            return this.getEFeatureMapType(null);
        }
        if (EFEATURE_MAP_ENTRY.equals(uniqueRepresentation)) {
            return this.getEFeatureMapEntryType();
        }
        if (EFEATURE.equals(uniqueRepresentation)) {
            return new EFeatureType(EFEATURE, this);
        }
        if (EMAP.equals(uniqueRepresentation)) {
            return this.getEMapType(null);
        }
        if (EMAP_ENTRY.equals(uniqueRepresentation)) {
            return this.getEMapEntryType(null);
        }
        if (QNAME.equals(uniqueRepresentation)) {
            return this.getQNameType();
        }
        return this._emfTypesystem.findType(uniqueRepresentation);
    }

    public BackendTypesystem getRootTypesystem() {
        return this._rootTs;
    }

    public void setRootTypesystem(BackendTypesystem ts) {
        this._rootTs = ts;
    }

    public EFeatureMapEntryType getEFeatureMapEntryType() {
        if (this.featureMapEntry == null) {
            this.featureMapEntry = new EFeatureMapEntryType(EFEATURE_MAP_ENTRY, this);
        }
        return this.featureMapEntry;
    }

    public XMLFeatureMapType getEFeatureMapType(EClass aClass) {
        return (XMLFeatureMapType)((Object)this.featueMapCache.get((Object)aClass));
    }

    public EFeatureType getEFeatureType() {
        if (this.featureType == null) {
            this.featureType = new EFeatureType(EFEATURE, this);
        }
        return this.featureType;
    }

    public EMapEntryType getEMapEntryType(EClassifier innerType) {
        return (EMapEntryType)((Object)this.mapEntryCache.get((Object)innerType));
    }

    public EMapType getEMapType(EClassifier innerType) {
        return (EMapType)((Object)this.eMapCache.get((Object)innerType));
    }

    public QNameType getQNameType() {
        if (this.qnameType == null) {
            this.qnameType = new QNameType(QNAME, this);
        }
        return this.qnameType;
    }

    public BackendType getTypeForEClassifier(EClassifier cls) {
        BackendType cached = this._cache.get(cls);
        if (cached != null) {
            return cached;
        }
        if (cls instanceof EClass) {
            XMLEClassType result = new XMLEClassType((EClass)cls, this);
            this._cache.put(cls, (BackendType)result);
            result.init(this);
            return result;
        }
        return this._emfTypesystem.getTypeForEClassifier(cls);
    }

    public BackendType getTypeForETypedElement(ETypedElement typedElement) {
        if (typedElement.getUpperBound() != 1) {
            return ListType.INSTANCE;
        }
        return this.getTypeForEClassifier(typedElement.getEType());
    }

    public EmfTypesystem getEmfTypesystem() {
        return this._emfTypesystem;
    }
}

