/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.PDFTextPainter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PDFTextElementBridge
extends SVGTextElementBridge {
    private PDFTextPainter pdfTextPainter;

    public PDFTextElementBridge(FontInfo fi) {
        this.pdfTextPainter = new PDFTextPainter(fi);
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        GraphicsNode node = super.createGraphicsNode(ctx, e);
        if (node != null && this.isSimple(ctx, e, node)) {
            ((TextNode)node).setTextPainter((TextPainter)this.getTextPainter());
        }
        return node;
    }

    private PDFTextPainter getTextPainter() {
        return this.pdfTextPainter;
    }

    private boolean isSimple(BridgeContext ctx, Element element, GraphicsNode node) {
        float fs = TextUtilities.convertFontSize((Element)element).floatValue();
        if (fs > 36.0f) {
            return false;
        }
        block3: for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)n;
                    if (n.getLocalName().equals("tspan") || n.getLocalName().equals("altGlyph")) {
                        return false;
                    }
                    if (n.getLocalName().equals("textPath")) {
                        return false;
                    }
                    if (!n.getLocalName().equals("tref")) continue block3;
                    return false;
                }
            }
        }
        return true;
    }
}

