/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.util;

import java.util.List;
import org.eclipse.gmf.runtime.common.ui.printing.IPrintHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelperUtil;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.JPSPrintDialog;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.ui.PlatformUI;

public class PrintHelper
implements IPrintHelper {
    private final PrintOptions options = new PrintOptions();
    List<String> diagramList;

    public PrintHelper() {
        this.initPrintOptions();
    }

    private void initPrintOptions() {
        this.options.setPercentScaling(true);
        this.options.setScaleFactor(PrintHelperUtil.getScale());
        this.options.setFitToPagesWidth(PrintHelperUtil.getScaleToWidth());
        this.options.setFitToPagesHeight(PrintHelperUtil.getScaleToHeight());
        this.options.setAllPages(true);
        this.options.setRangeFrom(1);
        this.options.setRangeTo(1);
        this.options.setCopies(1);
        this.options.setCollate(false);
        this.options.setQualityHigh(true);
        this.options.setSideOneSided(true);
        this.options.setChromaticityColor(true);
        this.options.setDiagramCurrent(true);
    }

    public PrinterData openPrintDlg(List availableDiagramList) {
        PrinterData result = null;
        this.diagramList = availableDiagramList;
        JPSPrintDialog dlg = new JPSPrintDialog((IShellProvider)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), this.options, this.diagramList);
        if (dlg.open() == 0) {
            if (this.options.getDestination() != null) {
                result = this.options.getDestination().getPrinterData();
            }
        } else {
            this.initPrintOptions();
        }
        return result;
    }

    public boolean getDlgCollate() {
        return this.options.isCollate();
    }

    public int getDlgNumberOfCopies() {
        return this.options.getCopies();
    }

    public int getDlgPagesFrom() {
        return this.options.getRangeFrom();
    }

    public int getDlgPagesTo() {
        return this.options.getRangeTo();
    }

    public boolean getDlgPrintRangeAll() {
        return this.options.isAllPages();
    }

    public boolean getDlgPrintRangePages() {
        return !this.getDlgPrintRangeAll();
    }

    public int getDlgScaleFitToM() {
        return this.options.getFitToPagesWidth();
    }

    public int getDlgScaleFitToN() {
        return this.options.getFitToPagesHeight();
    }

    public int getDlgScalePercent() {
        return this.options.isPercentScaling() ? this.options.getScaleFactor() : -1;
    }

    public void setDlgOrientation(boolean landscape) {
    }

    public void setDlgPaperSize(int index, double width, double length) {
    }

    public boolean getDlgDiagramPrintRangeCurrent() {
        return this.options.isDiagramCurrent();
    }

    public boolean getDlgDiagramPrintRangeSelection() {
        return this.options.isDiagramSelection();
    }

    public boolean isDlgDiagramSelected(int index) {
        String diagramToPrint = this.diagramList.get(index);
        if (this.options.getDiagramsToPrint() != null) {
            return this.options.getDiagramsToPrint().contains(diagramToPrint);
        }
        return false;
    }

    public boolean getDlgDiagramPrintRangeAll() {
        return false;
    }

    public PrintOptions getPrintOptions() {
        return this.options;
    }

    public void setScaleFactor(int scaleFactor) {
        this.options.setScaleFactor(scaleFactor);
    }

    public void setScaleToWidthHeight(int width, int height) {
        this.options.setFitToPagesWidth(width);
        this.options.setFitToPagesHeight(height);
    }
}

