/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOElementMapping;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyListMaker;
import org.apache.fop.fo.Service;
import org.apache.fop.fo.UnknownXMLObj;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.render.RendererFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FOTreeBuilder
extends DefaultHandler {
    protected Map fobjTable = new HashMap();
    protected Log log = LogFactory.getLog(class$org$apache$fop$fo$FOTreeBuilder == null ? (class$org$apache$fop$fo$FOTreeBuilder = FOTreeBuilder.class$("org.apache.fop.fo.FOTreeBuilder")) : class$org$apache$fop$fo$FOTreeBuilder);
    protected Set namespaces = new HashSet();
    protected Root rootFObj = null;
    protected FONode currentFObj = null;
    protected PropertyList currentPropertyList;
    private FOEventHandler foEventHandler;
    private Locator locator;
    static /* synthetic */ Class class$org$apache$fop$fo$FOTreeBuilder;
    static /* synthetic */ Class class$org$apache$fop$fo$ElementMapping;

    public FOTreeBuilder(int renderType, FOUserAgent foUserAgent, OutputStream stream) throws FOPException {
        this.foEventHandler = RendererFactory.createFOEventHandler((FOUserAgent)foUserAgent, (int)renderType, (OutputStream)stream);
        this.foEventHandler.setPropertyListMaker((PropertyListMaker)new /* Unavailable Anonymous Inner Class!! */);
        this.setupDefaultMappings();
        ArrayList addlEMs = foUserAgent.getAdditionalElementMappings();
        if (addlEMs != null) {
            for (int i = 0; i < addlEMs.size(); ++i) {
                this.addElementMapping((ElementMapping)addlEMs.get(i));
            }
        }
    }

    private void setupDefaultMappings() {
        this.addElementMapping("org.apache.fop.fo.FOElementMapping");
        this.addElementMapping("org.apache.fop.fo.extensions.svg.SVGElementMapping");
        this.addElementMapping("org.apache.fop.fo.extensions.svg.BatikExtensionElementMapping");
        this.addElementMapping("org.apache.fop.fo.extensions.ExtensionElementMapping");
        Iterator providers = Service.providers((Class)(class$org$apache$fop$fo$ElementMapping == null ? (class$org$apache$fop$fo$ElementMapping = FOTreeBuilder.class$("org.apache.fop.fo.ElementMapping")) : class$org$apache$fop$fo$ElementMapping));
        if (providers != null) {
            while (providers.hasNext()) {
                String str = (String)providers.next();
                try {
                    this.addElementMapping(str);
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Error while adding element mapping", e);
                }
            }
        }
    }

    public void addElementMapping(String mappingClassName) throws IllegalArgumentException {
        try {
            ElementMapping mapping = (ElementMapping)Class.forName(mappingClassName).newInstance();
            this.addElementMapping(mapping);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + mappingClassName);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + mappingClassName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + mappingClassName);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(mappingClassName + " is not an ElementMapping");
        }
    }

    private void addElementMapping(ElementMapping mapping) {
        this.fobjTable.put(mapping.getNamespaceURI(), mapping.getTable());
        this.namespaces.add(mapping.getNamespaceURI().intern());
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] data, int start, int length) throws FOPException {
        if (this.currentFObj != null) {
            this.currentFObj.addCharacters(data, start, start + length, this.currentPropertyList, this.locator);
        }
    }

    public void startDocument() throws SAXException {
        this.rootFObj = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Building formatting object tree");
        }
        this.foEventHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.rootFObj = null;
        this.currentFObj = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parsing of document complete");
        }
        this.foEventHandler.endDocument();
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attlist) throws SAXException {
        PropertyList propertyList;
        FONode foNode;
        if (this.rootFObj == null) {
            if (!namespaceURI.equals(FOElementMapping.URI) || !localName.equals("root")) {
                throw new SAXException(new IllegalArgumentException("Error:  First element must be fo:root formatting object"));
            }
        } else if (namespaceURI.equals(FOElementMapping.URI)) {
            this.currentFObj.validateChildNode(this.locator, namespaceURI, localName);
        }
        ElementMapping.Maker fobjMaker = this.findFOMaker(namespaceURI, localName);
        try {
            foNode = fobjMaker.make(this.currentFObj);
            propertyList = foNode.createPropertyList(this.currentPropertyList, this.foEventHandler);
            foNode.processNode(localName, this.locator, attlist, propertyList);
            foNode.startOfNode();
        }
        catch (IllegalArgumentException e) {
            throw new SAXException(e);
        }
        if (this.rootFObj == null) {
            this.rootFObj = (Root)foNode;
            this.rootFObj.setFOEventHandler(this.foEventHandler);
        } else {
            this.currentFObj.addChildNode(foNode);
        }
        this.currentFObj = foNode;
        if (propertyList != null) {
            this.currentPropertyList = propertyList;
        }
    }

    public void endElement(String uri, String localName, String rawName) throws FOPException {
        this.currentFObj.endOfNode();
        if (this.currentPropertyList.getFObj() == this.currentFObj) {
            this.currentPropertyList = this.currentPropertyList.getParentPropertyList();
        }
        this.currentFObj = this.currentFObj.getParent();
    }

    private ElementMapping.Maker findFOMaker(String namespaceURI, String localName) throws FOPException {
        Map table = (Map)this.fobjTable.get(namespaceURI);
        ElementMapping.Maker fobjMaker = null;
        if (table != null && (fobjMaker = (ElementMapping.Maker)table.get(localName)) == null) {
            fobjMaker = (ElementMapping.Maker)table.get("<default>");
        }
        if (fobjMaker == null) {
            if (this.namespaces.contains(namespaceURI.intern())) {
                throw new FOPException(FONode.errorText((Locator)this.locator) + "No element mapping definition found for " + FONode.getNodeString((String)namespaceURI, (String)localName), this.locator);
            }
            this.log.warn("Unknown formatting object " + namespaceURI + "^" + localName);
            fobjMaker = new UnknownXMLObj.Maker(namespaceURI);
        }
        return fobjMaker;
    }

    public void warning(SAXParseException e) {
        this.log.warn(e.toString());
    }

    public void error(SAXParseException e) {
        this.log.error(e.toString());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.log.error(e.toString());
        throw e;
    }

    public void reset() {
        this.currentFObj = null;
        this.rootFObj = null;
        this.foEventHandler = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

