/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.graphics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

final class FontRegistry {
    private static FontRegistry singletonInstance = new FontRegistry();
    private Map<String, Font> fonts = null;

    public static FontRegistry getInstance() {
        return singletonInstance;
    }

    private FontRegistry() {
    }

    public Font getFont(Device device, FontData fd) {
        Font font = null;
        String fontSignature = fd.toString();
        if (this.fonts == null) {
            this.fonts = new HashMap<String, Font>();
        } else {
            font = this.fonts.get(fontSignature);
        }
        if (font == null) {
            font = new Font(device, fd);
            this.fonts.put(fontSignature, font);
        }
        return font;
    }

    public void clearFontCache() {
        if (this.fonts != null) {
            ArrayList<String> keys = new ArrayList<String>(this.fonts.keySet());
            Iterator keyiter = keys.iterator();
            while (keyiter.hasNext()) {
                Font font = this.fonts.remove(keyiter.next());
                font.dispose();
            }
        }
    }
}

