/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.tools;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.RubberbandSelectionTool;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.DiagramNotationType;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorInput;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.framework.DiagramTestCase;
import org.eclipse.gmf.tests.runtime.diagram.ui.tools.RubberBandSelectionToolTest;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class RubberBandSelectionToolTest
extends DiagramTestCase {
    private Diagram diagramView;
    private RubberbandSelectionTool tool;
    private NoteEditPart note1;
    private NoteEditPart note2;
    static /* synthetic */ Class class$0;

    public RubberBandSelectionToolTest(String name) {
        super(name);
    }

    public void test_basicSelect() {
        AbstractTestBase.println("** Running test_basicSelect");
        AbstractTestBase.println("Activating rubber band tool");
        this.tool.activate();
        AbstractTestBase.println("Drawing rubber band around the shapes");
        this.tool.mouseDown(this.createMouseEvent(0, 0), this.getViewer());
        this.tool.mouseDrag(this.createMouseEvent(210, 210), this.getViewer());
        this.tool.mouseUp(this.createMouseEvent(210, 210), this.getViewer());
        AbstractTestBase.println("Deactivating rubber band tool");
        this.tool.deactivate();
        RubberBandSelectionToolTest.assertEquals((String)"Wrong number of edit parts selected.", (int)2, (int)this.getViewer().getSelectedEditParts().size());
        RubberBandSelectionToolTest.assertTrue((String)"note1 not selected. ", (boolean)this.getViewer().getSelectedEditParts().contains(this.note1));
        RubberBandSelectionToolTest.assertTrue((String)"note2 not selected. ", (boolean)this.getViewer().getSelectedEditParts().contains(this.note2));
    }

    public void test_selectWithInitialFocus() {
        AbstractTestBase.println("** Running test_selectWithInitialFocus");
        AbstractTestBase.println("Activating rubber band tool");
        this.tool.activate();
        AbstractTestBase.println("Drawing rubber band around the shapes");
        this.tool.mouseDown(this.createMouseEvent(0, 0), this.getViewer());
        this.tool.mouseDrag(this.createMouseEvent(210, 210), this.getViewer());
        this.tool.mouseUp(this.createMouseEvent(210, 210), this.getViewer());
        AbstractTestBase.println("Deactivating rubber band tool");
        this.tool.deactivate();
        RubberBandSelectionToolTest.assertEquals((String)"Wrong number of edit parts selected.", (int)2, (int)this.getViewer().getSelectedEditParts().size());
        RubberBandSelectionToolTest.assertTrue((String)"note1 not selected. ", (boolean)this.getViewer().getSelectedEditParts().contains(this.note1));
        RubberBandSelectionToolTest.assertTrue((String)"note2 not selected. ", (boolean)this.getViewer().getSelectedEditParts().contains(this.note2));
    }

    MouseEvent createMouseEvent(int x, int y) {
        Event e = new Event();
        e.widget = this.getViewer().getControl();
        e.display = e.widget.getDisplay();
        e.button = 1;
        e.x = x;
        e.y = y;
        return new MouseEvent(e);
    }

    EditPartViewer getViewer() {
        return this.getDiagramEditPart().getViewer();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tool = new RubberbandSelectionTool();
        this.tool.setEditDomain((EditDomain)this.getDiagramWorkbenchPart().getDiagramEditDomain());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tool = null;
        this.diagramView = null;
        this.note1 = null;
        this.note2 = null;
    }

    protected void createShapesAndConnectors() throws Exception {
        AbstractTestBase.println("Creating note shapes");
        this.note1 = (NoteEditPart)this.createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(10, 10));
        this.note2 = (NoteEditPart)this.createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(100, 100));
        AbstractTestBase.println("Update figure layout");
        this.flushEventQueue();
    }

    public ShapeEditPart createShapeUsingTool(IElementType elementType, Point location) {
        class CreationTool
        extends org.eclipse.gmf.runtime.diagram.ui.tools.CreationTool {
            final /* synthetic */ RubberBandSelectionToolTest this$0;

            public CreationTool(RubberBandSelectionToolTest rubberBandSelectionToolTest, IElementType theElementType) {
                this.this$0 = rubberBandSelectionToolTest;
                super(theElementType);
            }

            public Request createTargetRequest() {
                return super.createTargetRequest();
            }

            protected PreferencesHint getPreferencesHint() {
                return PreferencesHint.USE_DEFAULTS;
            }
        }
        CreationTool ctool = new CreationTool(this, elementType);
        CreateRequest request = (CreateRequest)ctool.createTargetRequest();
        request.setLocation(location);
        Command cmd = this.getDiagramEditPart().getCommand((Request)request);
        int previousNumPrimaryEPs = this.getDiagramEditPart().getPrimaryEditParts().size();
        this.getDiagramWorkbenchPart().getDiagramEditDomain().getDiagramCommandStack().execute(cmd);
        RubberBandSelectionToolTest.assertEquals((int)(previousNumPrimaryEPs + 1), (int)this.getDiagramEditPart().getPrimaryEditParts().size());
        IAdaptable iAdaptable = (IAdaptable)((List)request.getNewObject()).get(0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.notation.View");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object newView = iAdaptable.getAdapter((Class)clazz);
        RubberBandSelectionToolTest.assertNotNull((Object)newView);
        ShapeEditPart newShape = (ShapeEditPart)this.getDiagramEditPart().getViewer().getEditPartRegistry().get(newView);
        RubberBandSelectionToolTest.assertNotNull((Object)newShape);
        return newShape;
    }

    protected IFile createDiagram() throws Exception {
        AbstractTestBase.println("Creating diagram");
        AbstractEMFOperation operation = new AbstractEMFOperation(this.getEditingDomain(), ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                RubberBandSelectionToolTest.this.diagramView = ViewService.createDiagram((String)"PresentationTestsDiagramKind", (PreferencesHint)PreferencesHint.USE_DEFAULTS);
                RubberBandSelectionToolTest.this.setDiagram(RubberBandSelectionToolTest.this.diagramView);
                return Status.OK_STATUS;
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            RubberBandSelectionToolTest.assertFalse((boolean)false);
        }
        return null;
    }

    protected void openDiagram() throws Exception {
        AbstractTestBase.println("Opening diagram");
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.setDiagramWorkbenchPart((IDiagramWorkbenchPart)IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new DiagramEditorInput(this.getDiagramView()), (String)"org.eclipse.gmf.tests.runtime.diagram.ui.DiagramTestEditor", (boolean)true));
    }

    protected Diagram getDiagramView() {
        return this.diagramView;
    }
}

