/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.codegen.gmfgen.DesignLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenActionFactoryContributionItem;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContext;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.codegen.gmfgen.GenAuditable;
import org.eclipse.gmf.codegen.gmfgen.GenAuditedMetricTarget;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenChildSideAffixedNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.gmf.codegen.gmfgen.GenContributionItem;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenDomainAttributeTarget;
import org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenElementInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureSeqInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.gmf.codegen.gmfgen.GenGroupMarker;
import org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkConstraints;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenMeasurable;
import org.eclipse.gmf.codegen.gmfgen.GenMenuManager;
import org.eclipse.gmf.codegen.gmfgen.GenMetricContainer;
import org.eclipse.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNotationElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.gmf.codegen.gmfgen.GenReferenceNewElementSpec;
import org.eclipse.gmf.codegen.gmfgen.GenRuleTarget;
import org.eclipse.gmf.codegen.gmfgen.GenSeparator;
import org.eclipse.gmf.codegen.gmfgen.GenSeverity;
import org.eclipse.gmf.codegen.gmfgen.GenSharedContributionItem;
import org.eclipse.gmf.codegen.gmfgen.GenStandardPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenToolBarManager;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.LabelOffsetAttributes;
import org.eclipse.gmf.codegen.gmfgen.LabelTextAccessMethod;
import org.eclipse.gmf.codegen.gmfgen.LinkLabelAlignment;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.OpenDiagramBehaviour;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.ProviderPriority;
import org.eclipse.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.gmf.codegen.gmfgen.StandardPreferencePages;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.AlignmentFacet;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.Direction;
import org.eclipse.gmf.gmfgraph.LabelOffsetFacet;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.VisualFacet;
import org.eclipse.gmf.internal.bridge.History;
import org.eclipse.gmf.internal.bridge.Knowledge;
import org.eclipse.gmf.internal.bridge.NaiveIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.EcoreGenModelMatcher;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelMatcher;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.MappingTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.PropertySheetHandler;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.navigator.NavigatorHandler;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.internal.bridge.tooldef.PaletteHandler;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.AuditedMetricTarget;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.Constraint;
import org.eclipse.gmf.mappings.DesignLabelMapping;
import org.eclipse.gmf.mappings.DiagramElementTarget;
import org.eclipse.gmf.mappings.DomainAttributeTarget;
import org.eclipse.gmf.mappings.DomainElementTarget;
import org.eclipse.gmf.mappings.ElementInitializer;
import org.eclipse.gmf.mappings.FeatureInitializer;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.FeatureValueSpec;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.Language;
import org.eclipse.gmf.mappings.LinkConstraints;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.MetricContainer;
import org.eclipse.gmf.mappings.MetricRule;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.NotationElementTarget;
import org.eclipse.gmf.mappings.ReferenceNewElementSpec;
import org.eclipse.gmf.mappings.Severity;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.mappings.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramGenModelTransformer
extends MappingTransformer {
    private GenEditorGenerator myGenModel;
    protected GenModelMatcher myGenModelMatch;
    private final DiagramRunTimeModelHelper myDRTHelper;
    private final ViewmapProducer myViewmaps;
    private final VisualIdentifierDispenser myVisualIDs;
    private final boolean rcp;
    private final History myHistory;
    private final Map<GenClass, ElementType> myProcessedTypes = new IdentityHashMap<GenClass, ElementType>();
    private final Map<ValueExpression, org.eclipse.gmf.codegen.gmfgen.ValueExpression> myProcessedExpressions;
    private final GenModelNamingMediator myNamingStrategy;
    private final PaletteHandler myPaletteProcessor;
    private final NavigatorHandler myNavigatorProcessor;
    private final PropertySheetHandler myPropertySheetProcessor;
    private final EcoreGenModelMatcher myEcoreGenModelMatch;
    private GenAuditContext myDefaultAuditContext;

    public DiagramGenModelTransformer(DiagramRunTimeModelHelper drtHelper, GenModelNamingMediator namingStrategy) {
        this(drtHelper, namingStrategy, new InnerClassViewmapProducer(), new NaiveIdentifierDispenser(), false);
    }

    public DiagramGenModelTransformer(DiagramRunTimeModelHelper drtHelper, GenModelNamingMediator namingStrategy, ViewmapProducer viewmaps, VisualIdentifierDispenser visualIdD, boolean rcp) {
        assert (drtHelper != null && namingStrategy != null && viewmaps != null);
        this.myDRTHelper = drtHelper;
        this.myNamingStrategy = namingStrategy;
        this.myViewmaps = viewmaps;
        this.myVisualIDs = visualIdD;
        this.rcp = rcp;
        this.myHistory = new History();
        this.myPaletteProcessor = new PaletteHandler();
        this.myNavigatorProcessor = new NavigatorHandler();
        this.myPropertySheetProcessor = new PropertySheetHandler();
        this.myEcoreGenModelMatch = new EcoreGenModelMatcher();
        this.myProcessedExpressions = new HashMap<ValueExpression, org.eclipse.gmf.codegen.gmfgen.ValueExpression>();
    }

    public void setEMFGenModel(GenModel emfGenModel) {
        this.myGenModelMatch = new GenModelMatcher(emfGenModel);
    }

    public GenEditorGenerator getResult() {
        return this.getGenEssence();
    }

    private GenEditorGenerator getGenEssence() {
        if (this.myGenModel == null) {
            this.myGenModel = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        }
        if (this.myGenModel.getEditor() == null) {
            this.myGenModel.setEditor(GMFGenFactory.eINSTANCE.createGenEditorView());
        }
        return this.myGenModel;
    }

    private GenDiagram getGenDiagram() {
        if (this.getGenEssence().getDiagram() == null) {
            this.getGenEssence().setDiagram(GMFGenFactory.eINSTANCE.createGenDiagram());
        }
        return this.getGenEssence().getDiagram();
    }

    private void initGenPlugin() {
        if (this.getGenEssence().getPlugin() == null) {
            this.getGenEssence().setPlugin(GMFGenFactory.eINSTANCE.createGenPlugin());
        }
    }

    private void initGenUpdater() {
        if (this.getGenEssence().getDiagramUpdater() == null) {
            this.getGenEssence().setDiagramUpdater(GMFGenFactory.eINSTANCE.createGenDiagramUpdater());
        }
    }

    private GenNavigator genGenNavigator() {
        if (this.getGenEssence().getNavigator() == null) {
            this.getGenEssence().setNavigator(GMFGenFactory.eINSTANCE.createGenNavigator());
        }
        return this.getGenEssence().getNavigator();
    }

    private Palette createGenPalette() {
        Palette p = this.getGenDiagram().getPalette();
        if (p == null) {
            p = GMFGenFactory.eINSTANCE.createPalette();
            this.getGenDiagram().setPalette(p);
        }
        return p;
    }

    private GenPropertySheet createPropertySheet() {
        if (this.getGenEssence().getPropertySheet() == null) {
            this.getGenEssence().setPropertySheet(GMFGenFactory.eINSTANCE.createGenPropertySheet());
        }
        return this.getGenEssence().getPropertySheet();
    }

    @Override
    protected void process(CanvasMapping mapping) {
        if (this.myGenModelMatch == null && mapping.getDomainModel() != null) {
            this.myGenModelMatch = new GenModelMatcher(mapping.getDomainModel());
        }
        this.myHistory.purge();
        if (mapping.getPalette() != null) {
            this.myPaletteProcessor.initialize(this.createGenPalette());
            this.myPaletteProcessor.process(mapping.getPalette());
        }
        if (!this.rcp) {
            this.myNavigatorProcessor.initialize(this.getGenDiagram(), this.genGenNavigator());
        }
        GenPackage primaryPackage = this.findGenPackage(mapping.getDomainModel());
        this.getGenEssence().setDomainGenModel(primaryPackage == null ? null : primaryPackage.getGenModel());
        this.getGenDiagram().setDomainDiagramElement(this.findGenClass(mapping.getDomainMetaElement()));
        this.getGenDiagram().setDiagramRunTimeClass(this.findRunTimeClass(mapping));
        this.getGenDiagram().setVisualID(this.myVisualIDs.get(this.getGenDiagram()));
        this.getGenDiagram().setViewmap(this.myViewmaps.create(mapping.getDiagramCanvas()));
        this.getGenDiagram().setIconProviderPriority(ProviderPriority.LOW_LITERAL);
        this.getGenDiagram().setValidationProviderPriority(ProviderPriority.LOW_LITERAL);
        if (this.getGenDiagram().getDomainDiagramElement() != null) {
            this.getGenDiagram().setElementType((ElementType)GMFGenFactory.eINSTANCE.createMetamodelType());
            this.myProcessedTypes.put(this.getGenDiagram().getDomainDiagramElement(), this.getGenDiagram().getElementType());
        } else {
            this.getGenDiagram().setElementType((ElementType)GMFGenFactory.eINSTANCE.createNotationType());
        }
        this.initGenPlugin();
        this.initGenUpdater();
        this.myPropertySheetProcessor.initialize(this.createPropertySheet());
        this.myPropertySheetProcessor.process(mapping);
        this.addPreferencePages(this.getGenDiagram());
        if (this.rcp && this.getGenEssence().getApplication() == null) {
            GenApplication app = GMFGenFactory.eINSTANCE.createGenApplication();
            this.addContributions(app);
            this.getGenEssence().setApplication(app);
        }
        this.myNamingStrategy.feed(this.getGenDiagram(), mapping);
    }

    @Override
    protected void process(TopNodeReference topNode) {
        NodeMapping nme = topNode.getChild();
        assert (nme != null);
        this.assertNodeMapping(nme);
        GenTopLevelNode genNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        this.getGenDiagram().getTopLevelNodes().add((Object)genNode);
        genNode.setDiagramRunTimeClass(this.findRunTimeClass(nme));
        genNode.setModelFacet(this.createModelFacet((NodeReference)topNode));
        genNode.setVisualID(this.myVisualIDs.get(genNode));
        genNode.setViewmap(this.myViewmaps.create(nme.getDiagramNode()));
        this.setupElementType((GenNode)genNode);
        this.myPaletteProcessor.process(nme, (GenNode)genNode);
        this.myNamingStrategy.feed(genNode, nme);
        this.processAbstractNode(nme, (GenNode)genNode);
        this.myHistory.log(nme, genNode);
        if (!this.rcp) {
            this.myNavigatorProcessor.process(genNode);
        }
    }

    @Override
    protected void process(AuditContainer audits) {
        if (audits != null) {
            this.getGenEssence().setAudits(this.createGenAuditRoot(audits));
        }
    }

    @Override
    protected void process(MetricContainer metrics) {
        if (metrics != null) {
            GenMetricContainer genMetricContainer = GMFGenFactory.eINSTANCE.createGenMetricContainer();
            for (MetricRule next : metrics.getMetrics()) {
                genMetricContainer.getMetrics().add((Object)this.createGenMetric(next));
            }
            this.getGenEssence().setMetrics(genMetricContainer);
        }
    }

    private void process(ChildReference childNodeRef, GenChildContainer container) {
        GenChildNode childNode;
        NodeMapping childNodeMapping = childNodeRef.getChild();
        assert (childNodeMapping != null);
        this.assertNodeMapping(childNodeMapping);
        if (!this.myHistory.isKnownChildNode(childNodeMapping)) {
            childNode = this.createGenChildNode(childNodeRef);
        } else {
            GenChildNode[] alreadyKnownChildren = this.myHistory.findChildNodes(childNodeMapping);
            childNode = null;
            int i = 0;
            while (i < alreadyKnownChildren.length) {
                if (DiagramGenModelTransformer.matchChildReferenceFeatures(childNodeRef, alreadyKnownChildren[i])) {
                    childNode = alreadyKnownChildren[i];
                    break;
                }
                ++i;
            }
            if (childNode == null) {
                childNode = this.createGenChildNode(childNodeRef);
            }
        }
        if (container instanceof GenCompartment && childNodeMapping.getChildren().size() > 0) {
            ((GenCompartment)container).setListLayout(false);
        }
        container.getChildNodes().add((Object)childNode);
        if (!this.rcp) {
            this.myNavigatorProcessor.process(childNode, container);
        }
    }

    private static boolean matchChildReferenceFeatures(ChildReference childNodeRef, GenChildNode childNode) {
        boolean childrenFeatureMatch;
        boolean containmentFeatureMatch;
        if (childNode.getModelFacet() == null || childNode.getModelFacet().getContainmentMetaFeature() == null) {
            containmentFeatureMatch = childNodeRef.getContainmentFeature() == null;
        } else {
            boolean bl = containmentFeatureMatch = childNodeRef.getContainmentFeature() == childNode.getModelFacet().getContainmentMetaFeature().getEcoreFeature();
        }
        if (childNode.getModelFacet() == null || childNode.getModelFacet().getChildMetaFeature() == null) {
            childrenFeatureMatch = childNodeRef.getChildrenFeature() == null;
        } else if (childNodeRef.getChildrenFeature() == null) {
            childrenFeatureMatch = childNode.getModelFacet().getChildMetaFeature() == childNode.getModelFacet().getContainmentMetaFeature();
        } else {
            boolean bl = childrenFeatureMatch = childNode.getModelFacet().getChildMetaFeature().getEcoreFeature() == childNodeRef.getChildrenFeature();
        }
        return containmentFeatureMatch && childrenFeatureMatch;
    }

    private GenChildNode createGenChildNode(ChildReference childNodeRef) {
        boolean needCompartmentChildrenLabelProcessing;
        GenChildNode childNode;
        NodeMapping childNodeMapping = childNodeRef.getChild();
        if (Knowledge.isPureLabelNode(childNodeMapping)) {
            LabelMapping soleLabel = (LabelMapping)childNodeMapping.getLabelMappings().get(0);
            GenChildLabelNode childLabelNode = GMFGenFactory.eINSTANCE.createGenChildLabelNode();
            childLabelNode.setViewmap(this.myViewmaps.create(soleLabel.getDiagramLabel()));
            childLabelNode.setLabelModelFacet(this.createLabelModelFacet(soleLabel));
            childLabelNode.setLabelReadOnly(soleLabel.isReadOnly());
            childLabelNode.setLabelElementIcon(soleLabel.getDiagramLabel().isElementIcon());
            childNode = childLabelNode;
            needCompartmentChildrenLabelProcessing = false;
        } else if (childNodeMapping.getDiagramNode().getAffixedParentSide() != Direction.NONE_LITERAL) {
            GenChildSideAffixedNode sideAffixedNode = GMFGenFactory.eINSTANCE.createGenChildSideAffixedNode();
            sideAffixedNode.setViewmap(this.myViewmaps.create(childNodeMapping.getDiagramNode()));
            String positionConstantName = this.getAffixedSideAsPositionConstantsName(childNodeMapping.getDiagramNode());
            sideAffixedNode.setPreferredSideName(positionConstantName);
            childNode = sideAffixedNode;
            needCompartmentChildrenLabelProcessing = true;
        } else {
            childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
            childNode.setViewmap(this.myViewmaps.create(childNodeMapping.getDiagramNode()));
            needCompartmentChildrenLabelProcessing = true;
        }
        this.myHistory.log(childNodeMapping, childNode);
        this.getGenDiagram().getChildNodes().add((Object)childNode);
        childNode.setModelFacet(this.createModelFacet((NodeReference)childNodeRef));
        childNode.setDiagramRunTimeClass(this.findRunTimeClass(childNodeMapping));
        childNode.setVisualID(this.myVisualIDs.get(childNode));
        this.setupElementType((GenNode)childNode);
        this.myNamingStrategy.feed(childNode, childNodeMapping);
        this.myPaletteProcessor.process(childNodeMapping, (GenNode)childNode);
        if (needCompartmentChildrenLabelProcessing) {
            this.processAbstractNode(childNodeMapping, (GenNode)childNode);
        }
        return childNode;
    }

    private String getAffixedSideAsPositionConstantsName(Node diagramNode) {
        Direction affixedSide = diagramNode.getAffixedParentSide();
        switch (affixedSide.getValue()) {
            case 0: {
                throw new IllegalStateException("DiagramNode: " + diagramNode + " is not side-affixed");
            }
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                return affixedSide.getName();
            }
            case 29: {
                return "NONE";
            }
        }
        return "NONE";
    }

    private void processAbstractNode(NodeMapping mapping, GenNode genNode) {
        HashMap<CompartmentMapping, GenCompartment> compartments2GenCompartmentsMap = new HashMap<CompartmentMapping, GenCompartment>();
        for (CompartmentMapping compartmentMapping : mapping.getCompartments()) {
            GenCompartment compartmentGen = this.createGenCompartment(compartmentMapping, genNode);
            compartments2GenCompartmentsMap.put(compartmentMapping, compartmentGen);
        }
        for (ChildReference childNodeRef : mapping.getChildren()) {
            CompartmentMapping compartmentMapping = childNodeRef.getCompartment();
            Object genChildContainer = compartmentMapping != null && compartments2GenCompartmentsMap.containsKey(compartmentMapping) ? (GenChildContainer)compartments2GenCompartmentsMap.get(compartmentMapping) : genNode;
            this.process(childNodeRef, (GenChildContainer)genChildContainer);
        }
        for (LabelMapping labelMapping : mapping.getLabelMappings()) {
            GenNodeLabel label = this.createNodeLabel(genNode, labelMapping);
            this.myNamingStrategy.feed(label, labelMapping);
        }
        for (CanvasMapping nextRelatedCanvas : mapping.getRelatedDiagrams()) {
            OpenDiagramBehaviour openDiagramPolicy = GMFGenFactory.eINSTANCE.createOpenDiagramBehaviour();
            if (nextRelatedCanvas.eResource() != mapping.eResource()) {
                openDiagramPolicy.setDiagramKind("FIXME put GenEditorGenerator.modelID value here");
                openDiagramPolicy.setEditorID("FIXME put GenEditorView.id value here");
            }
            genNode.getBehaviour().add((Object)openDiagramPolicy);
        }
    }

    private GenCompartment createGenCompartment(CompartmentMapping mapping, GenNode genNode) {
        Compartment compartment = mapping.getCompartment();
        assert (compartment != null);
        GenCompartment childCompartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        this.getGenDiagram().getCompartments().add((Object)childCompartment);
        genNode.getCompartments().add((Object)childCompartment);
        childCompartment.setVisualID(this.myVisualIDs.get(childCompartment));
        childCompartment.setDiagramRunTimeClass(this.getChildContainerRunTimeClass());
        childCompartment.setViewmap(this.myViewmaps.create(mapping.getCompartment()));
        childCompartment.setCanCollapse(compartment.isCollapsible());
        childCompartment.setNeedsTitle(compartment.isNeedsTitle());
        childCompartment.setTitle(compartment.getName());
        this.myNamingStrategy.feed(childCompartment, mapping);
        return childCompartment;
    }

    @Override
    protected void process(LinkMapping lme) {
        this.assertLinkMapping(lme);
        GenLink gl = GMFGenFactory.eINSTANCE.createGenLink();
        this.getGenDiagram().getLinks().add((Object)gl);
        gl.setModelFacet(this.createModelFacet(lme));
        gl.setVisualID(this.myVisualIDs.get(gl));
        this.myPaletteProcessor.process(lme, gl);
        for (LabelMapping labelMapping : lme.getLabelMappings()) {
            GenLinkLabel label = this.createLinkLabel(gl, labelMapping);
            this.myNamingStrategy.feed(label, labelMapping);
        }
        gl.setDiagramRunTimeClass(this.findRunTimeClass(lme));
        this.setupElementType(gl);
        this.myNamingStrategy.feed(gl, lme);
        gl.setViewmap(this.myViewmaps.create(lme.getDiagramLink()));
        if (lme.getCreationConstraints() != null) {
            gl.setCreationConstraints(this.createLinkCreationConstraints(lme.getCreationConstraints()));
        }
        this.myHistory.log(lme, gl);
        if (!this.rcp) {
            this.myNavigatorProcessor.process(gl);
        }
    }

    private GenNodeLabel createNodeLabel(GenNode node, LabelMapping mapping) {
        Object label = mapping.getDiagramLabel().isExternal() ? GMFGenFactory.eINSTANCE.createGenExternalNodeLabel() : GMFGenFactory.eINSTANCE.createGenNodeLabel();
        node.getLabels().add(label);
        label.setVisualID(this.myVisualIDs.get((GenNodeLabel)label));
        label.setDiagramRunTimeClass(this.findRunTimeClass(mapping));
        label.setViewmap(this.myViewmaps.create(mapping.getDiagramLabel()));
        label.setModelFacet(this.createLabelModelFacet(mapping));
        label.setReadOnly(mapping.isReadOnly());
        label.setElementIcon(mapping.getDiagramLabel().isElementIcon());
        return label;
    }

    private GenLinkLabel createLinkLabel(GenLink link, LabelMapping mapping) {
        GenLinkLabel label = GMFGenFactory.eINSTANCE.createGenLinkLabel();
        link.getLabels().add((Object)label);
        label.setVisualID(this.myVisualIDs.get(label));
        label.setDiagramRunTimeClass(this.findRunTimeClass(mapping));
        label.setViewmap(this.myViewmaps.create(mapping.getDiagramLabel()));
        label.setModelFacet(this.createLabelModelFacet(mapping));
        label.setReadOnly(mapping.isReadOnly());
        label.setElementIcon(mapping.getDiagramLabel().isElementIcon());
        if (DiagramGenModelTransformer.findVF((DiagramElement)mapping.getDiagramLabel(), AlignmentFacet.class) != null) {
            AlignmentFacet af = DiagramGenModelTransformer.findVF((DiagramElement)mapping.getDiagramLabel(), AlignmentFacet.class);
            label.setAlignment(this.getLinkLabelAlignment(af.getAlignment()));
        }
        LabelOffsetAttributes loa = GMFGenFactory.eINSTANCE.createLabelOffsetAttributes();
        LabelOffsetFacet lof = DiagramGenModelTransformer.findVF((DiagramElement)mapping.getDiagramLabel(), LabelOffsetFacet.class);
        if (lof != null) {
            loa.setX(lof.getX());
            loa.setY(lof.getY());
        } else {
            int weight = link.getLabels().size() + 1;
            loa.setY(weight * 20);
        }
        label.getViewmap().getAttributes().add((Object)loa);
        return label;
    }

    private static <T extends VisualFacet> T findVF(DiagramElement element, Class<T> facetClass) {
        for (VisualFacet vf : element.getFacets()) {
            if (!facetClass.isInstance(vf)) continue;
            return (T)((VisualFacet)facetClass.cast(vf));
        }
        return null;
    }

    private LinkLabelAlignment getLinkLabelAlignment(Alignment alignment) {
        switch (alignment.getValue()) {
            case 0: {
                return LinkLabelAlignment.SOURCE_LITERAL;
            }
            case 1: {
                return LinkLabelAlignment.MIDDLE_LITERAL;
            }
            case 2: {
                return LinkLabelAlignment.TARGET_LITERAL;
            }
        }
        throw new IllegalArgumentException("Link doesn't support alignment:" + alignment.getName());
    }

    private LabelModelFacet createLabelModelFacet(LabelMapping mapping) {
        if (mapping instanceof FeatureLabelMapping) {
            FeatureLabelMapping flMapping = (FeatureLabelMapping)mapping;
            FeatureLabelModelFacet modelFacet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
            for (EAttribute attr : flMapping.getFeatures()) {
                modelFacet.getMetaFeatures().add((Object)this.findGenFeature((EStructuralFeature)attr));
            }
            modelFacet.setViewPattern(flMapping.getViewPattern());
            modelFacet.setEditorPattern(flMapping.getEditorPattern());
            modelFacet.setEditPattern(flMapping.getEditPattern());
            if (flMapping.eIsSet((EStructuralFeature)GMFMapPackage.eINSTANCE.getFeatureLabelMapping_ViewMethod())) {
                modelFacet.setViewMethod(LabelTextAccessMethod.get((int)flMapping.getViewMethod().getValue()));
            }
            if (flMapping.eIsSet((EStructuralFeature)GMFMapPackage.eINSTANCE.getFeatureLabelMapping_EditMethod())) {
                modelFacet.setEditMethod(LabelTextAccessMethod.get((int)flMapping.getEditMethod().getValue()));
            }
            return modelFacet;
        }
        if (mapping instanceof DesignLabelMapping) {
            DesignLabelModelFacet modelFacet = GMFGenFactory.eINSTANCE.createDesignLabelModelFacet();
            return modelFacet;
        }
        return null;
    }

    private void setupElementType(GenNode genNode) {
        if (genNode.getModelFacet() != null) {
            MetamodelType metamodelType = (MetamodelType)this.myProcessedTypes.get(genNode.getModelFacet().getMetaClass());
            if (metamodelType == null) {
                genNode.setElementType((ElementType)GMFGenFactory.eINSTANCE.createMetamodelType());
                this.myProcessedTypes.put(genNode.getModelFacet().getMetaClass(), genNode.getElementType());
            } else {
                SpecializationType specializationType = GMFGenFactory.eINSTANCE.createSpecializationType();
                specializationType.setMetamodelType(metamodelType);
                genNode.setElementType((ElementType)specializationType);
            }
        } else {
            genNode.setElementType((ElementType)GMFGenFactory.eINSTANCE.createNotationType());
        }
    }

    private void setupElementType(GenLink gl) {
        if (gl.getModelFacet() != null) {
            if (gl.getModelFacet() instanceof TypeModelFacet) {
                GenClass metaClass = ((TypeModelFacet)gl.getModelFacet()).getMetaClass();
                MetamodelType metamodelType = (MetamodelType)this.myProcessedTypes.get(metaClass);
                if (metamodelType == null) {
                    gl.setElementType((ElementType)GMFGenFactory.eINSTANCE.createMetamodelType());
                    this.myProcessedTypes.put(metaClass, gl.getElementType());
                } else {
                    SpecializationType specializationType = GMFGenFactory.eINSTANCE.createSpecializationType();
                    specializationType.setMetamodelType(metamodelType);
                    gl.setElementType((ElementType)specializationType);
                }
            } else {
                SpecializationType specializationType = GMFGenFactory.eINSTANCE.createSpecializationType();
                gl.setElementType((ElementType)specializationType);
            }
        } else {
            gl.setElementType((ElementType)GMFGenFactory.eINSTANCE.createNotationType());
        }
    }

    private GenClass findRunTimeClass(NodeMapping nme) {
        return this.myDRTHelper.get(nme);
    }

    private GenClass findRunTimeClass(LinkMapping lme) {
        return this.myDRTHelper.get(lme);
    }

    private GenClass findRunTimeClass(CanvasMapping mapping) {
        return this.myDRTHelper.get(mapping);
    }

    private GenClass getChildContainerRunTimeClass() {
        return this.myDRTHelper.getChildContainerDefault();
    }

    private GenClass findRunTimeClass(LabelMapping mapping) {
        return this.myDRTHelper.get(mapping);
    }

    private void assertNodeMapping(NodeMapping mapping) {
        assert (mapping.getDiagramNode() != null);
        assert (DiagramGenModelTransformer.checkLabelMappings((MappingEntry)mapping));
    }

    private void assertLinkMapping(LinkMapping linkMapping) {
        assert (linkMapping.getDiagramLink() != null);
        if (linkMapping.getDomainMetaElement() != null) assert (linkMapping.getLinkMetaFeature() != null);
        assert (DiagramGenModelTransformer.checkLabelMappings((MappingEntry)linkMapping));
    }

    private static boolean checkLabelMappings(MappingEntry entry) {
        for (LabelMapping labelMapping : entry.getLabelMappings()) {
            if (!(labelMapping instanceof FeatureLabelMapping)) continue;
            EClass domainElement = labelMapping.getMapEntry().getDomainContext();
            for (EAttribute attr : ((FeatureLabelMapping)labelMapping).getFeatures()) {
                if (attr.getEContainingClass().isSuperTypeOf(domainElement)) continue;
                return false;
            }
        }
        return true;
    }

    private GenPackage findGenPackage(EPackage ePackage) {
        if (this.myGenModelMatch == null) {
            this.warnNoGenModelMatcher((EModelElement)ePackage);
            return null;
        }
        return this.myGenModelMatch.findGenPackage(ePackage);
    }

    private GenClass findGenClass(EClass eClass) {
        if (this.myGenModelMatch == null) {
            this.warnNoGenModelMatcher((EModelElement)eClass);
            return null;
        }
        return this.myGenModelMatch.findGenClass(eClass);
    }

    private GenFeature findGenFeature(EStructuralFeature feature) {
        if (this.myGenModelMatch == null) {
            this.warnNoGenModelMatcher((EModelElement)feature);
            return null;
        }
        return this.myGenModelMatch.findGenFeature(feature);
    }

    private void warnNoGenModelMatcher(EModelElement element) {
    }

    private TypeModelFacet createModelFacet(NodeReference anm) {
        NodeMapping nodeMapping = anm.getChild();
        if (nodeMapping.getDomainContext() == null) {
            return null;
        }
        TypeModelFacet typeModelFacet = this.setupModelFacet(nodeMapping.getDomainContext(), (EStructuralFeature)anm.getContainmentFeature(), (EStructuralFeature)anm.getChildrenFeature());
        return this.setupAux(typeModelFacet, nodeMapping.getDomainSpecialization(), nodeMapping.getDomainInitializer());
    }

    private LinkModelFacet createModelFacet(LinkMapping lme) {
        if (lme.getDomainMetaElement() != null) {
            TypeLinkModelFacet mf = GMFGenFactory.eINSTANCE.createTypeLinkModelFacet();
            mf.setMetaClass(this.findGenClass(lme.getDomainMetaElement()));
            mf.setContainmentMetaFeature(this.findGenFeature((EStructuralFeature)lme.getContainmentFeature()));
            mf.setChildMetaFeature(mf.getContainmentMetaFeature());
            mf.setSourceMetaFeature(this.findGenFeature(lme.getSourceMetaFeature()));
            mf.setTargetMetaFeature(this.findGenFeature(lme.getLinkMetaFeature()));
            this.setupAux((TypeModelFacet)mf, lme.getDomainSpecialization(), lme.getDomainInitializer());
            return mf;
        }
        if (lme.getLinkMetaFeature() != null) {
            FeatureLinkModelFacet mf = GMFGenFactory.eINSTANCE.createFeatureLinkModelFacet();
            mf.setMetaFeature(this.findGenFeature(lme.getLinkMetaFeature()));
            return mf;
        }
        return null;
    }

    private GenLinkConstraints createLinkCreationConstraints(LinkConstraints constraints) {
        Constraint targetConstraint;
        LinkMapping lme = constraints.getLinkMapping();
        if (lme == null) {
            return null;
        }
        GenLinkConstraints genConstraints = GMFGenFactory.eINSTANCE.createGenLinkConstraints();
        Constraint sourceConstraint = constraints.getSourceEnd();
        if (sourceConstraint != null) {
            genConstraints.setSourceEnd(this.createGenConstraint(sourceConstraint));
        }
        if ((targetConstraint = constraints.getTargetEnd()) != null) {
            genConstraints.setTargetEnd(this.createGenConstraint(targetConstraint));
        }
        return genConstraints;
    }

    private TypeModelFacet setupModelFacet(EClass domainMetaElement, EStructuralFeature containmentFeature, EStructuralFeature childFeature) {
        TypeModelFacet mf = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        mf.setMetaClass(this.findGenClass(domainMetaElement));
        mf.setContainmentMetaFeature(this.findGenFeature(containmentFeature));
        mf.setChildMetaFeature(childFeature == null ? mf.getContainmentMetaFeature() : this.findGenFeature(childFeature));
        return mf;
    }

    private TypeModelFacet setupAux(TypeModelFacet typeModelFacet, Constraint spec, ElementInitializer init) {
        if (spec != null) {
            typeModelFacet.setModelElementSelector(this.createGenConstraint(spec));
        }
        if (init != null) {
            typeModelFacet.setModelElementInitializer(this.createElementInitializer(init));
        }
        return typeModelFacet;
    }

    private GenElementInitializer createElementInitializer(ElementInitializer elementInitializer) {
        if (elementInitializer instanceof FeatureSeqInitializer) {
            FeatureSeqInitializer fsInitializer = (FeatureSeqInitializer)elementInitializer;
            GenFeatureSeqInitializer genFsInitializer = GMFGenFactory.eINSTANCE.createGenFeatureSeqInitializer();
            for (FeatureInitializer next : fsInitializer.getInitializers()) {
                genFsInitializer.getInitializers().add((Object)this.createGenFeatureInitializer(next));
            }
            if (fsInitializer.eIsSet((EStructuralFeature)GMFMapPackage.eINSTANCE.getFeatureSeqInitializer_ElementClass())) {
                genFsInitializer.setElementClass(this.findGenClass(fsInitializer.getElementClass()));
            }
            return genFsInitializer;
        }
        return null;
    }

    private GenFeatureInitializer createGenFeatureInitializer(FeatureInitializer featureInitializer) {
        if (featureInitializer instanceof FeatureValueSpec) {
            FeatureValueSpec featureValSpec = (FeatureValueSpec)featureInitializer;
            GenFeatureValueSpec genFeatureValSpec = GMFGenFactory.eINSTANCE.createGenFeatureValueSpec();
            genFeatureValSpec.setFeature(this.findGenFeature(featureValSpec.getFeature()));
            org.eclipse.gmf.codegen.gmfgen.ValueExpression value = GMFGenFactory.eINSTANCE.createValueExpression();
            value.setBody(featureValSpec.getValue().getBody());
            genFeatureValSpec.setValue(this.bindToProvider(featureValSpec.getValue(), value));
            return genFeatureValSpec;
        }
        if (featureInitializer instanceof ReferenceNewElementSpec) {
            ReferenceNewElementSpec newElementSpec = (ReferenceNewElementSpec)featureInitializer;
            GenReferenceNewElementSpec genNewElementSpec = GMFGenFactory.eINSTANCE.createGenReferenceNewElementSpec();
            genNewElementSpec.setFeature(this.findGenFeature(newElementSpec.getFeature()));
            for (FeatureSeqInitializer next : newElementSpec.getNewElementInitializers()) {
                GenFeatureSeqInitializer nextGenFeatureSeqInitializer = (GenFeatureSeqInitializer)this.createElementInitializer((ElementInitializer)next);
                genNewElementSpec.getNewElementInitializers().add((Object)nextGenFeatureSeqInitializer);
            }
            return genNewElementSpec;
        }
        assert (false) : "Unrecognized FeatureInitializer type";
        return null;
    }

    private static GenLanguage detectGenLanguage(Language mapLang) {
        switch (mapLang.getValue()) {
            case 0: {
                return GenLanguage.OCL_LITERAL;
            }
            case 1: {
                return GenLanguage.JAVA_LITERAL;
            }
            case 2: {
                return GenLanguage.REGEXP_LITERAL;
            }
            case 3: {
                return GenLanguage.NREGEXP_LITERAL;
            }
        }
        assert (false) : mapLang;
        return GenLanguage.OCL_LITERAL;
    }

    private GenConstraint createGenConstraint(Constraint constraint) {
        if (constraint.getBody() == null) {
            return null;
        }
        GenConstraint genConstraint = GMFGenFactory.eINSTANCE.createGenConstraint();
        genConstraint.setBody(constraint.getBody());
        return this.bindToProvider((ValueExpression)constraint, genConstraint);
    }

    private GenAuditRoot createGenAuditRoot(AuditContainer ac) {
        GenAuditRoot root = GMFGenFactory.eINSTANCE.createGenAuditRoot();
        LinkedList<AuditContainer> containers = new LinkedList<AuditContainer>();
        containers.add(ac);
        HashMap pathMap = new HashMap();
        do {
            AuditContainer nextChild = (AuditContainer)containers.removeFirst();
            GenAuditContainer gac = GMFGenFactory.eINSTANCE.createGenAuditContainer();
            gac.setId(nextChild.getId());
            gac.setName(nextChild.getName());
            gac.setDescription(nextChild.getDescription());
            if (pathMap.containsKey(nextChild.getParentContainer())) {
                gac.getPath().addAll((Collection)pathMap.get(nextChild.getParentContainer()));
            }
            gac.getPath().add((Object)gac);
            if (nextChild.getChildContainers().size() > 0) {
                containers.addAll((Collection<AuditContainer>)nextChild.getChildContainers());
                pathMap.put(nextChild, new LinkedList(gac.getPath()));
            }
            root.getCategories().add((Object)gac);
            for (AuditRule next : nextChild.getAudits()) {
                GenAuditRule auditRule = this.createGenAudit(next);
                auditRule.setCategory(gac);
                root.getRules().add((Object)auditRule);
                if (auditRule.getTarget() instanceof GenDiagramElementTarget) {
                    GenDiagramElementTarget gdet = (GenDiagramElementTarget)auditRule.getTarget();
                    StringBuilder buf = new StringBuilder("Ctx");
                    for (GenCommonBase nextElement : gdet.getElement()) {
                        buf.append('_');
                        int id = nextElement.getVisualID();
                        if (id < 0) {
                            buf.append('n');
                        }
                        buf.append(id);
                    }
                    String clientContextID = buf.toString();
                    GenAuditContext ctx = null;
                    for (GenAuditContext x : root.getClientContexts()) {
                        if (!clientContextID.equals(x.getId())) continue;
                        ctx = x;
                        break;
                    }
                    if (ctx == null) {
                        ctx = GMFGenFactory.eINSTANCE.createGenAuditContext();
                        ctx.setId(clientContextID);
                        root.getClientContexts().add((Object)ctx);
                    }
                    gdet.setContextSelector(ctx);
                    continue;
                }
                if (auditRule.getTarget() == null) continue;
                if (this.myDefaultAuditContext == null) {
                    this.myDefaultAuditContext = GMFGenFactory.eINSTANCE.createGenAuditContext();
                    root.getClientContexts().add((Object)this.myDefaultAuditContext);
                }
                auditRule.getTarget().setContextSelector(this.myDefaultAuditContext);
            }
        } while (!containers.isEmpty());
        return root;
    }

    private GenAuditRule createGenAudit(AuditRule audit) {
        Constraint rule;
        GenAuditRule genAudit = GMFGenFactory.eINSTANCE.createGenAuditRule();
        genAudit.setId(audit.getId());
        genAudit.setName(audit.getName());
        genAudit.setMessage(audit.getMessage());
        genAudit.setDescription(audit.getDescription());
        genAudit.setUseInLiveMode(audit.isUseInLiveMode());
        if (audit.getTarget() != null) {
            GenRuleTarget genTarget = this.createRuleTarget((EObject)audit.getTarget());
            assert (genTarget instanceof GenAuditable);
            if (genTarget instanceof GenAuditable) {
                genAudit.setTarget((GenAuditable)genTarget);
            }
        }
        if ((rule = audit.getRule()) != null) {
            genAudit.setRule(this.createGenConstraint(rule));
        }
        Severity severity = audit.getSeverity();
        GenSeverity genSeverity = null;
        if (severity == Severity.INFO_LITERAL) {
            genSeverity = GenSeverity.INFO_LITERAL;
        } else if (severity == Severity.WARNING_LITERAL) {
            genSeverity = GenSeverity.WARNING_LITERAL;
        } else if (severity == Severity.ERROR_LITERAL) {
            genSeverity = GenSeverity.ERROR_LITERAL;
        }
        if (genSeverity != null) {
            genAudit.setSeverity(genSeverity);
        }
        return genAudit;
    }

    private GenRuleTarget createRuleTarget(EObject ruleTarget) {
        if (ruleTarget instanceof DomainElementTarget) {
            DomainElementTarget domainTarget = (DomainElementTarget)ruleTarget;
            GenDomainElementTarget genDomainTarget = GMFGenFactory.eINSTANCE.createGenDomainElementTarget();
            genDomainTarget.setElement(domainTarget.getElement() != null ? this.findGenClass(domainTarget.getElement()) : null);
            return genDomainTarget;
        }
        if (ruleTarget instanceof NotationElementTarget) {
            NotationElementTarget notationTarget = (NotationElementTarget)ruleTarget;
            GenNotationElementTarget genNotationTarget = GMFGenFactory.eINSTANCE.createGenNotationElementTarget();
            genNotationTarget.setElement(notationTarget.getElement() != null ? this.findGenClass(notationTarget.getElement()) : null);
            return genNotationTarget;
        }
        if (ruleTarget instanceof DiagramElementTarget) {
            GenDiagramElementTarget diagramTarget = GMFGenFactory.eINSTANCE.createGenDiagramElementTarget();
            MappingEntry mappingEntry = ((DiagramElementTarget)ruleTarget).getElement();
            if (mappingEntry != null) {
                LinkMapping lm = mappingEntry instanceof LinkMapping ? (LinkMapping)mappingEntry : null;
                GenLink genBase = null;
                if (lm != null) {
                    genBase = this.myHistory.find(lm);
                    assert (genBase != null);
                    if (genBase != null) {
                        diagramTarget.getElement().add((Object)genBase);
                    }
                } else {
                    NodeMapping nm = mappingEntry instanceof NodeMapping ? (NodeMapping)mappingEntry : null;
                    genBase = this.myHistory.findTopNode(nm);
                    if (genBase != null) {
                        diagramTarget.getElement().add((Object)genBase);
                    }
                    diagramTarget.getElement().addAll((Collection)Arrays.asList(this.myHistory.findChildNodes(nm)));
                }
            }
            return diagramTarget;
        }
        if (ruleTarget instanceof AuditedMetricTarget) {
            GenAuditedMetricTarget genMetricTarget = GMFGenFactory.eINSTANCE.createGenAuditedMetricTarget();
            AuditedMetricTarget metricTarget = (AuditedMetricTarget)ruleTarget;
            if (metricTarget.getMetric() != null) {
                genMetricTarget.setMetric(this.myHistory.find(metricTarget.getMetric()));
            }
            GenClassifier resultClassifier = this.myEcoreGenModelMatch.findGenClassifier((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject());
            assert (resultClassifier instanceof GenDataType);
            if (resultClassifier instanceof GenDataType) {
                genMetricTarget.setMetricValueContext((GenDataType)resultClassifier);
            }
            return genMetricTarget;
        }
        if (ruleTarget instanceof DomainAttributeTarget) {
            DomainAttributeTarget attrTarget = (DomainAttributeTarget)ruleTarget;
            GenDomainAttributeTarget genAttrTarget = GMFGenFactory.eINSTANCE.createGenDomainAttributeTarget();
            if (attrTarget.getAttribute() != null) {
                genAttrTarget.setAttribute(this.findGenFeature((EStructuralFeature)attrTarget.getAttribute()));
            }
            genAttrTarget.setNullAsError(attrTarget.isNullAsError());
            return genAttrTarget;
        }
        assert (false) : "Uknown rule target type";
        return null;
    }

    private GenMetricRule createGenMetric(MetricRule metric) {
        GenMetricRule genMetric = GMFGenFactory.eINSTANCE.createGenMetricRule();
        genMetric.setKey(metric.getKey());
        genMetric.setName(metric.getName());
        genMetric.setDescription(metric.getDescription());
        genMetric.setLowLimit(metric.getLowLimit());
        genMetric.setHighLimit(metric.getHighLimit());
        if (metric.getRule() != null) {
            org.eclipse.gmf.codegen.gmfgen.ValueExpression valueExpression = GMFGenFactory.eINSTANCE.createValueExpression();
            valueExpression.setBody(metric.getRule().getBody());
            genMetric.setRule(this.bindToProvider(metric.getRule(), valueExpression));
        }
        if (metric.getTarget() != null) {
            GenRuleTarget genTarget = this.createRuleTarget((EObject)metric.getTarget());
            assert (genTarget instanceof GenMeasurable);
            if (genTarget instanceof GenMeasurable) {
                genMetric.setTarget((GenMeasurable)genTarget);
            }
        }
        this.myHistory.log(metric, genMetric);
        return genMetric;
    }

    private <T extends org.eclipse.gmf.codegen.gmfgen.ValueExpression> T bindToProvider(ValueExpression expression, T genExpression) {
        if (this.myProcessedExpressions.containsKey(expression)) {
            org.eclipse.gmf.codegen.gmfgen.ValueExpression reuse = this.myProcessedExpressions.get(expression);
            return (T)reuse;
        }
        GenLanguage language = DiagramGenModelTransformer.detectGenLanguage(expression.getLanguage());
        if (language == null) {
            return genExpression;
        }
        GenExpressionProviderContainer providerContainer = this.getGenEssence().getExpressionProviders();
        if (providerContainer == null) {
            providerContainer = GMFGenFactory.eINSTANCE.createGenExpressionProviderContainer();
            this.getGenEssence().setExpressionProviders(providerContainer);
        }
        GenExpressionProviderBase provider = null;
        for (GenExpressionProviderBase nextProvider : providerContainer.getProviders()) {
            if (!language.equals((Object)nextProvider.getLanguage())) continue;
            provider = nextProvider;
            break;
        }
        if (provider == null) {
            provider = this.createExpressionProvider(language);
            providerContainer.getProviders().add((Object)provider);
        }
        provider.getExpressions().add(genExpression);
        this.myProcessedExpressions.put(expression, genExpression);
        return genExpression;
    }

    private GenExpressionProviderBase createExpressionProvider(GenLanguage language) {
        GenJavaExpressionProvider newProvider = null;
        if (GenLanguage.JAVA_LITERAL.equals((Object)language)) {
            newProvider = GMFGenFactory.eINSTANCE.createGenJavaExpressionProvider();
        } else if (GenLanguage.OCL_LITERAL.equals((Object)language)) {
            GenExpressionInterpreter oclProvider = GMFGenFactory.eINSTANCE.createGenExpressionInterpreter();
            oclProvider.setLanguage(language);
            newProvider = oclProvider;
        } else if (GenLanguage.REGEXP_LITERAL.equals((Object)language) || GenLanguage.NREGEXP_LITERAL.equals((Object)language)) {
            GenExpressionInterpreter regexpProvider = GMFGenFactory.eINSTANCE.createGenExpressionInterpreter();
            regexpProvider.setLanguage(language);
            newProvider = regexpProvider;
        } else {
            newProvider = GMFGenFactory.eINSTANCE.createGenExpressionInterpreter();
        }
        assert (newProvider != null);
        return newProvider;
    }

    private void addPreferencePages(GenDiagram diagram) {
        GenPreferencePage general = this.createStandardPreferencePage(diagram, "general", String.valueOf(diagram.getEditorGen().getModelID()) + " Diagram", StandardPreferencePages.GENERAL_LITERAL);
        diagram.getPreferencePages().add((Object)general);
        general.getChildren().add((Object)this.createStandardPreferencePage(diagram, "appearance", "Appearance", StandardPreferencePages.APPEARANCE_LITERAL));
        general.getChildren().add((Object)this.createStandardPreferencePage(diagram, "connections", "Connections", StandardPreferencePages.CONNECTIONS_LITERAL));
        general.getChildren().add((Object)this.createStandardPreferencePage(diagram, "printing", "Printing", StandardPreferencePages.PRINTING_LITERAL));
        general.getChildren().add((Object)this.createStandardPreferencePage(diagram, "rulersAndGrid", "Rulers And Grid", StandardPreferencePages.RULERS_AND_GRID_LITERAL));
        general.getChildren().add((Object)this.createStandardPreferencePage(diagram, "pathmaps", "Pathmaps", StandardPreferencePages.PATHMAPS_LITERAL));
    }

    private GenPreferencePage createStandardPreferencePage(GenDiagram diagram, String id, String name, StandardPreferencePages kind) {
        GenStandardPreferencePage page = GMFGenFactory.eINSTANCE.createGenStandardPreferencePage();
        page.setID(String.valueOf(diagram.getEditorGen().getPlugin().getID()) + '.' + id);
        page.setName(name);
        page.setKind(kind);
        return page;
    }

    private void addContributions(GenApplication application) {
        GenMenuManager mainMenu = GMFGenFactory.eINSTANCE.createGenMenuManager();
        mainMenu.getItems().add((Object)this.createFileMenu((List<GenContributionItem>)application.getSharedContributionItems()));
        mainMenu.getItems().add((Object)this.createEditMenu((List<GenContributionItem>)application.getSharedContributionItems()));
        mainMenu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS"));
        mainMenu.getItems().add((Object)this.createWindowMenu((List<GenContributionItem>)application.getSharedContributionItems()));
        mainMenu.getItems().add((Object)this.createHelpMenu((List<GenContributionItem>)application.getSharedContributionItems()));
        application.setMainMenu(mainMenu);
        GenToolBarManager mainToolBar = GMFGenFactory.eINSTANCE.createGenToolBarManager();
        mainToolBar.getItems().add((Object)this.createGroupMarker("\"group.file\""));
        mainToolBar.getItems().add((Object)this.createFileToolBar((List<GenContributionItem>)application.getSharedContributionItems()));
        mainToolBar.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS"));
        mainToolBar.getItems().add((Object)this.createGroupMarker("\"group.nav\""));
        mainToolBar.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.GROUP_EDITOR"));
        mainToolBar.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.GROUP_HELP"));
        mainToolBar.getItems().add((Object)this.createHelpToolBar((List<GenContributionItem>)application.getSharedContributionItems()));
        application.setMainToolBar(mainToolBar);
    }

    private GenGroupMarker createGroupMarker(String groupName) {
        GenGroupMarker gm = GMFGenFactory.eINSTANCE.createGenGroupMarker();
        gm.setGroupName(groupName);
        return gm;
    }

    private GenSeparator createSeparator(String groupName) {
        GenSeparator s = GMFGenFactory.eINSTANCE.createGenSeparator();
        s.setGroupName(groupName);
        return s;
    }

    private GenActionFactoryContributionItem createActionFactoryItem(String name) {
        GenActionFactoryContributionItem item = GMFGenFactory.eINSTANCE.createGenActionFactoryContributionItem();
        item.setName(name);
        return item;
    }

    private GenSharedContributionItem createSharedItem(List<GenContributionItem> sharedItems, GenContributionItem actualItem) {
        GenSharedContributionItem sitem = GMFGenFactory.eINSTANCE.createGenSharedContributionItem();
        if (actualItem instanceof GenActionFactoryContributionItem) {
            GenActionFactoryContributionItem afActualItem = (GenActionFactoryContributionItem)actualItem;
            for (GenContributionItem item : sharedItems) {
                GenActionFactoryContributionItem afItem;
                if (!(item instanceof GenActionFactoryContributionItem) || !(afItem = (GenActionFactoryContributionItem)item).getName().equals(afActualItem.getName())) continue;
                sitem.setActualItem((GenContributionItem)afItem);
                actualItem = null;
                break;
            }
        }
        if (actualItem != null) {
            sitem.setActualItem(actualItem);
            sharedItems.add(actualItem);
        }
        return sitem;
    }

    private GenMenuManager createFileMenu(List<GenContributionItem> sharedItems) {
        GenMenuManager menu = GMFGenFactory.eINSTANCE.createGenMenuManager();
        menu.setID("org.eclipse.ui.IWorkbenchActionConstants.M_FILE");
        menu.setName("&File");
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.FILE_START"));
        GenMenuManager newMenu = GMFGenFactory.eINSTANCE.createGenMenuManager();
        newMenu.setID("\"new\"");
        newMenu.setName("&New");
        newMenu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS"));
        menu.getItems().add((Object)newMenu);
        menu.getItems().add((Object)GMFGenFactory.eINSTANCE.createGenSeparator());
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS"));
        menu.getItems().add((Object)GMFGenFactory.eINSTANCE.createGenSeparator());
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("CLOSE")));
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("CLOSE_ALL")));
        menu.getItems().add((Object)GMFGenFactory.eINSTANCE.createGenSeparator());
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("SAVE")));
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("SAVE_AS")));
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("SAVE_ALL")));
        menu.getItems().add((Object)GMFGenFactory.eINSTANCE.createGenSeparator());
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("QUIT")));
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.FILE_END"));
        return menu;
    }

    private GenMenuManager createEditMenu(List<GenContributionItem> sharedItems) {
        GenMenuManager menu = GMFGenFactory.eINSTANCE.createGenMenuManager();
        menu.setID("org.eclipse.ui.IWorkbenchActionConstants.M_EDIT");
        menu.setName("&Edit");
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.EDIT_START"));
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("UNDO")));
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("REDO")));
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.UNDO_EXT"));
        menu.getItems().add((Object)GMFGenFactory.eINSTANCE.createGenSeparator());
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("CUT")));
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("COPY")));
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("PASTE")));
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.CUT_EXT"));
        menu.getItems().add((Object)GMFGenFactory.eINSTANCE.createGenSeparator());
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("DELETE")));
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("SELECT_ALL")));
        menu.getItems().add((Object)GMFGenFactory.eINSTANCE.createGenSeparator());
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.ADD_EXT"));
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.EDIT_END"));
        menu.getItems().add((Object)this.createSeparator("org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS"));
        return menu;
    }

    private GenMenuManager createWindowMenu(List<GenContributionItem> sharedItems) {
        GenMenuManager menu = GMFGenFactory.eINSTANCE.createGenMenuManager();
        menu.setID("org.eclipse.ui.IWorkbenchActionConstants.M_WINDOW");
        menu.setName("&Window");
        menu.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("OPEN_NEW_WINDOW")));
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS"));
        return menu;
    }

    private GenMenuManager createHelpMenu(List<GenContributionItem> sharedItems) {
        GenMenuManager menu = GMFGenFactory.eINSTANCE.createGenMenuManager();
        menu.setID("org.eclipse.ui.IWorkbenchActionConstants.M_HELP");
        menu.setName("&Help");
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.HELP_START"));
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.HELP_END"));
        menu.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS"));
        return menu;
    }

    private GenToolBarManager createFileToolBar(List<GenContributionItem> sharedItems) {
        GenToolBarManager toolBar = GMFGenFactory.eINSTANCE.createGenToolBarManager();
        toolBar.setID("org.eclipse.ui.IWorkbenchActionConstants.TOOLBAR_FILE");
        toolBar.getItems().add((Object)this.createSeparator("org.eclipse.ui.IWorkbenchActionConstants.NEW_GROUP"));
        toolBar.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.NEW_EXT"));
        toolBar.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.SAVE_GROUP"));
        toolBar.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("SAVE")));
        toolBar.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.SAVE_EXT"));
        toolBar.getItems().add((Object)this.createSharedItem(sharedItems, (GenContributionItem)this.createActionFactoryItem("PRINT")));
        toolBar.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.PRINT_EXT"));
        toolBar.getItems().add((Object)this.createSeparator("org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS"));
        return toolBar;
    }

    private GenToolBarManager createHelpToolBar(List<GenContributionItem> sharedItems) {
        GenToolBarManager toolBar = GMFGenFactory.eINSTANCE.createGenToolBarManager();
        toolBar.setID("org.eclipse.ui.IWorkbenchActionConstants.TOOLBAR_HELP");
        toolBar.getItems().add((Object)this.createSeparator("org.eclipse.ui.IWorkbenchActionConstants.GROUP_HELP"));
        toolBar.getItems().add((Object)this.createGroupMarker("org.eclipse.ui.IWorkbenchActionConstants.GROUP_APP"));
        return toolBar;
    }
}

