/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.internal.bridge.History;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.MetricRule;
import org.eclipse.gmf.mappings.NodeMapping;

public class HistoryTest
extends TestCase {
    private History history;
    private NodeMapping nodeMapping;
    private GenTopLevelNode topGenNode;
    private GenChildNode childGenNode;
    private LinkMapping linkMapping;
    private GenLink genLink;

    public HistoryTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.history = new History();
        this.nodeMapping = GMFMapFactory.eINSTANCE.createNodeMapping();
        this.topGenNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        this.childGenNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        this.linkMapping = GMFMapFactory.eINSTANCE.createLinkMapping();
        this.genLink = GMFGenFactory.eINSTANCE.createGenLink();
    }

    public void testFindLink() throws Exception {
        HistoryTest.assertNull((Object)this.history.find(this.linkMapping));
        this.history.log(this.linkMapping, this.genLink);
        HistoryTest.assertSame((Object)this.genLink, (Object)this.history.find(this.linkMapping));
        HistoryTest.assertNotNull((Object)this.genLink);
        HistoryTest.assertTrue((boolean)this.history.isKnown(this.linkMapping));
        this.history.purge();
        HistoryTest.assertNull((Object)this.history.find(this.linkMapping));
    }

    public void testFindChildNode() throws Exception {
        HistoryTest.assertTrue((this.history.findChildNodes(this.nodeMapping).length == 0 ? 1 : 0) != 0);
        this.history.log(this.nodeMapping, this.childGenNode);
        HistoryTest.assertSame((Object)this.childGenNode, (Object)this.history.findChildNodes(this.nodeMapping)[0]);
        HistoryTest.assertNotNull((Object)this.childGenNode);
        HistoryTest.assertSame((Object)this.childGenNode, (Object)this.history.find(this.nodeMapping)[0]);
        HistoryTest.assertNull((Object)this.history.findTopNode(this.nodeMapping));
        HistoryTest.assertFalse((boolean)this.history.isKnownTopNode(this.nodeMapping));
        HistoryTest.assertTrue((boolean)this.history.isKnownChildNode(this.nodeMapping));
        this.history.purge();
        HistoryTest.assertTrue((this.history.find(this.nodeMapping).length == 0 ? 1 : 0) != 0);
    }

    public void testFindMultipleChildNodes() throws Exception {
        HistoryTest.assertTrue((this.history.findChildNodes(this.nodeMapping).length == 0 ? 1 : 0) != 0);
        GenChildNode anotherChildGenNode = GMFGenFactory.eINSTANCE.createGenChildNode();
        this.history.log(this.nodeMapping, this.childGenNode);
        this.history.log(this.nodeMapping, anotherChildGenNode);
        HistoryTest.assertTrue((boolean)this.history.isKnownChildNode(this.nodeMapping));
        HistoryTest.assertNotNull((Object)this.childGenNode);
        HistoryTest.assertNotNull((Object)anotherChildGenNode);
        List<GenChildNode> l1 = Arrays.asList(this.history.findChildNodes(this.nodeMapping));
        HistoryTest.assertTrue((boolean)l1.contains(this.childGenNode));
        HistoryTest.assertTrue((boolean)l1.contains(anotherChildGenNode));
        List<GenNode> l2 = Arrays.asList(this.history.find(this.nodeMapping));
        HistoryTest.assertTrue((boolean)l2.contains(this.childGenNode));
        HistoryTest.assertTrue((boolean)l2.contains(anotherChildGenNode));
        this.history.purge();
        HistoryTest.assertTrue((this.history.find(this.nodeMapping).length == 0 ? 1 : 0) != 0);
    }

    public void testFindTopNode() throws Exception {
        HistoryTest.assertNull((Object)this.history.findTopNode(this.nodeMapping));
        this.history.log(this.nodeMapping, this.topGenNode);
        HistoryTest.assertSame((Object)this.topGenNode, (Object)this.history.findTopNode(this.nodeMapping));
        HistoryTest.assertNotNull((Object)this.topGenNode);
        HistoryTest.assertSame((Object)this.topGenNode, (Object)this.history.find(this.nodeMapping)[0]);
        HistoryTest.assertTrue((this.history.findChildNodes(this.nodeMapping).length == 0 ? 1 : 0) != 0);
        HistoryTest.assertTrue((boolean)this.history.isKnown(this.nodeMapping));
        HistoryTest.assertTrue((boolean)this.history.isKnownTopNode(this.nodeMapping));
        HistoryTest.assertFalse((boolean)this.history.isKnownChildNode(this.nodeMapping));
        this.history.purge();
        HistoryTest.assertTrue((this.history.find(this.nodeMapping).length == 0 ? 1 : 0) != 0);
    }

    public void testMultipleElements() throws Exception {
        this.history.log(GMFMapFactory.eINSTANCE.createNodeMapping(), GMFGenFactory.eINSTANCE.createGenTopLevelNode());
        this.history.log(this.nodeMapping, this.topGenNode);
        HistoryTest.assertSame((Object)this.topGenNode, (Object)this.history.find(this.nodeMapping)[0]);
        this.history.log(GMFMapFactory.eINSTANCE.createLinkMapping(), GMFGenFactory.eINSTANCE.createGenLink());
        this.history.log(this.linkMapping, this.genLink);
        HistoryTest.assertSame((Object)this.genLink, (Object)this.history.find(this.linkMapping));
    }

    public void testMetrics() throws Exception {
        MetricRule metric = GMFMapFactory.eINSTANCE.createMetricRule();
        GenMetricRule genMetric = GMFGenFactory.eINSTANCE.createGenMetricRule();
        HistoryTest.assertNull((Object)this.history.find(metric));
        this.history.log(metric, genMetric);
        HistoryTest.assertSame((Object)genMetric, (Object)this.history.find(metric));
        this.history.purge();
        HistoryTest.assertNull((Object)this.history.find(metric));
    }
}

