/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gef;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.rt.AbstractCanvasTest;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class AbstractDiagramEditorTest
extends AbstractCanvasTest {
    private IProject myProject;
    private IEditorPart myEditor;
    private IFile myDiagramFile;

    public AbstractDiagramEditorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myProject = this.createProject();
        this.myDiagramFile = this.createDiagram();
        this.myEditor = this.openEditor(this.myDiagramFile);
    }

    protected IProject getProject() {
        return this.myProject;
    }

    protected IEditorPart getEditor() {
        return this.myEditor;
    }

    protected GeneratorConfiguration.ViewerConfiguration createViewerConfiguration() throws Exception {
        return this.createViewerConfiguration(this.myEditor);
    }

    protected GeneratorConfiguration.ViewerConfiguration createViewerConfiguration(IEditorPart editorPart) throws Exception {
        GraphicalViewer viewer = (GraphicalViewer)editorPart.getAdapter(GraphicalViewer.class);
        return this.getSetup().getGeneratorConfiguration().createViewerConfiguration(this.getSetup(), (EditPartViewer)viewer);
    }

    protected void tearDown() throws Exception {
        this.closeEditor(this.myEditor);
        this.myProject = null;
        this.myDiagramFile = null;
        super.tearDown();
    }

    protected void closeEditor(IEditorPart editor) {
        this.myEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        this.redispatchEvents();
    }

    protected final void redispatchEvents() {
        boolean t = Utils.dispatchDisplayMessages(3);
        AbstractDiagramEditorTest.assertTrue((String)"Display message redispatch was not expected to end by timeout", (boolean)t);
    }

    protected IProject createProject() {
        String projectName = this.getUniqueString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        AbstractDiagramEditorTest.assertFalse((String)("Project with this name already present in the workspace: " + projectName), (boolean)project.exists());
        try {
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            AbstractDiagramEditorTest.fail((String)e.getMessage());
        }
        AbstractDiagramEditorTest.assertTrue((String)("Project was not created: " + projectName), (boolean)project.exists());
        return project;
    }

    protected void deleteProject() throws CoreException {
        if (this.getProject() != null) {
            if (this.getProject().isOpen()) {
                this.getProject().close((IProgressMonitor)new NullProgressMonitor());
            }
            if (this.getProject().exists()) {
                this.getProject().delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected IFile createDiagram() throws Exception {
        return this.createDiagram(this.getSetup().getGenModel().getGenDiagram().getEditorGen().isSameFileForDiagramAndModel());
    }

    protected IFile createDiagram(boolean storeModelInDiagramFile) throws Exception {
        GenDiagram genDiagram = this.getSetup().getGenModel().getGenDiagram();
        String uniqueName = this.getUniqueString();
        String diagramFileName = String.valueOf(uniqueName) + "." + genDiagram.getEditorGen().getDiagramFileExtension();
        IFile diagramFile = this.getProject().getFile(diagramFileName);
        AbstractDiagramEditorTest.assertFalse((String)"Diagram file was already created", (boolean)diagramFile.exists());
        IFile modelFile = null;
        if (!storeModelInDiagramFile) {
            IPath diagramFilePath = diagramFile.getProjectRelativePath();
            IPath modelFilePath = diagramFilePath.removeFileExtension().addFileExtension(genDiagram.getEditorGen().getDomainFileExtension());
            modelFile = this.getProject().getFile(modelFilePath);
            AbstractDiagramEditorTest.assertFalse((String)"Model file was already created", (boolean)modelFile.exists());
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource diagramResource = resourceSet.createResource(URI.createPlatformResourceURI((String)diagramFile.getFullPath().toOSString(), (boolean)true));
        Resource modelResource = modelFile != null ? resourceSet.createResource(URI.createPlatformResourceURI((String)modelFile.getFullPath().toOSString(), (boolean)true)) : null;
        EObject domainDiagramElement = this.createDiagramDomainObject();
        if (modelResource != null) {
            modelResource.getContents().add((Object)domainDiagramElement);
        } else {
            diagramResource.getContents().add((Object)domainDiagramElement);
        }
        Diagram diagram = this.getSetup().getGeneratorConfiguration().createDiagram(domainDiagramElement, this.getSetup());
        AbstractDiagramEditorTest.assertNotNull((String)"Diagram was not created", (Object)diagram);
        if (diagram != null) {
            diagramResource.getContents().add((Object)diagram);
            diagram.setName(uniqueName);
            diagram.setElement(domainDiagramElement);
        }
        try {
            if (modelResource != null) {
                modelResource.save(Collections.EMPTY_MAP);
            }
            diagramResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            AbstractDiagramEditorTest.fail((String)e.getMessage());
        }
        return diagramFile;
    }

    protected EObject createDiagramDomainObject() throws Exception {
        GenClass diagramElementGenClass = this.getSetup().getGenModel().getGenDiagram().getDomainDiagramElement();
        GenPackage domainGenPackage = diagramElementGenClass.getGenPackage();
        Class factoryInterface = this.getSetup().getGenProject().getBundle().loadClass(domainGenPackage.getQualifiedFactoryInterfaceName());
        AbstractDiagramEditorTest.assertNotNull((String)"Factory interface not found", (Object)factoryInterface);
        Field accessor = null;
        accessor = factoryInterface.getField(domainGenPackage.getFactoryInstanceName());
        AbstractDiagramEditorTest.assertNotNull((String)"Accessor field not found", (Object)accessor);
        Object factory = null;
        factory = accessor.get(null);
        AbstractDiagramEditorTest.assertNotNull((String)"Factory unavailable", (Object)factory);
        Method createMethod = null;
        createMethod = factory.getClass().getMethod("create" + diagramElementGenClass.getName(), new Class[0]);
        AbstractDiagramEditorTest.assertNotNull((String)"Create method unavailable", (Object)createMethod);
        EObject domainDiagramElement = null;
        domainDiagramElement = (EObject)createMethod.invoke(factory, new Object[0]);
        AbstractDiagramEditorTest.assertNotNull((String)"Domain diagram element was not created", (Object)domainDiagramElement);
        return domainDiagramElement;
    }

    protected IEditorPart openEditor(IFile diagramFile) {
        try {
            IEditorDescriptor editorDesc = IDE.getEditorDescriptor((IFile)diagramFile, (boolean)true);
            IEditorPart result = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(diagramFile), editorDesc.getId(), true);
            return result;
        }
        catch (PartInitException e) {
            AbstractDiagramEditorTest.fail((String)e.getMessage());
            return null;
        }
    }

    protected final String getUniqueString() {
        return "AbstractDiagramEditorTest_" + String.valueOf(System.currentTimeMillis());
    }
}

