/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

class JobTracker
extends JobChangeAdapter {
    private final boolean[] condition = new boolean[1];
    private final List<Job> knownJobs = Collections.synchronizedList(new LinkedList());
    private boolean stopCollectingJobs = false;

    public JobTracker() {
        this.fixCondition();
    }

    public void scheduled(IJobChangeEvent event) {
        if (!this.stopCollectingJobs) {
            this.knownJobs.add(event.getJob());
            this.fixCondition();
        }
    }

    public void done(IJobChangeEvent event) {
        if (this.knownJobs.remove(event.getJob())) {
            this.fixCondition();
        }
    }

    private void fixCondition() {
        this.condition[0] = this.knownJobs.size() != 0;
    }

    public int getJobsCount() {
        return this.knownJobs.size();
    }

    public boolean[] getNonEmptyCondition() {
        return this.condition;
    }

    public void start() {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
    }

    public void freeze() {
        this.stopCollectingJobs = true;
    }

    public void stop() {
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
        this.knownJobs.clear();
    }
}

