/*******************************************************************************
 * Copyright (c) 2005 - 2006 IBM Corporation & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Chris Aniszczyk - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.jet.JETAddNatureOperation;
import org.eclipse.emf.codegen.jet.editor.JETEditorPlugin;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

/**
 * @author Chris Aniszczyk
 * @since 1.0.0
 */
public class JETProjectWizard extends Wizard implements INewWizard {
	protected IWorkbench workbench;
	protected IProject project;
	protected WizardNewProjectCreationPage newProjectCreationPage;
	protected NewJavaProjectWizardPage newJavaProjectWizardPage;
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.workbench = workbench;
	}
	public void addPages() {
		newProjectCreationPage = new WizardNewProjectCreationPage("NewProjectCreationPage") {
			protected boolean validatePage() {
				if(super.validatePage()) {
					return true;
				}
				else {
					return false;
				}
			}
		};
		
		newJavaProjectWizardPage = 
			new NewJavaProjectWizardPage(
					ResourcesPlugin.getWorkspace().getRoot(), 
					newProjectCreationPage);
		
		newProjectCreationPage.setTitle("JET Project");
		newProjectCreationPage.setDescription("Create a new JET Project");
		addPage(newProjectCreationPage);
		addPage(newJavaProjectWizardPage);
	}
	
	public boolean performFinish() {
		IRunnableWithProgress addJETNatureOperation = 
			new WorkspaceModifyOperation() {
			public void execute(IProgressMonitor monitor) {
				try {
					IProject project = newProjectCreationPage.getProjectHandle();
					Collection collection = new ArrayList();
					collection.add(project);
					JETAddNatureOperation addNature = new JETAddNatureOperation(collection);
					addNature.run(monitor);
				} 
				catch (CoreException e) {
					JETEditorPlugin.getDefault().log(e);
				} 
			}
		};
		try {
			getContainer().run(false, true, newJavaProjectWizardPage.getRunnable());
			getContainer().run(false, true, addJETNatureOperation);
		} catch (InvocationTargetException e) {
			JETEditorPlugin.getDefault().log(e);
		} catch (InterruptedException e) {
			JETEditorPlugin.getDefault().log(e);
		}
		return true;
	}
}
