/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.util.hovers;

import java.io.StringReader;

import org.eclipse.emf.codegen.jet.editor.codeassist.JETTemplateCompletionProcessor;
import org.eclipse.emf.codegen.jet.editor.presentation.JETTextEditor;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorPart;

/**
 * @author jcheuoua
 * 
 * To change the template for this generated type comment go to Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code
 * and Comments
 * @version $Revision: 1.2 $
 */
public class JETTemplateScriptletHover implements IJavaEditorTextHover {

  private IEditorPart jetEditor;

  /**
   * Constructor for JETTemplateScriptletHover.
   * 
   * @param editor
   *          JETTextEditor
   */
  public JETTemplateScriptletHover(JETTextEditor editor) {
    jetEditor = editor;
  }

  /**
   * Method setEditor.
   * 
   * @param editor
   *          IEditorPart
   * @see org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover#setEditor(IEditorPart)
   */
  public void setEditor(IEditorPart editor) {
    jetEditor = editor;
  }

  /**
   * Method getHoverInfo.
   * 
   * @param textViewer
   *          ITextViewer
   * @param hoverRegion
   *          IRegion
   * @return String
   * @see org.eclipse.jface.text.ITextHover#getHoverInfo(ITextViewer, IRegion)
   */
  public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
    ProposalThread pt = new ProposalThread(textViewer, hoverRegion);
    textViewer.getTextWidget().getDisplay().syncExec(pt);
    if (pt.proposals != null && pt.proposals.length == 1) {
      ICompletionProposal p = pt.proposals[0];
      return createHoverInfo(p);
    } else {
      return null;
    }
  }

  /**
   * Method createHoverInfo.
   * 
   * @param p
   *          ICompletionProposal
   * @return String
   */
  private String createHoverInfo(ICompletionProposal p) {
    StringBuffer buffer = new StringBuffer();
    HTMLPrinter.addSmallHeader(buffer, p.getDisplayString());
    if (p.getAdditionalProposalInfo() != null) {
      StringReader reader = new StringReader(p.getAdditionalProposalInfo());
      HTMLPrinter.addParagraph(buffer, new JavaDoc2HTMLTextReader(reader));
    }
    return buffer.toString();
  }

  /**
   * Method getHoverRegion.
   * 
   * @param textViewer
   *          ITextViewer
   * @param offset
   *          int
   * @return IRegion
   * @see org.eclipse.jface.text.ITextHover#getHoverRegion(ITextViewer, int)
   */
  public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
    return JavaWordFinder.findWord(textViewer.getDocument(), offset);
  }

  /**
   */
  private class ProposalThread implements Runnable {
    /**
     * Method run.
     * 
     * @see java.lang.Runnable#run()
     */
    public void run() {
      JETTemplateCompletionProcessor processor = new JETTemplateCompletionProcessor(
          (JETTextEditor) JETTemplateScriptletHover.this.jetEditor);
      proposals = processor.computeCompletionProposals(textViewer, hoverRegion.getOffset());
    }

    protected ICompletionProposal proposals[];

    private ITextViewer textViewer;

    private IRegion hoverRegion;

    /**
     * Constructor for ProposalThread.
     * 
     * @param textViewer
     *          ITextViewer
     * @param hoverRegion
     *          IRegion
     */
    public ProposalThread(ITextViewer textViewer, IRegion hoverRegion) {
      proposals = null;
      this.textViewer = null;
      this.textViewer = textViewer;
      this.hoverRegion = hoverRegion;
    }
  }
}
