/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainChange;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class ReferenceConstraint
implements BinaryConstraint {
    final Variable targetVariable;
    final EReference reference;
    final Object index;
    final boolean isConstantIndex;

    public ReferenceConstraint(Variable target, EReference reference, Object index, boolean isConstantIndex) {
        this.targetVariable = target;
        this.reference = reference;
        this.index = index;
        this.isConstantIndex = isConstantIndex;
    }

    public ReferenceConstraint(Variable target, EReference reference) {
        this(target, reference, null, true);
    }

    @Override
    public boolean check(DomainSlot source, DomainSlot target) {
        List<EObject> targetObjects;
        if (!source.locked) {
            return false;
        }
        if (this.reference.isMany()) {
            targetObjects = (List<EObject>)source.value.eGet((EStructuralFeature)this.reference);
            if (targetObjects instanceof EMap && this.targetVariable.typeConstraint != null && this.targetVariable.typeConstraint.type != null) {
                EMap map = (EMap)targetObjects;
                EAttribute keyAttribute = (EAttribute)this.targetVariable.typeConstraint.type.getEStructuralFeature("key");
                for (AttributeConstraint attributeConstraint : this.targetVariable.attributeConstraints) {
                    if (keyAttribute != attributeConstraint.attribute) continue;
                    BasicEMap.Entry to = null;
                    try {
                        if (attributeConstraint.isConstantValue) {
                            to = this.getEntryFromMap(map, attributeConstraint.value);
                        } else {
                            String paramName = (String)attributeConstraint.value;
                            if (source.conditionHandler.isSet(paramName)) {
                                Object paramValue = source.conditionHandler.getParameter(paramName);
                                to = this.getEntryFromMap(map, paramValue);
                            }
                        }
                        targetObjects = Collections.singletonList((EObject)to);
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            if (targetObjects.isEmpty()) {
                return false;
            }
        } else {
            EObject obj = (EObject)source.value.eGet((EStructuralFeature)this.reference);
            if (obj == null) {
                return false;
            }
            targetObjects = Collections.singletonList(obj);
        }
        Integer calculatedIndex = null;
        if (this.isConstantIndex) {
            calculatedIndex = this.index != null ? Integer.valueOf(((Number)this.index).intValue()) : null;
        } else {
            String parameterName = (String)this.index;
            if (source.conditionHandler.isSet(parameterName)) {
                calculatedIndex = ((Number)source.conditionHandler.getParameter(parameterName)).intValue();
            }
        }
        if (calculatedIndex != null && calculatedIndex < 0) {
            calculatedIndex = targetObjects.size() + calculatedIndex;
        }
        if (target.locked) {
            if (!this.isConstantIndex && !source.conditionHandler.isSet((String)this.index)) {
                calculatedIndex = targetObjects.indexOf(target.value);
                if (target.conditionHandler.setParameter((String)this.index, calculatedIndex)) {
                    target.initializedParameters.add((String)this.index);
                    return true;
                }
                target.conditionHandler.unsetParameter((String)this.index);
                return false;
            }
            return calculatedIndex != null ? targetObjects.indexOf(target.value) == calculatedIndex.intValue() : targetObjects.contains(target.value);
        }
        DomainChange change = new DomainChange(target, target.temporaryDomain);
        source.remoteChangeMap.put(this, change);
        if (calculatedIndex != null) {
            if (calculatedIndex >= 0 && calculatedIndex < targetObjects.size()) {
                target.temporaryDomain = new ArrayList<EObject>();
                target.temporaryDomain.add(targetObjects.get(calculatedIndex));
            } else {
                target.temporaryDomain = Collections.emptyList();
            }
        } else {
            target.temporaryDomain = new ArrayList<EObject>(targetObjects);
        }
        if (change.originalValues != null) {
            target.temporaryDomain.retainAll(change.originalValues);
        }
        return !target.temporaryDomain.isEmpty();
    }

    private BasicEMap.Entry getEntryFromMap(EMap map, Object paramValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> mapClass = map.getClass();
        while (mapClass != null && !mapClass.equals(BasicEMap.class)) {
            mapClass = mapClass.getSuperclass();
        }
        if (mapClass == null) {
            throw new NoSuchMethodException("Map class does not subclass from BasicEMap which is required to call hashOf, indexOf and entryForKey methods");
        }
        Method ensureEntryDataExists = mapClass.getDeclaredMethod("ensureEntryDataExists", new Class[0]);
        ensureEntryDataExists.setAccessible(true);
        ensureEntryDataExists.invoke((Object)map, new Object[0]);
        Method hashOf = mapClass.getDeclaredMethod("hashOf", Object.class);
        hashOf.setAccessible(true);
        int hash = (Integer)hashOf.invoke((Object)map, paramValue);
        Method indexOf = mapClass.getDeclaredMethod("indexOf", Integer.TYPE);
        indexOf.setAccessible(true);
        int index = (Integer)indexOf.invoke((Object)map, hash);
        Method entryForKey = mapClass.getDeclaredMethod("entryForKey", Integer.TYPE, Integer.TYPE, Object.class);
        entryForKey.setAccessible(true);
        BasicEMap.Entry entry = (BasicEMap.Entry)entryForKey.invoke((Object)map, index, hash, paramValue);
        return entry;
    }
}

