/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.Assignment;
import org.eclipse.emf.henshin.interpreter.Change;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.impl.AbstractApplicationImpl;
import org.eclipse.emf.henshin.interpreter.impl.MatchImpl;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterKind;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;

public class RuleApplicationImpl
extends AbstractApplicationImpl
implements RuleApplication {
    protected Match partialMatch;
    protected Match completeMatch;
    protected Match resultMatch;
    protected boolean isCompleteMatchDerived = false;
    protected Change change;
    protected boolean isExecuted = false;
    protected boolean isUndone = false;

    public RuleApplicationImpl(Engine engine) {
        super(engine);
    }

    public RuleApplicationImpl(Engine engine, EGraph graph, Rule rule, Assignment partialMatch) {
        this(engine);
        this.setEGraph(graph);
        this.setRule(rule);
        this.setAssignment(partialMatch);
    }

    @Override
    public boolean execute(ApplicationMonitor monitor) {
        if (this.unit == null) {
            throw new NullPointerException("No transformation unit set");
        }
        if (this.isExecuted) {
            if (this.isCompleteMatchDerived) {
                this.completeMatch = null;
                this.isCompleteMatchDerived = false;
            }
            this.isExecuted = false;
            this.isUndone = false;
            this.change = null;
            this.resultMatch = null;
        }
        if (this.completeMatch == null) {
            this.completeMatch = this.engine.findMatches((Rule)this.unit, this.graph, this.partialMatch).iterator().next();
            this.isCompleteMatchDerived = true;
        }
        if (this.completeMatch == null) {
            if (monitor != null) {
                monitor.notifyExecute(this, false);
            }
            return false;
        }
        this.resultMatch = new MatchImpl((Rule)this.unit, true);
        this.change = this.engine.createChange((Rule)this.unit, this.graph, this.completeMatch, this.resultMatch);
        if (this.change == null) {
            if (monitor != null) {
                monitor.notifyExecute(this, false);
            }
            return false;
        }
        this.change.applyAndReverse();
        this.isExecuted = true;
        if (monitor != null) {
            monitor.notifyExecute(this, true);
        }
        return true;
    }

    @Override
    public boolean undo(ApplicationMonitor monitor) {
        boolean success = false;
        if (this.isExecuted && !this.isUndone) {
            this.change.applyAndReverse();
            this.isUndone = true;
            success = true;
        }
        if (monitor != null) {
            monitor.notifyUndo(this, success);
        }
        return success;
    }

    @Override
    public boolean redo(ApplicationMonitor monitor) {
        boolean success = false;
        if (this.isExecuted && this.isUndone) {
            this.change.applyAndReverse();
            this.isUndone = false;
            success = true;
        }
        if (monitor != null) {
            monitor.notifyUndo(this, success);
        }
        return success;
    }

    @Override
    public Rule getRule() {
        return (Rule)this.unit;
    }

    @Override
    public void setRule(Rule rule) {
        this.setUnit((Unit)rule);
    }

    @Override
    public void setUnit(Unit unit) {
        if (unit != null && !(unit instanceof Rule)) {
            throw new IllegalArgumentException("Unit must be a rule");
        }
        if (this.unit != unit) {
            this.unit = unit;
            this.partialMatch = null;
            this.completeMatch = null;
            this.resultMatch = null;
            this.change = null;
            this.isExecuted = false;
            this.isUndone = false;
            this.isCompleteMatchDerived = false;
        }
    }

    @Override
    public Assignment getAssignment() {
        return this.partialMatch;
    }

    @Override
    public void setAssignment(Assignment assignment) {
        this.partialMatch = assignment == null ? null : (assignment instanceof Match ? (Match)assignment : new MatchImpl(assignment, false));
        if (this.partialMatch != null) {
            EList unitParameters = this.unit.getParameters();
            for (Parameter param : unitParameters) {
                ParameterKind kind = param.getKind();
                if (kind != ParameterKind.INOUT && kind != ParameterKind.IN || this.partialMatch.getParameterValue(param) != null) continue;
                throw new IllegalStateException(String.valueOf(this.unit.getName()) + ": " + kind + " Parameter " + param.getName() + " not set");
            }
        }
        this.completeMatch = null;
        this.resultMatch = null;
        this.change = null;
        this.isExecuted = false;
        this.isUndone = false;
        this.isCompleteMatchDerived = false;
    }

    @Override
    public Object getResultParameterValue(String paramName) {
        if (this.unit == null) {
            throw new RuntimeException("Rule not set");
        }
        Parameter param = this.unit.getParameter(paramName);
        if (param == null) {
            throw new RuntimeException("No parameter \"" + paramName + "\" in rule \"" + this.unit.getName() + "\" found");
        }
        ParameterKind paramKind = param.getKind();
        if (paramKind == ParameterKind.VAR || paramKind == ParameterKind.IN) {
            throw new RuntimeException(String.valueOf(paramKind.getAlias()) + " parameter \"" + paramName + "\" may not be read manually in rule \"" + this.unit.getName() + "\"");
        }
        if (this.resultMatch != null) {
            return this.resultMatch.getParameterValue(param);
        }
        return null;
    }

    @Override
    public void setParameterValue(String paramName, Object value) {
        if (this.unit == null) {
            throw new RuntimeException("Rule not set");
        }
        Parameter param = this.unit.getParameter(paramName);
        if (param == null) {
            throw new RuntimeException("No parameter \"" + paramName + "\" in rule \"" + this.unit.getName() + "\" found");
        }
        ParameterKind paramKind = param.getKind();
        if (paramKind == ParameterKind.OUT || paramKind == ParameterKind.VAR) {
            throw new RuntimeException(String.valueOf(paramKind.getAlias()) + " parameter \"" + paramName + "\" may not be set before the application of rule \"" + this.unit.getName() + "\"");
        }
        if (this.partialMatch == null) {
            this.partialMatch = new MatchImpl((Rule)this.unit);
        }
        this.partialMatch.setParameterValue(param, value);
        this.completeMatch = null;
        this.isCompleteMatchDerived = false;
    }

    @Override
    public Match getPartialMatch() {
        return this.partialMatch;
    }

    @Override
    public void setPartialMatch(Match partialMatch) {
        this.partialMatch = partialMatch;
        this.completeMatch = null;
        this.resultMatch = null;
        this.change = null;
        this.isExecuted = false;
        this.isUndone = false;
        this.isCompleteMatchDerived = false;
    }

    @Override
    public Match getCompleteMatch() {
        return this.completeMatch;
    }

    @Override
    public void setCompleteMatch(Match completeMatch) {
        this.completeMatch = completeMatch;
        this.resultMatch = null;
        this.change = null;
        this.isExecuted = false;
        this.isUndone = false;
        this.isCompleteMatchDerived = false;
    }

    @Override
    public Match getResultMatch() {
        return this.resultMatch;
    }

    @Override
    public Assignment getResultAssignment() {
        return this.resultMatch;
    }
}

