/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.Transition;

public class MDPLabel {
    Transition transition;

    public MDPLabel(Transition transition) {
        this.transition = transition;
    }

    public int hashCode() {
        return this.transition.getRule().getName().hashCode() + this.transition.getMatch();
    }

    public boolean equals(Object o) {
        if (o instanceof MDPLabel) {
            MDPLabel l = (MDPLabel)o;
            return this.transition.getRule().getName().equals(l.transition.getRule().getName()) && this.transition.getMatch() == l.transition.getMatch();
        }
        return false;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public static Map<MDPLabel, List<Transition>> getTransitionsByLabel(State state) {
        LinkedHashMap<MDPLabel, List<Transition>> transitions = new LinkedHashMap<MDPLabel, List<Transition>>();
        for (Transition transition : state.getOutgoing()) {
            MDPLabel label = new MDPLabel(transition);
            ArrayList<Transition> trs = (ArrayList<Transition>)transitions.get(label);
            if (trs == null) {
                trs = new ArrayList<Transition>();
                transitions.put(label, trs);
            }
            trs.add(transition);
        }
        return transitions;
    }
}

