/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.EEFReferenceDescription;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFReferenceController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.ActionButton;
import org.eclipse.eef.ide.ui.internal.widgets.EEFMultipleReferencesSelectionListener;
import org.eclipse.eef.ide.ui.internal.widgets.EEFMultipleReferencesTableLabelProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class EEFMultipleReferencesLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int DEFAULT_HEIGHT = 34;
    private static final int TABLE_MINIMAL_HEIGHT = 100;
    private EEFReferenceDescription description;
    private EEFWidgetFactory widgetFactory;
    private List<ActionButton> actionButtons = new ArrayList<ActionButton>();
    private Color defaultBackgroundColor;
    private IEEFReferenceController controller;
    private TableViewer tableViewer;
    private SelectionListener tableSelectionListener;

    public EEFMultipleReferencesLifecycleManager(EEFReferenceDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        this.defaultBackgroundColor = parent.getBackground();
        Composite reference = this.widgetFactory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        reference.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        reference.setLayoutData((Object)gridData);
        this.createMultipleValuedReferenceWidget(reference);
        this.createWidgetActionButtons(reference);
        this.widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createReferenceController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
    }

    private void createMultipleValuedReferenceWidget(Composite parent) {
        ScrolledComposite scrolledComposite = this.widgetFactory.createScrolledComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        scrolledComposite.setLayoutData((Object)gridData);
        Table table = this.widgetFactory.createTable((Composite)scrolledComposite, 68106);
        this.tableViewer = new TableViewer(table);
        GridData tableGridData = new GridData(4, 128, true, false, 1, 1);
        tableGridData.horizontalIndent = 5;
        this.tableViewer.getTable().setLayoutData((Object)tableGridData);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EEFMultipleReferencesTableLabelProvider(this.description, this.interpreter, this.variableManager));
        scrolledComposite.setContent((Control)table);
        int widgetHeight = 34;
        EList actions = this.description.getActions();
        if (actions != null && actions.size() > 0) {
            widgetHeight *= actions.size() + 1;
        }
        int clientWidth = scrolledComposite.getClientArea().width;
        this.tableViewer.getTable().setSize(clientWidth, Math.max(100, widgetHeight));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setAlwaysShowScrollBars(true);
    }

    private void createWidgetActionButtons(Composite parent) {
        Composite buttons = this.widgetFactory.createFlatFormComposite(parent);
        GridData gridData = new GridData();
        buttons.setLayoutData((Object)gridData);
        buttons.setLayout((Layout)new GridLayout(1, false));
        for (EEFWidgetAction action : this.description.getActions()) {
            ActionButton actionButton = new ActionButton(action, buttons, this.widgetFactory, this.interpreter, this.variableManager);
            this.actionButtons.add(actionButton);
        }
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.tableSelectionListener = new EEFMultipleReferencesSelectionListener(this.controller);
        this.tableViewer.getTable().addSelectionListener(this.tableSelectionListener);
        this.controller.onNewValue((IConsumer)new IConsumer<Object>(){

            public void apply(Object value) {
                if (value == null) {
                    return;
                }
                EEFMultipleReferencesLifecycleManager.this.setMultipleValuedReference(value);
            }
        });
        for (final ActionButton actionButton : this.actionButtons) {
            SelectionAdapter selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList selections = new ArrayList();
                    IStructuredSelection structuredSelection = (IStructuredSelection)EEFMultipleReferencesLifecycleManager.this.tableViewer.getSelection();
                    for (Object selection : structuredSelection.toList()) {
                        selections.add(selection);
                    }
                    EEFMultipleReferencesLifecycleManager.this.controller.action(actionButton.getAction(), selections);
                }
            };
            actionButton.addSelectionListener(selectionListener);
        }
    }

    private void setMultipleValuedReference(Object value) {
        if (!this.tableViewer.getTable().isDisposed()) {
            StructuredSelection selection = new StructuredSelection(value);
            this.tableViewer.setSelection((ISelection)selection);
            ArrayList<Object> values = new ArrayList<Object>();
            if (value instanceof Iterable) {
                for (Object val : (Iterable)value) {
                    values.add(val);
                }
            } else {
                values.add(value);
            }
            this.tableViewer.setInput((Object)values.toArray());
            if (!this.tableViewer.getTable().isEnabled() && this.isEnabled()) {
                this.tableViewer.getTable().setEnabled(true);
            }
        }
    }

    private Color getBackgroundColor() {
        Color color = this.defaultBackgroundColor;
        if (!this.isEnabled()) {
            color = this.widgetFactory.getColors().getInactiveBackground();
        }
        return color;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.tableViewer != null && this.tableViewer.getTable() != null) {
            this.tableViewer.getTable().setEnabled(this.isEnabled());
            this.tableViewer.getTable().setBackground(this.getBackgroundColor());
        }
        for (ActionButton actionButton : this.actionButtons) {
            actionButton.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        for (ActionButton actionButton : this.actionButtons) {
            actionButton.removeSelectionListener();
        }
        if (this.tableViewer != null && this.tableViewer.getTable() != null && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().removeSelectionListener(this.tableSelectionListener);
        }
        this.controller.removeNewValueConsumer();
        this.actionButtons.clear();
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    protected Control getValidationControl() {
        return this.tableViewer.getTable().getParent();
    }
}

