/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import com.google.common.base.Objects;
import org.eclipse.eef.EEFHyperlinkDescription;
import org.eclipse.eef.EEFHyperlinkStyle;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFHyperlinkController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFHyperlinkListener;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EEFHyperlinkLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private EEFHyperlinkDescription description;
    private StyledText hyperlink;
    private IEEFHyperlinkController controller;
    private MouseListener hyperlinkListener;

    public EEFHyperlinkLifecycleManager(EEFHyperlinkDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        this.hyperlink = widgetFactory.createStyledText(parent, 8);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = 5;
        this.hyperlink.setLayoutData((Object)gridData);
        this.hyperlink.setEditable(false);
        this.hyperlink.setEnabled(true);
        widgetFactory.paintBordersFor(parent);
        this.controller = new EEFControllersFactory().createHyperlinkController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
    }

    @Override
    protected int getLabelVerticalAlignment() {
        return 4;
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.hyperlinkListener = new EEFHyperlinkListener(this.hyperlink, this.container, this.controller);
        this.hyperlink.addMouseListener(this.hyperlinkListener);
        this.controller.onNewValue((IConsumer)new IConsumer<String>(){

            public void apply(String value) {
                if (!EEFHyperlinkLifecycleManager.this.hyperlink.isDisposed()) {
                    if (EEFHyperlinkLifecycleManager.this.hyperlink.getText() == null || !EEFHyperlinkLifecycleManager.this.hyperlink.getText().equals(value)) {
                        String text = (String)Objects.firstNonNull((Object)value, (Object)"");
                        EEFHyperlinkLifecycleManager.this.hyperlink.setText(text);
                        EEFHyperlinkLifecycleManager.this.hyperlink.setData(EEFHyperlinkLifecycleManager.this.variableManager.getVariables().get("self"));
                    }
                    EEFHyperlinkLifecycleManager.this.setStyle();
                    if (!EEFHyperlinkLifecycleManager.this.hyperlink.isEnabled()) {
                        EEFHyperlinkLifecycleManager.this.hyperlink.setEnabled(true);
                    }
                }
            }
        });
    }

    private void setStyle() {
        StyleRange[] styleRanges;
        StyleRange styleRange;
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle widgetStyle = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (widgetStyle instanceof EEFHyperlinkStyle) {
            EEFHyperlinkStyle style = (EEFHyperlinkStyle)widgetStyle;
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.hyperlink);
            styleHelper.applyTextStyle(style.getFontNameExpression(), style.getFontSizeExpression(), style.getFontStyleExpression(), this.hyperlink.getFont(), style.getBackgroundColorExpression(), null, callback);
        }
        if ((styleRange = (styleRanges = this.hyperlink.getStyleRanges()).length > 0 ? styleRanges[0] : new StyleRange()) != null) {
            styleRange.start = 0;
            styleRange.length = this.hyperlink.getText().length();
            styleRange.underline = true;
            styleRange.underlineStyle = 4;
        }
        this.hyperlink.setStyleRange(styleRange);
    }

    @Override
    protected Control getValidationControl() {
        return this.hyperlink;
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.hyperlink.isDisposed()) {
            this.hyperlink.removeMouseListener(this.hyperlinkListener);
        }
        this.controller.removeNewValueConsumer();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.hyperlink.setEnabled(this.isEnabled());
    }
}

