/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.api.widgets;

import java.util.List;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFController;
import org.eclipse.eef.core.api.controllers.IInvalidValidationRuleResult;
import org.eclipse.eef.core.api.controllers.IValidationRuleResult;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

public abstract class AbstractEEFLifecycleManager
implements IEEFLifecycleManager {
    protected IEEFFormContainer container;

    @Override
    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        this.container = formContainer;
    }

    @Override
    public void aboutToBeShown() {
        this.getController().onValidation((IConsumer)new IConsumer<List<IValidationRuleResult>>(){

            public void apply(List<IValidationRuleResult> validationRuleResults) {
                IMessageManager messageManager = AbstractEEFLifecycleManager.this.container.getForm().getMessageManager();
                for (IValidationRuleResult validationRuleResult : validationRuleResults) {
                    if (validationRuleResult instanceof IInvalidValidationRuleResult) {
                        IInvalidValidationRuleResult result = (IInvalidValidationRuleResult)validationRuleResult;
                        if (AbstractEEFLifecycleManager.this.getValidationControl() != null) {
                            messageManager.addMessage((Object)result.getValidationRule(), result.getMessage(), result.getData(), result.getSeverity(), AbstractEEFLifecycleManager.this.getValidationControl());
                            continue;
                        }
                        messageManager.addMessage((Object)result.getValidationRule(), result.getMessage(), result.getData(), result.getSeverity());
                        continue;
                    }
                    if (AbstractEEFLifecycleManager.this.getValidationControl() != null) {
                        messageManager.removeMessage((Object)validationRuleResult.getValidationRule(), AbstractEEFLifecycleManager.this.getValidationControl());
                        continue;
                    }
                    messageManager.removeMessage((Object)validationRuleResult.getValidationRule());
                }
            }
        });
    }

    protected abstract IEEFController getController();

    protected abstract Control getValidationControl();

    @Override
    public void refresh() {
        this.getController().refresh();
    }

    @Override
    public void aboutToBeHidden() {
        this.getController().removeValidationConsumer();
    }
}

