/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.mapping.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.eef.mapping.AbstractPropertyBinding;
import org.eclipse.emf.eef.mapping.ElementBindingReference;
import org.eclipse.emf.eef.mapping.MappingPackage;
import org.eclipse.emf.eef.mapping.filters.FiltersFactory;
import org.eclipse.emf.eef.mapping.provider.DocumentedElementItemProvider;
import org.eclipse.emf.eef.views.View;
import org.eclipse.emf.eef.views.ViewElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPropertyBindingItemProvider
extends DocumentedElementItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public AbstractPropertyBindingItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addViewsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AbstractPropertyBinding_name_feature"), this.getString("_UI_AbstractPropertyBinding_name_description"), (EStructuralFeature)MappingPackage.Literals.ABSTRACT_PROPERTY_BINDING__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addViewsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.initViewsPropertyDescriptors());
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(MappingPackage.Literals.ABSTRACT_PROPERTY_BINDING__BINDING_FILTERS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    private ItemPropertyDescriptor initViewsPropertyDescriptors() {
        return new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AbstractPropertyBinding_views_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AbstractPropertyBinding_views_feature", "_UI_AbstractPropertyBinding_type"), (EStructuralFeature)MappingPackage.Literals.ABSTRACT_PROPERTY_BINDING__VIEWS, true, false, true, null, null, null){

            protected Collection<?> getComboBoxObjects(Object object) {
                if (object instanceof AbstractPropertyBinding) {
                    AbstractPropertyBinding propertyBinding = (AbstractPropertyBinding)object;
                    ArrayList views = new ArrayList(propertyBinding.getElement().getViews());
                    for (ElementBindingReference reference : propertyBinding.getElement().getReferencedBinding()) {
                        views.addAll(reference.getBinding().getViews());
                    }
                    Collection comboBoxObjects = super.getComboBoxObjects(object);
                    ArrayList<ViewElement> result = new ArrayList<ViewElement>();
                    for (Object viewElement : comboBoxObjects) {
                        if (!AbstractPropertyBindingItemProvider.this.ownedBy((ViewElement)viewElement, views)) continue;
                        result.add((ViewElement)viewElement);
                    }
                    return result;
                }
                return super.getComboBoxObjects(object);
            }
        };
    }

    private boolean ownedBy(ViewElement element, List<View> views) {
        for (View view : views) {
            if (!this.ownedBy(element, view)) continue;
            return true;
        }
        return false;
    }

    private boolean ownedBy(ViewElement element, View view) {
        EObject container = element.eContainer();
        while (container != null) {
            if (EcoreUtil.equals((EObject)view, (EObject)container)) {
                return true;
            }
            container = container.eContainer();
        }
        return false;
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/AbstractPropertyBinding"));
    }

    @Override
    public String getText(Object object) {
        String label = ((AbstractPropertyBinding)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_AbstractPropertyBinding_type") : String.valueOf(this.getString("_UI_AbstractPropertyBinding_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(AbstractPropertyBinding.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(MappingPackage.Literals.ABSTRACT_PROPERTY_BINDING__BINDING_FILTERS, FiltersFactory.eINSTANCE.createJavaDeclarationFilter()));
        newChildDescriptors.add(this.createChildParameter(MappingPackage.Literals.ABSTRACT_PROPERTY_BINDING__BINDING_FILTERS, FiltersFactory.eINSTANCE.createJavaExpressionFilter()));
        newChildDescriptors.add(this.createChildParameter(MappingPackage.Literals.ABSTRACT_PROPERTY_BINDING__BINDING_FILTERS, FiltersFactory.eINSTANCE.createOnlyReferenceTypeFilter()));
    }
}

