/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.match.EMFCompareMatchMessages;
import org.eclipse.emf.compare.match.engine.GenericMatchEngine;
import org.eclipse.emf.compare.match.engine.IMatchEngine;
import org.eclipse.emf.compare.match.service.MatchEngineDescriptor;
import org.eclipse.emf.compare.util.ModelIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchEngineRegistry
extends HashMap<String, List<Object>> {
    public static final MatchEngineRegistry INSTANCE = new MatchEngineRegistry();
    private static final String MATCH_ENGINES_EXTENSION_POINT = "org.eclipse.emf.compare.match.engine";
    private static final String SEPARATOR = ",";
    private static final long serialVersionUID = 2237008034183610765L;
    private static final String TAG_ENGINE = "matchengine";
    private static final String WILDCARD = "*";
    private final List<MatchEngineDescriptor> nsPatternDescriptors = new ArrayList<MatchEngineDescriptor>();

    private MatchEngineRegistry() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.parseExtensionMetadata();
        } else {
            this.putValue(WILDCARD, new GenericMatchEngine());
        }
    }

    public List<MatchEngineDescriptor> getDescriptors(ModelIdentifier identifier) {
        List<Object> candidates = this.getEnginesForIdentifier(identifier);
        candidates.addAll((Collection)this.get(WILDCARD));
        ArrayList<MatchEngineDescriptor> engines = new ArrayList<MatchEngineDescriptor>(candidates.size());
        for (Object value : candidates) {
            if (!(value instanceof MatchEngineDescriptor)) continue;
            engines.add((MatchEngineDescriptor)value);
        }
        return engines;
    }

    @Deprecated
    public List<MatchEngineDescriptor> getDescriptors(String engineIdentifier) {
        List specific = (List)this.get(engineIdentifier);
        ArrayList candidates = new ArrayList((Collection)this.get(WILDCARD));
        if (specific != null) {
            candidates.addAll(0, specific);
        }
        ArrayList<MatchEngineDescriptor> engines = new ArrayList<MatchEngineDescriptor>(candidates.size());
        for (Object value : candidates) {
            if (!(value instanceof MatchEngineDescriptor)) continue;
            engines.add((MatchEngineDescriptor)value);
        }
        return engines;
    }

    public IMatchEngine getHighestEngine(ModelIdentifier identifier) {
        IMatchEngine highest = null;
        List<Object> engines = this.getEnginesForIdentifier(identifier);
        if (engines.size() != 0) {
            highest = this.getSpecificHighestEngine(engines);
        }
        if (highest == null) {
            highest = this.getSpecificHighestEngine((List)this.get(WILDCARD));
        }
        return highest;
    }

    @Deprecated
    public IMatchEngine getHighestEngine(String engineIdentifier) {
        List engines = (List)this.get(engineIdentifier);
        IMatchEngine highest = null;
        if (engines != null) {
            highest = this.getSpecificHighestEngine(engines);
        }
        if (highest == null) {
            highest = this.getSpecificHighestEngine((List)this.get(WILDCARD));
        }
        return highest;
    }

    public void putValue(String key, Object value) {
        if (value instanceof IMatchEngine || value instanceof MatchEngineDescriptor) {
            ArrayList<Object> values = (ArrayList<Object>)this.get(key);
            if (values != null) {
                values.add(value);
            } else {
                values = new ArrayList<Object>();
                values.add(value);
                super.put(key, values);
            }
        } else {
            throw new IllegalArgumentException(EMFCompareMatchMessages.getString("MatchEngineRegistry.IllegalEngine", value.getClass().getName()));
        }
    }

    private List<Object> getEnginesForIdentifier(ModelIdentifier identifier) {
        List newCandidates;
        ArrayList<Object> candidates = new ArrayList<Object>();
        if (identifier.getNamespace() != null) {
            newCandidates = (List)this.get(identifier.getNamespace());
            if (newCandidates != null) {
                candidates.addAll(newCandidates);
            }
            for (MatchEngineDescriptor desc : this.nsPatternDescriptors) {
                if (!identifier.getNamespace().matches(desc.getNamespacePattern())) continue;
                candidates.add(desc);
            }
        }
        if (identifier.getContentType() != null && (newCandidates = (List)this.get(identifier.getContentType())) != null) {
            candidates.addAll(newCandidates);
        }
        if (identifier.getExtension() != null && (newCandidates = (List)this.get(identifier.getExtension())) != null) {
            candidates.addAll(newCandidates);
        }
        return candidates;
    }

    private IMatchEngine getSpecificHighestEngine(List<Object> engines) {
        int highestPriority = -1;
        IMatchEngine highest = null;
        for (Object engine : engines) {
            if (engine instanceof MatchEngineDescriptor) {
                MatchEngineDescriptor desc = (MatchEngineDescriptor)engine;
                if (desc.getPriorityValue() <= highestPriority) continue;
                highest = desc.getEngineInstance();
                highestPriority = desc.getPriorityValue();
                continue;
            }
            if (!(engine instanceof IMatchEngine)) continue;
            highest = (IMatchEngine)engine;
        }
        return highest;
    }

    private MatchEngineDescriptor parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        MatchEngineDescriptor desc = new MatchEngineDescriptor(configElement);
        return desc;
    }

    private void parseExtensionMetadata() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(MATCH_ENGINES_EXTENSION_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String[] fileExtensions;
                String[] contentTypes;
                String[] namespaces;
                MatchEngineDescriptor desc = this.parseEngine(configElements[j]);
                String namespacePattern = desc.getNamespacePattern();
                if (!"".equals(namespacePattern)) {
                    this.nsPatternDescriptors.add(desc);
                }
                String[] stringArray = namespaces = desc.getNamespace().split(SEPARATOR);
                int n = namespaces.length;
                int n2 = 0;
                while (n2 < n) {
                    String ns = stringArray[n2];
                    if (!"".equals(ns)) {
                        this.putValue(ns, desc);
                    }
                    ++n2;
                }
                String[] stringArray2 = contentTypes = desc.getContentType().split(SEPARATOR);
                int n3 = contentTypes.length;
                n = 0;
                while (n < n3) {
                    String ct = stringArray2[n];
                    if (!"".equals(ct)) {
                        this.putValue(ct, desc);
                    }
                    ++n;
                }
                String[] stringArray3 = fileExtensions = desc.getFileExtension().split(SEPARATOR);
                int n4 = fileExtensions.length;
                n3 = 0;
                while (n3 < n4) {
                    String ext = stringArray3[n3];
                    if (!"".equals(ext)) {
                        this.putValue(ext, desc);
                    }
                    ++n3;
                }
                ++j;
            }
            ++i;
        }
    }
}

