/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.internal.ui.SharedIcons;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterFilesystemPackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterGeneratedPackagesAction;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterWorkspacePackagesAction;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.util.CDOPackageRegistry;
import org.eclipse.emf.cdo.util.CDOPackageType;
import org.eclipse.emf.cdo.util.CDOPackageTypeRegistry;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPage;

public class PackageManagerDialog
extends TitleAreaDialog {
    private static final int REGISTER_GENERATED_PACKAGES_ID = 1025;
    private static final int REGISTER_WORKSPACE_PACKAGES_ID = 1026;
    private static final int REGISTER_FILESYSTEM_PACKAGES_ID = 1027;
    private static final String TITLE = "CDO Package Manager";
    private static final String EMPTY = "";
    private IWorkbenchPage page;
    private CDOSession session;
    private TableViewer viewer;

    public PackageManagerDialog(IWorkbenchPage page, CDOSession session) {
        super(new Shell(page.getWorkbenchWindow().getShell()));
        this.page = page;
        this.session = session;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(CDOItemProvider.getSessionLabel(this.session));
        this.setTitleImage(SharedIcons.getImage("wizban/PackageManager"));
        this.viewer = new TableViewer(composite, 0);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLayoutData((Object)UIUtil.createGridData());
        this.addColumn(table, "Package", 400, 16384);
        this.addColumn(table, "Registry", 80, 0x1000000);
        this.addColumn(table, "Repository", 80, 0x1000000);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.setInput((Object)this.session);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "Generated...", false);
        this.createButton(parent, 1026, "Workspace...", false);
        this.createButton(parent, 1027, "Filesystem...", false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                new RegisterGeneratedPackagesAction(this.page, this.session){

                    @Override
                    protected void postRegistration(List<EPackage> ePackages) {
                        PackageManagerDialog.this.refreshViewer();
                    }
                }.run();
                break;
            }
            case 1026: {
                new RegisterWorkspacePackagesAction(this.page, this.session){

                    @Override
                    protected void postRegistration(List<EPackage> ePackages) {
                        PackageManagerDialog.this.refreshViewer();
                    }
                }.run();
                break;
            }
            case 1027: {
                new RegisterFilesystemPackagesAction(this.page, this.session){

                    @Override
                    protected void postRegistration(List<EPackage> ePackages) {
                        PackageManagerDialog.this.refreshViewer();
                    }
                }.run();
                break;
            }
            case 12: {
                this.close();
            }
        }
    }

    protected Image getContentIcon(Content content) {
        return null;
    }

    protected String getEPackageText(Object ePackage) {
        if (ePackage == EcorePackage.eINSTANCE) {
            return "ECORE";
        }
        if (ePackage.getClass() == EPackageImpl.class) {
            return "DYNAMIC";
        }
        String uri = EMPTY;
        if (ePackage instanceof EPackage.Descriptor) {
            CDOPackageRegistry registry = this.session.getPackageRegistry();
            for (Map.Entry entry : registry.entrySet()) {
                if (entry.getValue() != ePackage) continue;
                uri = (String)entry.getKey();
                break;
            }
        } else {
            uri = ((EPackage)ePackage).getNsURI();
        }
        CDOPackageType packageType = (CDOPackageType)CDOPackageTypeRegistry.INSTANCE.get((Object)uri);
        if (packageType == null) {
            return "?";
        }
        return packageType.toString();
    }

    protected String getCDOPackageText(CDOPackage cdoPackage) {
        if (cdoPackage.isSystem()) {
            return "SYSTEM";
        }
        if (!cdoPackage.isPersistent()) {
            return EMPTY;
        }
        return cdoPackage.isDynamic() ? "DYNAMIC" : "STATIC";
    }

    private void addColumn(Table table, String title, int width, int alignment) {
        TableColumn column = new TableColumn(table, alignment);
        column.setText(title);
        column.setWidth(width);
    }

    protected void refreshViewer() {
        this.page.getWorkbenchWindow().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    PackageManagerDialog.this.viewer.refresh();
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Content
    implements Comparable<Content> {
        private String packageURI;
        private Object ePackage;
        private CDOPackage cdoPackage;

        public Content(String packageURI) {
            this.packageURI = packageURI;
        }

        public String getPackageURI() {
            return this.packageURI;
        }

        public Object getEPackage() {
            return this.ePackage;
        }

        public void setEPackage(Object ePackage) {
            this.ePackage = ePackage;
        }

        public CDOPackage getCDOPackage() {
            return this.cdoPackage;
        }

        public void setCDOPackage(CDOPackage cdoPackage) {
            this.cdoPackage = cdoPackage;
        }

        @Override
        public int compareTo(Content content) {
            return this.packageURI.compareTo(content.packageURI);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Content) {
                Content that = (Content)obj;
                return ObjectUtil.equals((Object)this.packageURI, (Object)that.packageURI);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtil.hashCode((Object)this.packageURI);
        }

        public String toString() {
            return this.packageURI;
        }
    }

    public static class ContentProvider
    implements IStructuredContentProvider {
        private static final Object[] NO_ELEMENTS = new Object[0];
        private CDOSession session;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof CDOSession && !ObjectUtil.equals((Object)this.session, (Object)newInput)) {
                this.session = (CDOSession)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != this.session) {
                return NO_ELEMENTS;
            }
            HashMap<String, Content> map = new HashMap<String, Content>();
            for (Map.Entry entry : this.session.getPackageRegistry().entrySet()) {
                String packageURI = (String)entry.getKey();
                Content content = new Content(packageURI);
                map.put(packageURI, content);
                content.setEPackage(entry.getValue());
            }
            CDOPackage[] cDOPackageArray = this.session.getPackageManager().getPackages();
            int n = cDOPackageArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOPackage cdoPackage = cDOPackageArray[n2];
                String packageURI = cdoPackage.getPackageURI();
                Content content = (Content)map.get(packageURI);
                if (content == null) {
                    content = new Content(packageURI);
                    map.put(packageURI, content);
                }
                content.setCDOPackage(cdoPackage);
                ++n2;
            }
            ArrayList list = new ArrayList(map.values());
            Collections.sort(list);
            return list.toArray(new Content[list.size()]);
        }
    }

    public class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Content) {
                Content content = (Content)element;
                switch (columnIndex) {
                    case 0: {
                        return content.getPackageURI();
                    }
                    case 1: {
                        return content.getEPackage() == null ? PackageManagerDialog.EMPTY : PackageManagerDialog.this.getEPackageText(content.getEPackage());
                    }
                    case 2: {
                        return content.getCDOPackage() == null ? PackageManagerDialog.EMPTY : PackageManagerDialog.this.getCDOPackageText(content.getCDOPackage());
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof Content) {
                Content content = (Content)element;
                if (columnIndex == 0) {
                    return PackageManagerDialog.this.getContentIcon(content);
                }
            }
            return null;
        }
    }
}

