/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.xml.ParseXMLAnnotationsException;
import org.eclipse.emf.teneo.annotations.xml.XmlPersistenceContentHandler;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlPersistenceMapper
implements ExtensionPoint,
ExtensionManagerAware {
    private InputStream xmlMapping;
    protected static final Log log = LogFactory.getLog(XmlPersistenceMapper.class);
    private ExtensionManager extensionManager;
    private PersistenceOptions persistenceOptions;

    public void setXmlMapping(InputStream xmlMapping) {
        if (xmlMapping == null) {
            throw new IllegalArgumentException("XML mapping cannot be null.");
        }
        this.xmlMapping = xmlMapping;
    }

    public void applyPersistenceMapping(PAnnotatedModel pAnnotatedModel, EPackage.Registry ePackageRegistry) {
        SAXParser saxParser;
        if (this.xmlMapping == null) {
            throw new IllegalStateException("XML mapping not configured.");
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(true);
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new ParseXMLAnnotationsException(e);
        }
        catch (SAXException e) {
            throw new ParseXMLAnnotationsException(e);
        }
        try {
            try {
                try {
                    saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getClass().getResourceAsStream("persistence-mapping.xsd"));
                }
                catch (SAXNotRecognizedException s) {
                    log.warn((Object)"Properties schemaSource and/or schemaLanguage are not supported, setvalidating=false. Probably running 1.4 with an old crimson sax parser. Ignoring this and continuing with a non-validating and name-space-aware sax parser");
                    SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                    saxParserFactory.setNamespaceAware(true);
                    saxParserFactory.setValidating(false);
                    saxParser = saxParserFactory.newSAXParser();
                }
                XmlPersistenceContentHandler xmlContentHandler = this.extensionManager.getExtension(XmlPersistenceContentHandler.class);
                xmlContentHandler.setEPackageRegistry(ePackageRegistry);
                xmlContentHandler.setPAnnotatedModel(pAnnotatedModel);
                xmlContentHandler.setPrefix(this.getPrefix());
                xmlContentHandler.setLenient(this.persistenceOptions.getPersistenceXmlParseLenient());
                xmlContentHandler.setSchema(this.getClass().getResourceAsStream("persistence-mapping.xsd"));
                saxParser.parse(this.xmlMapping, (DefaultHandler)xmlContentHandler);
            }
            catch (SAXException e) {
                throw new ParseXMLAnnotationsException(e);
            }
            catch (IOException e) {
                throw new ParseXMLAnnotationsException(e);
            }
            catch (ParserConfigurationException e) {
                throw new ParseXMLAnnotationsException(e);
            }
        }
        finally {
            try {
                this.xmlMapping.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected String getPrefix() {
        return "";
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public PersistenceOptions getPersistenceOptions() {
        return this.persistenceOptions;
    }

    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        this.persistenceOptions = persistenceOptions;
    }
}

