/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.view;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMapping;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;

public final class LogicalModelViewHandlerUtil {
    private static final int GET_TRAVERSALS_TICKS = 15;
    private static final int GET_RESOURCES_MAPPING_TICKS = 85;
    private static IModelProviderDescriptor modelDescriptor = ModelProvider.getModelProviderDescriptor((String)"org.eclipse.emf.compare.model.provider");

    private LogicalModelViewHandlerUtil() {
    }

    public static Collection<SynchronizationModel> getSynchronizationModels(IFile file, IProgressMonitor monitor) {
        HashSet logicalModels = Sets.newHashSet();
        if (file == null) {
            return null;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<EMFResourceMapping> resourceMappings = LogicalModelViewHandlerUtil.getResourceMappings(file, (IProgressMonitor)subMonitor.newChild(85));
        subMonitor.worked(85);
        SubMonitor subMonitorLoop = subMonitor.newChild(15).setWorkRemaining(resourceMappings.size());
        for (ResourceMapping resourceMapping : resourceMappings) {
            if (!(resourceMapping instanceof EMFResourceMapping)) continue;
            try {
                ((EMFResourceMapping)resourceMapping).getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)subMonitorLoop.newChild(1));
                logicalModels.add(((EMFResourceMapping)resourceMapping).getLatestModel());
            }
            catch (CoreException e) {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
        }
        return logicalModels;
    }

    public static Collection<IResource> getLogicalModelResources(Collection<SynchronizationModel> logicalModels, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor subMonitorLoop = subMonitor.newChild(100).setWorkRemaining(logicalModels.size());
        HashSet resources = Sets.newHashSet();
        for (SynchronizationModel logicalModel : logicalModels) {
            resources.addAll(logicalModel.getResources());
            subMonitorLoop.newChild(1);
        }
        return resources;
    }

    public static boolean isEMFCompareCompliantFile(IFile file) {
        try {
            IResource[] resources = modelDescriptor.getMatchingResources(new IResource[]{file});
            if (resources.length > 0) {
                return true;
            }
        }
        catch (CoreException e) {
            EMFCompareIDEUIPlugin.getDefault().log(e);
        }
        return false;
    }

    private static Collection<EMFResourceMapping> getResourceMappings(IFile file, IProgressMonitor monitor) {
        LinkedHashSet mappings = Sets.newLinkedHashSet();
        if (LogicalModelViewHandlerUtil.isEMFCompareCompliantFile(file)) {
            try {
                ResourceMapping[] modelMappings;
                ModelProvider model = modelDescriptor.getModelProvider();
                ResourceMapping[] resourceMappingArray = modelMappings = model.getMappings((IResource)file, ResourceMappingContext.LOCAL_CONTEXT, monitor);
                int n = modelMappings.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceMapping mapping = resourceMappingArray[n2];
                    if (mapping instanceof EMFResourceMapping) {
                        mappings.add((EMFResourceMapping)mapping);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
        }
        return mappings;
    }
}

