/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.tests.nodes.Node;
import org.eclipse.emf.compare.tests.nodes.NodeEnum;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ConflictMergeTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final BatchMerger batchMerger = new BatchMerger(IMerger.RegistryImpl.createStandaloneInstance());

    @Test
    public void testLeftAddRightAdd_LtR_1() throws IOException {
        Resource left = this.input.getLeftAddRightAddLeftConflictScope();
        Resource right = this.input.getLeftAddRightAddRightConflictScope();
        Resource origin = this.input.getLeftAddRightAddOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        String featureName = "containmentRef1";
        Diff diffNodeCLeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C", (boolean)true)}));
        Diff diffNodeCRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C", (boolean)true)}));
        Diff diffNodeDLeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C.D", (boolean)true)}));
        Diff diffNodeDRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C.D", (boolean)true)}));
        Diff diffNodeELeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C.E", (boolean)true)}));
        Diff diffNodeFRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C.F", (boolean)true)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diffNodeCLeft), (Monitor)new BasicMonitor());
        EObject rightNodeC = this.getNodeNamed(right, "C");
        Assert.assertNotNull((Object)rightNodeC);
        EObject rightNodeA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightNodeA);
        EObject rightNodeB = this.getNodeNamed(right, "B");
        Assert.assertNotNull((Object)rightNodeB);
        EObject rightNodeD = this.getNodeNamed(right, "D");
        Assert.assertNull((Object)rightNodeD);
        EObject rightNodeF = this.getNodeNamed(right, "F");
        Assert.assertNull((Object)rightNodeF);
        EStructuralFeature feature = rightNodeA.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1s = ((Node)rightNodeA).getContainmentRef1();
        Assert.assertTrue((boolean)containmentRef1s.contains((Object)rightNodeC));
        EList<Node> bContainmentRef1s = ((Node)rightNodeB).getContainmentRef1();
        Assert.assertFalse((boolean)bContainmentRef1s.contains((Object)rightNodeC));
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeCLeft.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)diffNodeCRight.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeDLeft.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeDRight.getState());
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)diffNodeELeft.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)diffNodeFRight.getState());
    }

    @Test
    @Ignore(value="Test was already broken although it didn't fail. Fix it and make sure the result of the merge is correct.")
    public void testLeftAddRightAdd_LtR_2() throws IOException {
        Resource left = this.input.getLeftAddRightAddLeftConflictScope();
        Resource right = this.input.getLeftAddRightAddRightConflictScope();
        Resource origin = this.input.getLeftAddRightAddOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        String featureName = "containmentRef1";
        Diff diffNodeCLeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C", (boolean)true)}));
        Diff diffNodeCRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C", (boolean)true)}));
        Diff diffNodeDLeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C.D", (boolean)true)}));
        Diff diffNodeDRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C.D", (boolean)true)}));
        Diff diffNodeELeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C.E", (boolean)true)}));
        Diff diffNodeFRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C.F", (boolean)true)}));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diffNodeCRight), (Monitor)new BasicMonitor());
        EObject rightNodeC = this.getNodeNamed(right, "C");
        Assert.assertNull((Object)rightNodeC);
        EObject rightNodeA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightNodeA);
        EObject rightNodeB = this.getNodeNamed(right, "B");
        Assert.assertNotNull((Object)rightNodeB);
        EObject rightNodeD = this.getNodeNamed(right, "D");
        Assert.assertNull((Object)rightNodeD);
        EObject rightNodeF = this.getNodeNamed(right, "F");
        Assert.assertNull((Object)rightNodeF);
        EStructuralFeature feature = rightNodeA.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> aContainmentRef1s = ((Node)rightNodeA).getContainmentRef1();
        Assert.assertFalse((boolean)aContainmentRef1s.contains((Object)rightNodeC));
        EList<Node> bContainmentRef1s = ((Node)rightNodeB).getContainmentRef1();
        Assert.assertFalse((boolean)bContainmentRef1s.contains((Object)rightNodeC));
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)diffNodeCLeft.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeCRight.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeDLeft.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeDRight.getState());
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)diffNodeELeft.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeFRight.getState());
    }

    @Test
    @Ignore(value="Test was already broken although it didn't fail. Fix it and make sure the result of the merge is correct.")
    public void testLeftAddRightAdd_RtL_1() throws IOException {
        Resource left = this.input.getLeftAddRightAddLeftConflictScope();
        Resource right = this.input.getLeftAddRightAddRightConflictScope();
        Resource origin = this.input.getLeftAddRightAddOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        String featureName = "containmentRef1";
        Diff diffNodeCLeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C", (boolean)true)}));
        Diff diffNodeCRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C", (boolean)true)}));
        Diff diffNodeDLeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C.D", (boolean)true)}));
        Diff diffNodeDRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C.D", (boolean)true)}));
        Diff diffNodeELeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C.E", (boolean)true)}));
        Diff diffNodeFRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C.F", (boolean)true)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diffNodeCLeft), (Monitor)new BasicMonitor());
        EObject leftNodeC = this.getNodeNamed(left, "C");
        Assert.assertNull((Object)leftNodeC);
        EObject leftNodeA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftNodeA);
        EObject leftNodeB = this.getNodeNamed(left, "B");
        Assert.assertNotNull((Object)leftNodeB);
        EObject leftNodeD = this.getNodeNamed(left, "D");
        Assert.assertNull((Object)leftNodeD);
        EObject leftNodeF = this.getNodeNamed(left, "F");
        Assert.assertNull((Object)leftNodeF);
        EStructuralFeature feature = leftNodeA.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1s = ((Node)leftNodeA).getContainmentRef1();
        Assert.assertFalse((boolean)containmentRef1s.contains((Object)leftNodeC));
        EList<Node> bContainmentRef1s = ((Node)leftNodeB).getContainmentRef1();
        Assert.assertFalse((boolean)bContainmentRef1s.contains((Object)leftNodeC));
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeCLeft.getState());
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)diffNodeCRight.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeDLeft.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeDRight.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeELeft.getState());
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)diffNodeFRight.getState());
    }

    @Test
    public void testLeftAddRightAdd_RtL_2() throws IOException {
        Resource left = this.input.getLeftAddRightAddLeftConflictScope();
        Resource right = this.input.getLeftAddRightAddRightConflictScope();
        Resource origin = this.input.getLeftAddRightAddOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        String featureName = "containmentRef1";
        Diff diffNodeCLeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C", (boolean)true)}));
        Diff diffNodeCRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C", (boolean)true)}));
        Diff diffNodeDLeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C.D", (boolean)true)}));
        Diff diffNodeDRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C.D", (boolean)true)}));
        Diff diffNodeELeft = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.A.C.E", (boolean)true)}));
        Diff diffNodeFRight = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.referenceValueMatch((String)"containmentRef1", (String)"root.B.C.F", (boolean)true)}));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diffNodeCRight), (Monitor)new BasicMonitor());
        EObject leftNodeC = this.getNodeNamed(left, "C");
        Assert.assertNotNull((Object)leftNodeC);
        EObject leftNodeA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftNodeA);
        EObject leftNodeB = this.getNodeNamed(left, "B");
        Assert.assertNotNull((Object)leftNodeB);
        EObject leftNodeD = this.getNodeNamed(left, "D");
        Assert.assertNull((Object)leftNodeD);
        EObject leftNodeF = this.getNodeNamed(left, "F");
        Assert.assertNull((Object)leftNodeF);
        EStructuralFeature feature = leftNodeA.eClass().getEStructuralFeature("containmentRef1");
        Assert.assertNotNull((Object)feature);
        EList<Node> containmentRef1s = ((Node)leftNodeA).getContainmentRef1();
        Assert.assertFalse((boolean)containmentRef1s.contains((Object)leftNodeC));
        EList<Node> bContainmentRef1s = ((Node)leftNodeB).getContainmentRef1();
        Assert.assertTrue((boolean)bContainmentRef1s.contains((Object)leftNodeC));
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)diffNodeCLeft.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeCRight.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeDLeft.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffNodeDRight.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)diffNodeELeft.getState());
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)diffNodeFRight.getState());
    }

    @Test
    public void testLeftAddRightDelete_LtR_1() throws IOException {
        Resource left = this.input.getLeftAddRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftAddRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftAddRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eSuperTypes";
        EObject rightEClassB = this.getNodeNamed(right, "B");
        Assert.assertNotNull((Object)rightEClassB);
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        EStructuralFeature feature = rightEClassA.eClass().getEStructuralFeature("eSuperTypes");
        Assert.assertNotNull((Object)feature);
        EList eSuperTypes = ((EClass)rightEClassA).getESuperTypes();
        Assert.assertTrue((boolean)eSuperTypes.contains((Object)rightEClassB));
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftAddRightDelete_LtR_2() throws IOException {
        Resource left = this.input.getLeftAddRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftAddRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftAddRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eSuperTypes";
        EObject rightEClassB = this.getNodeNamed(right, "B");
        Assert.assertNotNull((Object)rightEClassB);
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        EStructuralFeature feature = rightEClassA.eClass().getEStructuralFeature("eSuperTypes");
        Assert.assertNotNull((Object)feature);
        EList eSuperTypes = ((EClass)rightEClassA).getESuperTypes();
        Assert.assertTrue((boolean)eSuperTypes.isEmpty());
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.RIGHT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftAddRightDelete_LtR_EEnum() throws IOException {
        Resource left = this.input.getLeftAddRightDeleteLeftEEnumConflictScope();
        Resource right = this.input.getLeftAddRightDeleteRightEEnumConflictScope();
        Resource origin = this.input.getLeftAddRightDeleteOriginEEnumConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        String featureName = "multiValueEEnumAttribute";
        Diff diffA = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root.origin", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.A))));
        Diff diffB = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.addedToAttribute((String)"root.origin", (String)"multiValueEEnumAttribute", (Object)((Object)NodeEnum.B))));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diffA), (Monitor)new BasicMonitor());
        EObject rightElement = this.getNodeNamed(right, "origin");
        Assert.assertNotNull((Object)rightElement);
        EStructuralFeature feature = rightElement.eClass().getEStructuralFeature("multiValueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Object featureValue = rightElement.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).containsAll(Lists.newArrayList((Object[])new NodeEnum[]{NodeEnum.A})));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diffB), (Monitor)new BasicMonitor());
        featureValue = rightElement.eGet(feature);
        Assert.assertTrue((boolean)(featureValue instanceof Collection));
        Assert.assertTrue((boolean)((Collection)featureValue).containsAll(Lists.newArrayList((Object[])new NodeEnum[]{NodeEnum.A, NodeEnum.B})));
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftAddRightDelete_RtL_EEnum() throws IOException {
        Resource left = this.input.getLeftAddRightDeleteLeftEEnumConflictScope();
        Resource right = this.input.getLeftAddRightDeleteRightEEnumConflictScope();
        Resource origin = this.input.getLeftAddRightDeleteOriginEEnumConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff diffDelete = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diffDelete), (Monitor)new BasicMonitor());
        EObject rightElement = this.getNodeNamed(left, "origin");
        Assert.assertNull((Object)rightElement);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftAddRightDelete_RtL_1() throws IOException {
        Resource left = this.input.getLeftAddRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftAddRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftAddRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eSuperTypes";
        EObject leftEClassB = this.getNodeNamed(left, "B");
        Assert.assertNotNull((Object)leftEClassB);
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        EStructuralFeature feature = leftEClassA.eClass().getEStructuralFeature("eSuperTypes");
        Assert.assertNotNull((Object)feature);
        EList eSuperTypes = ((EClass)leftEClassA).getESuperTypes();
        Assert.assertTrue((boolean)eSuperTypes.isEmpty());
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.LEFT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftAddRightDelete_RtL_2() throws IOException {
        Resource left = this.input.getLeftAddRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftAddRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftAddRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eSuperTypes";
        EObject leftEClassB = this.getNodeNamed(left, "B");
        Assert.assertNull((Object)leftEClassB);
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        EStructuralFeature feature = leftEClassA.eClass().getEStructuralFeature("eSuperTypes");
        Assert.assertNotNull((Object)feature);
        EList eSuperTypes = ((EClass)leftEClassA).getESuperTypes();
        Assert.assertTrue((boolean)eSuperTypes.isEmpty());
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftDeleteRightAdd_LtR_1() throws IOException {
        Resource left = this.input.getLeftDeleteRightAddLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightAddRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightAddOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eSuperTypes";
        EObject rightEClassB = this.getNodeNamed(right, "B");
        Assert.assertNull((Object)rightEClassB);
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        EStructuralFeature feature = rightEClassA.eClass().getEStructuralFeature("eSuperTypes");
        Assert.assertNotNull((Object)feature);
        EList eSuperTypes = ((EClass)rightEClassA).getESuperTypes();
        Assert.assertTrue((boolean)eSuperTypes.isEmpty());
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftDeleteRightAdd_LtR_2() throws IOException {
        Resource left = this.input.getLeftDeleteRightAddLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightAddRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightAddOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eSuperTypes";
        EObject rightEClassB = this.getNodeNamed(right, "B");
        Assert.assertNotNull((Object)rightEClassB);
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        EStructuralFeature feature = rightEClassA.eClass().getEStructuralFeature("eSuperTypes");
        Assert.assertNotNull((Object)feature);
        EList eSuperTypes = ((EClass)rightEClassA).getESuperTypes();
        Assert.assertTrue((boolean)eSuperTypes.isEmpty());
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.RIGHT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftDeleteRightAdd_RtL_1() throws IOException {
        Resource left = this.input.getLeftDeleteRightAddLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightAddRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightAddOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eSuperTypes";
        EObject leftEClassB = this.getNodeNamed(left, "B");
        Assert.assertNotNull((Object)leftEClassB);
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        EStructuralFeature feature = leftEClassA.eClass().getEStructuralFeature("eSuperTypes");
        Assert.assertNotNull((Object)feature);
        EList eSuperTypes = ((EClass)leftEClassA).getESuperTypes();
        Assert.assertTrue((boolean)eSuperTypes.isEmpty());
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.LEFT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftDeleteRightAdd_RtL_2() throws IOException {
        Resource left = this.input.getLeftDeleteRightAddLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightAddRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightAddOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eSuperTypes";
        EObject leftEClassB = this.getNodeNamed(left, "B");
        Assert.assertNotNull((Object)leftEClassB);
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        EStructuralFeature feature = leftEClassA.eClass().getEStructuralFeature("eSuperTypes");
        Assert.assertNotNull((Object)feature);
        EList eSuperTypes = ((EClass)leftEClassA).getESuperTypes();
        Assert.assertTrue((boolean)eSuperTypes.contains((Object)leftEClassB));
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftDeleteRightSet_LtR_1() throws IOException {
        Resource left = this.input.getLeftDeleteRightSetLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightSetRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightSetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNull((Object)rightEClassA);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftDeleteRightSet_LtR_2() throws IOException {
        Resource left = this.input.getLeftDeleteRightSetLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightSetRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightSetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        UnmodifiableIterator diffs = Iterators.filter(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        Diff abstract_ = (Diff)diffs.next();
        this.batchMerger.copyAllLeftToRight(Arrays.asList(abstract_), (Monitor)new BasicMonitor());
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        Assert.assertFalse((boolean)((EClass)rightEClassA).isAbstract());
        Assert.assertTrue((boolean)((EClass)rightEClassA).isInterface());
        Diff interface_ = (Diff)diffs.next();
        this.batchMerger.copyAllLeftToRight(Arrays.asList(interface_), (Monitor)new BasicMonitor());
        Assert.assertNotNull((Object)rightEClassA);
        Assert.assertFalse((boolean)((EClass)rightEClassA).isAbstract());
        Assert.assertFalse((boolean)((EClass)rightEClassA).isInterface());
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.RIGHT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftDeleteRightSet_RtL_1() throws IOException {
        Resource left = this.input.getLeftDeleteRightSetLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightSetRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightSetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        Assert.assertFalse((boolean)((EClass)leftEClassA).isAbstract());
        Assert.assertFalse((boolean)((EClass)leftEClassA).isInterface());
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.LEFT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftDeleteRightSet_RtL_2() throws IOException {
        Resource left = this.input.getLeftDeleteRightSetLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightSetRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightSetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        UnmodifiableIterator diffs = Iterators.filter(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        Diff abstract_ = (Diff)diffs.next();
        this.batchMerger.copyAllRightToLeft(Arrays.asList(abstract_), (Monitor)new BasicMonitor());
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        Assert.assertTrue((boolean)((EClass)leftEClassA).isAbstract());
        Assert.assertFalse((boolean)((EClass)leftEClassA).isInterface());
        Diff interface_ = (Diff)diffs.next();
        this.batchMerger.copyAllRightToLeft(Arrays.asList(interface_), (Monitor)new BasicMonitor());
        Assert.assertNotNull((Object)leftEClassA);
        Assert.assertTrue((boolean)((EClass)leftEClassA).isAbstract());
        Assert.assertTrue((boolean)((EClass)leftEClassA).isInterface());
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftSetRightDelete_LtR_1() throws IOException {
        Resource left = this.input.getLeftSetRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftSetRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftSetRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        UnmodifiableIterator diffs = Iterators.filter(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        Diff abstract_ = (Diff)diffs.next();
        this.batchMerger.copyAllLeftToRight(Arrays.asList(abstract_), (Monitor)new BasicMonitor());
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        Assert.assertTrue((boolean)((EClass)rightEClassA).isAbstract());
        Assert.assertFalse((boolean)((EClass)rightEClassA).isInterface());
        Diff interface_ = (Diff)diffs.next();
        this.batchMerger.copyAllLeftToRight(Arrays.asList(interface_), (Monitor)new BasicMonitor());
        Assert.assertNotNull((Object)rightEClassA);
        Assert.assertTrue((boolean)((EClass)rightEClassA).isAbstract());
        Assert.assertTrue((boolean)((EClass)rightEClassA).isInterface());
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftSetRightDelete_LtR_2() throws IOException {
        Resource left = this.input.getLeftSetRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftSetRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftSetRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        Assert.assertFalse((boolean)((EClass)rightEClassA).isAbstract());
        Assert.assertFalse((boolean)((EClass)rightEClassA).isInterface());
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.RIGHT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftSetRightDelete_RtL_1() throws IOException {
        Resource left = this.input.getLeftSetRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftSetRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftSetRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        UnmodifiableIterator diffs = Iterators.filter(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        Diff abstract_ = (Diff)diffs.next();
        this.batchMerger.copyAllRightToLeft(Arrays.asList(abstract_), (Monitor)new BasicMonitor());
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        Assert.assertFalse((boolean)((EClass)leftEClassA).isAbstract());
        Assert.assertTrue((boolean)((EClass)leftEClassA).isInterface());
        Diff interface_ = (Diff)diffs.next();
        this.batchMerger.copyAllRightToLeft(Arrays.asList(interface_), (Monitor)new BasicMonitor());
        Assert.assertNotNull((Object)leftEClassA);
        Assert.assertFalse((boolean)((EClass)leftEClassA).isAbstract());
        Assert.assertFalse((boolean)((EClass)leftEClassA).isInterface());
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.LEFT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftSetRightDelete_RtL_2() throws IOException {
        Resource left = this.input.getLeftSetRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftSetRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftSetRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNull((Object)leftEClassA);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftSetRightUnset_LtR_1() throws IOException {
        Resource left = this.input.getLeftSetRightUnsetLeftConflictScope();
        Resource right = this.input.getLeftSetRightUnsetRightConflictScope();
        Resource origin = this.input.getLeftSetRightUnsetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eType";
        EObject rightEAttributeName = this.getNodeNamed(right, "name");
        Assert.assertNotNull((Object)rightEAttributeName);
        EStructuralFeature feature = rightEAttributeName.eClass().getEStructuralFeature("eType");
        Assert.assertNotNull((Object)feature);
        EClassifier eType = ((EAttribute)rightEAttributeName).getEType();
        Assert.assertNotNull((Object)eType);
        Assert.assertEquals((Object)eType.getName(), (Object)"EBoolean");
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftSetRightUnset_LtR_2() throws IOException {
        Resource left = this.input.getLeftSetRightUnsetLeftConflictScope();
        Resource right = this.input.getLeftSetRightUnsetRightConflictScope();
        Resource origin = this.input.getLeftSetRightUnsetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eType";
        EObject rightEAttributeName = this.getNodeNamed(right, "name");
        Assert.assertNotNull((Object)rightEAttributeName);
        EStructuralFeature feature = rightEAttributeName.eClass().getEStructuralFeature("eType");
        Assert.assertNotNull((Object)feature);
        EClassifier eType = ((EAttribute)rightEAttributeName).getEType();
        Assert.assertNotNull((Object)eType);
        Assert.assertEquals((Object)eType.getName(), (Object)"EString");
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.RIGHT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftSetRightUnset_RtL_1() throws IOException {
        Resource left = this.input.getLeftSetRightUnsetLeftConflictScope();
        Resource right = this.input.getLeftSetRightUnsetRightConflictScope();
        Resource origin = this.input.getLeftSetRightUnsetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eType";
        EObject leftEAttributeName = this.getNodeNamed(left, "name");
        Assert.assertNotNull((Object)leftEAttributeName);
        EStructuralFeature feature = leftEAttributeName.eClass().getEStructuralFeature("eType");
        Assert.assertNotNull((Object)feature);
        EClassifier eType = ((EAttribute)leftEAttributeName).getEType();
        Assert.assertNotNull((Object)eType);
        Assert.assertEquals((Object)eType.getName(), (Object)"EString");
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.LEFT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftSetRightUnset_RtL_2() throws IOException {
        Resource left = this.input.getLeftSetRightUnsetLeftConflictScope();
        Resource right = this.input.getLeftSetRightUnsetRightConflictScope();
        Resource origin = this.input.getLeftSetRightUnsetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eType";
        EObject leftEAttributeName = this.getNodeNamed(left, "name");
        Assert.assertNotNull((Object)leftEAttributeName);
        EStructuralFeature feature = leftEAttributeName.eClass().getEStructuralFeature("eType");
        Assert.assertNotNull((Object)feature);
        EClassifier eType = ((EAttribute)leftEAttributeName).getEType();
        Assert.assertNull((Object)eType);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftUnsetRightSet_LtR_1() throws IOException {
        Resource left = this.input.getLeftUnsetRightSetLeftConflictScope();
        Resource right = this.input.getLeftUnsetRightSetRightConflictScope();
        Resource origin = this.input.getLeftUnsetRightSetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eType";
        EObject rightEAttributeName = this.getNodeNamed(right, "name");
        Assert.assertNotNull((Object)rightEAttributeName);
        EStructuralFeature feature = rightEAttributeName.eClass().getEStructuralFeature("eType");
        Assert.assertNotNull((Object)feature);
        EClassifier eType = ((EAttribute)rightEAttributeName).getEType();
        Assert.assertNull((Object)eType);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftUnsetRightSet_LtR_2() throws IOException {
        Resource left = this.input.getLeftUnsetRightSetLeftConflictScope();
        Resource right = this.input.getLeftUnsetRightSetRightConflictScope();
        Resource origin = this.input.getLeftUnsetRightSetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eType";
        EObject rightEAttributeName = this.getNodeNamed(right, "name");
        Assert.assertNotNull((Object)rightEAttributeName);
        EStructuralFeature feature = rightEAttributeName.eClass().getEStructuralFeature("eType");
        Assert.assertNotNull((Object)feature);
        EClassifier eType = ((EAttribute)rightEAttributeName).getEType();
        Assert.assertNotNull((Object)eType);
        Assert.assertEquals((Object)eType.getName(), (Object)"EString");
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.RIGHT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftUnsetRightSet_RtL_1() throws IOException {
        Resource left = this.input.getLeftUnsetRightSetLeftConflictScope();
        Resource right = this.input.getLeftUnsetRightSetRightConflictScope();
        Resource origin = this.input.getLeftUnsetRightSetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eType";
        EObject leftEAttributeName = this.getNodeNamed(left, "name");
        Assert.assertNotNull((Object)leftEAttributeName);
        EStructuralFeature feature = leftEAttributeName.eClass().getEStructuralFeature("eType");
        Assert.assertNotNull((Object)feature);
        EClassifier eType = ((EAttribute)leftEAttributeName).getEType();
        Assert.assertNotNull((Object)eType);
        Assert.assertEquals((Object)eType.getName(), (Object)"EString");
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.LEFT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftUnsetRightSet_RtL_2() throws IOException {
        Resource left = this.input.getLeftUnsetRightSetLeftConflictScope();
        Resource right = this.input.getLeftUnsetRightSetRightConflictScope();
        Resource origin = this.input.getLeftUnsetRightSetOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eType";
        EObject leftEAttributeName = this.getNodeNamed(left, "name");
        Assert.assertNotNull((Object)leftEAttributeName);
        EStructuralFeature feature = leftEAttributeName.eClass().getEStructuralFeature("eType");
        Assert.assertNotNull((Object)feature);
        EClassifier eType = ((EAttribute)leftEAttributeName).getEType();
        Assert.assertNotNull((Object)eType);
        Assert.assertEquals((Object)eType.getName(), (Object)"EBoolean");
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftDeleteRightMove_LtR_1() throws IOException {
        Resource left = this.input.getLeftDeleteRightMoveLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightMoveRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightMoveOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightEClassB = this.getNodeNamed(right, "B");
        Assert.assertNull((Object)rightEClassB);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftDeleteRightMove_LtR_2() throws IOException {
        Resource left = this.input.getLeftDeleteRightMoveLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightMoveRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightMoveOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eStructuralFeatures";
        EObject rightEClassB = this.getNodeNamed(right, "B");
        Assert.assertNotNull((Object)rightEClassB);
        EStructuralFeature featureB = rightEClassB.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureB);
        EStructuralFeature eStructuralFeatureNameB = ((EClass)rightEClassB).getEStructuralFeature("name");
        Assert.assertNull((Object)eStructuralFeatureNameB);
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        EStructuralFeature featureA = rightEClassA.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureA);
        EStructuralFeature eStructuralFeatureNameA = ((EClass)rightEClassA).getEStructuralFeature("name");
        Assert.assertNotNull((Object)eStructuralFeatureNameA);
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.RIGHT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftDeleteRightMove_RtL_1() throws IOException {
        Resource left = this.input.getLeftDeleteRightMoveLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightMoveRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightMoveOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eStructuralFeatures";
        EObject leftEClassB = this.getNodeNamed(left, "B");
        Assert.assertNotNull((Object)leftEClassB);
        EStructuralFeature featureB = leftEClassB.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureB);
        EStructuralFeature eStructuralFeatureNameB = ((EClass)leftEClassB).getEStructuralFeature("name");
        Assert.assertNull((Object)eStructuralFeatureNameB);
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        EStructuralFeature featureA = leftEClassA.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureA);
        EStructuralFeature eStructuralFeatureNameA = ((EClass)leftEClassA).getEStructuralFeature("name");
        Assert.assertNotNull((Object)eStructuralFeatureNameA);
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.LEFT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftDeleteRightMove_RtL_2() throws IOException {
        Resource left = this.input.getLeftDeleteRightMoveLeftConflictScope();
        Resource right = this.input.getLeftDeleteRightMoveRightConflictScope();
        Resource origin = this.input.getLeftDeleteRightMoveOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eStructuralFeatures";
        EObject leftEClassB = this.getNodeNamed(left, "B");
        Assert.assertNotNull((Object)leftEClassB);
        EStructuralFeature featureB = leftEClassB.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureB);
        EStructuralFeature eStructuralFeatureNameB = ((EClass)leftEClassB).getEStructuralFeature("name");
        Assert.assertNotNull((Object)eStructuralFeatureNameB);
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        EStructuralFeature featureA = leftEClassA.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureA);
        EStructuralFeature eStructuralFeatureNameA = ((EClass)leftEClassA).getEStructuralFeature("name");
        Assert.assertNull((Object)eStructuralFeatureNameA);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftMoveRightDelete_LtR_1() throws IOException {
        Resource left = this.input.getLeftMoveRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftMoveRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftMoveRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        Assert.assertNotNull((Object)diff);
        Assert.assertNotNull((Object)diff.getConflict());
        Diff move = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE));
        Assert.assertNotNull((Object)move);
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eStructuralFeatures";
        EObject rightEClassB = this.getNodeNamed(right, "B");
        Assert.assertNotNull((Object)rightEClassB);
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        EStructuralFeature featureA = rightEClassA.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureA);
        EStructuralFeature eStructuralFeatureNameA = ((EClass)rightEClassA).getEStructuralFeature("name");
        Assert.assertNull((Object)eStructuralFeatureNameA);
        EStructuralFeature featureB = rightEClassB.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureB);
        EStructuralFeature eStructuralFeatureNameB = ((EClass)rightEClassB).getEStructuralFeature("name");
        Assert.assertNotNull((Object)eStructuralFeatureNameB);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftMoveRightDelete_LtR_2() throws IOException {
        Resource left = this.input.getLeftMoveRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftMoveRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftMoveRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        Assert.assertNotNull((Object)diff);
        Assert.assertNotNull((Object)diff.getConflict());
        Diff move = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE));
        Assert.assertNotNull((Object)move);
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eStructuralFeatures";
        EObject rightEClassB = this.getNodeNamed(right, "B");
        Assert.assertNotNull((Object)rightEClassB);
        EStructuralFeature featureB = rightEClassB.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureB);
        EStructuralFeature eStructuralFeatureNameB = ((EClass)rightEClassB).getEStructuralFeature("name");
        Assert.assertNull((Object)eStructuralFeatureNameB);
        EObject rightEClassA = this.getNodeNamed(right, "A");
        Assert.assertNotNull((Object)rightEClassA);
        EStructuralFeature featureA = rightEClassA.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureA);
        EStructuralFeature eStructuralFeatureNameA = ((EClass)rightEClassA).getEStructuralFeature("name");
        Assert.assertNotNull((Object)eStructuralFeatureNameA);
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.RIGHT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftMoveRightDelete_RtL_1() throws IOException {
        Resource left = this.input.getLeftMoveRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftMoveRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftMoveRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        Assert.assertNotNull((Object)diff);
        Assert.assertNotNull((Object)diff.getConflict());
        Diff move = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE));
        Assert.assertNotNull((Object)move);
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eStructuralFeatures";
        EObject leftEClassB = this.getNodeNamed(left, "B");
        Assert.assertNotNull((Object)leftEClassB);
        EStructuralFeature featureB = leftEClassB.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureB);
        EStructuralFeature eStructuralFeatureNameB = ((EClass)leftEClassB).getEStructuralFeature("name");
        Assert.assertNull((Object)eStructuralFeatureNameB);
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        EStructuralFeature featureA = leftEClassA.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureA);
        EStructuralFeature eStructuralFeatureNameA = ((EClass)leftEClassA).getEStructuralFeature("name");
        Assert.assertNotNull((Object)eStructuralFeatureNameA);
        for (Diff currentDiff : differences) {
            if (currentDiff.getSource() == DifferenceSource.LEFT) {
                Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)currentDiff));
                continue;
            }
            Assert.assertTrue((currentDiff.getState() == DifferenceState.UNRESOLVED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLeftMoveRightDelete_RtL_2() throws IOException {
        Resource left = this.input.getLeftMoveRightDeleteLeftConflictScope();
        Resource right = this.input.getLeftMoveRightDeleteRightConflictScope();
        Resource origin = this.input.getLeftMoveRightDeleteOriginConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        Assert.assertNotNull((Object)diff);
        Assert.assertNotNull((Object)diff.getConflict());
        Diff move = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE));
        Assert.assertNotNull((Object)move);
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "eStructuralFeatures";
        EObject leftEClassB = this.getNodeNamed(left, "B");
        Assert.assertNull((Object)leftEClassB);
        EObject leftEClassA = this.getNodeNamed(left, "A");
        Assert.assertNotNull((Object)leftEClassA);
        EStructuralFeature featureA = leftEClassA.eClass().getEStructuralFeature("eStructuralFeatures");
        Assert.assertNotNull((Object)featureA);
        EStructuralFeature eStructuralFeatureNameA = ((EClass)leftEClassA).getEStructuralFeature("name");
        Assert.assertNull((Object)eStructuralFeatureNameA);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftSetRightSetEEnum_LtR() throws IOException {
        Resource left = this.input.getLeftSetRightSetLeftEEnumConflictScope();
        Resource right = this.input.getLeftSetRightSetRightEEnumConflictScope();
        Resource origin = this.input.getLeftSetRightSetOriginEEnumConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "singlevalueEEnumAttribute";
        EObject rightNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNode);
        EStructuralFeature feature = rightNode.eClass().getEStructuralFeature("singlevalueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Object rightValue = rightNode.eGet(feature);
        Assert.assertEquals((Object)((Object)NodeEnum.B), (Object)rightValue);
        EObject leftNode = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)rightNode);
        Object leftValue = leftNode.eGet(feature);
        Assert.assertEquals((Object)((Object)NodeEnum.B), (Object)leftValue);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    @Test
    public void testLeftSetRightSetEEnum_RtL() throws IOException {
        Resource left = this.input.getLeftSetRightSetLeftEEnumConflictScope();
        Resource right = this.input.getLeftSetRightSetRightEEnumConflictScope();
        Resource origin = this.input.getLeftSetRightSetOriginEEnumConflictScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)2L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        String featureName = "singlevalueEEnumAttribute";
        EObject rightNode = this.getNodeNamed(right, "root");
        Assert.assertNotNull((Object)rightNode);
        EStructuralFeature feature = rightNode.eClass().getEStructuralFeature("singlevalueEEnumAttribute");
        Assert.assertNotNull((Object)feature);
        Object rightValue = rightNode.eGet(feature);
        Assert.assertEquals((Object)((Object)NodeEnum.C), (Object)rightValue);
        EObject leftNode = this.getNodeNamed(left, "root");
        Assert.assertNotNull((Object)rightNode);
        Object leftValue = leftNode.eGet(feature);
        Assert.assertEquals((Object)((Object)NodeEnum.C), (Object)leftValue);
        Assert.assertFalse((boolean)Iterators.any(differences.iterator(), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED}))));
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

