/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.fullcomparison;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.EMFCompareAssert;
import org.eclipse.emf.compare.tests.framework.EMFCompareTestBase;
import org.eclipse.emf.compare.tests.framework.IdentifierMatchValidator;
import org.eclipse.emf.compare.tests.framework.NotifierTuple;
import org.eclipse.emf.compare.tests.framework.junit.EMFCompareTestRunner;
import org.eclipse.emf.compare.tests.framework.junit.annotation.BeforeMatch;
import org.eclipse.emf.compare.tests.framework.junit.annotation.ConflictTest;
import org.eclipse.emf.compare.tests.framework.junit.annotation.DiffTest;
import org.eclipse.emf.compare.tests.framework.junit.annotation.MatchTest;
import org.eclipse.emf.compare.tests.framework.junit.annotation.UseCase;
import org.eclipse.emf.compare.tests.fullcomparison.data.identifier.IdentifierMatchInputData;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=EMFCompareTestRunner.class)
public class IdentifierComparisonTest
extends EMFCompareTestBase {
    private IdentifierMatchInputData inputData = new IdentifierMatchInputData();

    @UseCase(value="Extended library three-way")
    public NotifierTuple extlibrary3WayTuple() throws IOException {
        Resource left = this.inputData.getExtlibraryLeft();
        Resource right = this.inputData.getExtlibraryRight();
        Resource origin = this.inputData.getExtlibraryOrigin();
        return new NotifierTuple((Notifier)left, (Notifier)right, (Notifier)origin);
    }

    @UseCase(value="Extended library two-way")
    public NotifierTuple extlibrary2WayTuple() throws IOException {
        Resource left = this.inputData.getExtlibraryLeft();
        Resource right = this.inputData.getExtlibraryRight();
        return new NotifierTuple((Notifier)left, (Notifier)right, null);
    }

    @BeforeMatch
    public void beforeMatch(NotifierTuple tuple) {
        Assert.assertNotNull((Object)tuple);
        Assert.assertTrue((boolean)(tuple.getLeft() instanceof Resource));
        Assert.assertTrue((boolean)(tuple.getRight() instanceof Resource));
    }

    @MatchTest
    public void testIdentifierMatch(IComparisonScope scope, Comparison comparison) {
        Resource left = (Resource)scope.getLeft();
        Resource right = (Resource)scope.getRight();
        Resource origin = (Resource)scope.getOrigin();
        Assert.assertSame((Object)(origin != null ? 1 : 0), (Object)comparison.isThreeWay());
        Assert.assertEquals((long)1L, (long)comparison.getMatchedResources().size());
        MatchResource matchedResource = (MatchResource)comparison.getMatchedResources().get(0);
        Assert.assertEquals((Object)left.getURI().toString(), (Object)matchedResource.getLeftURI());
        Assert.assertEquals((Object)right.getURI().toString(), (Object)matchedResource.getRightURI());
        if (origin != null) {
            Assert.assertEquals((Object)origin.getURI().toString(), (Object)matchedResource.getOriginURI());
        }
        IdentifierMatchValidator validator = new IdentifierMatchValidator();
        validator.validate(comparison);
        List<EObject> leftChildren = IdentifierComparisonTest.getAllProperContent(left);
        List<EObject> rightChildren = IdentifierComparisonTest.getAllProperContent(right);
        List<EObject> originChildren = IdentifierComparisonTest.getAllProperContent(origin);
        EMFCompareAssert.assertAllMatched(leftChildren, comparison, scope);
        EMFCompareAssert.assertAllMatched(rightChildren, comparison, scope);
        EMFCompareAssert.assertAllMatched(originChildren, comparison, scope);
    }

    @DiffTest
    public void testIdentifierDiffTest(IComparisonScope scope, Comparison comparison) {
        EList differences = comparison.getDifferences();
        EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.BookCategory.Encyclopedia", DifferenceSource.LEFT);
        EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.BookCategory.Dictionary", DifferenceSource.LEFT);
        EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.Magazine", DifferenceSource.LEFT);
        EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.Magazine.title", DifferenceSource.LEFT);
        EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.Magazine.pages", DifferenceSource.LEFT);
        EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.Person.fullName", DifferenceSource.LEFT);
        EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Periodical", DifferenceSource.LEFT);
        EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Periodical.issuesPerYear", DifferenceSource.LEFT);
        EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Person.firstName", DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedAttribute((List<Diff>)differences, "extlibrary.Lendable", "name", "Lendable", "Borrowable", DifferenceSource.LEFT);
        EMFCompareAssert.assertAddedToReference((List<Diff>)differences, "extlibrary.Magazine", "eSuperTypes", "extlibrary.CirculatingItem", DifferenceSource.LEFT);
        EMFCompareAssert.assertRemovedFromReference((List<Diff>)differences, "extlibrary.Periodical", "eSuperTypes", "extlibrary.Item", DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Magazine.title", "eType", null, "ecore.EString", DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Magazine.pages", "eType", null, "ecore.EInt", DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Person.fullName", "eType", null, "ecore.EString", DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Periodical.issuesPerYear", "eType", "ecore.EInt", null, DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Person.firstName", "eType", "ecore.EString", null, DifferenceSource.LEFT);
        if (comparison.isThreeWay()) {
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Person.lastName", DifferenceSource.LEFT);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Person.lastName", "eType", "ecore.EString", null, DifferenceSource.LEFT);
            DifferenceSource side = DifferenceSource.RIGHT;
            EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.BookCategory.Manga", side);
            EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.BookCategory.Manhwa", side);
            EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.Book.subtitle", side);
            EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.Magazine", side);
            EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.TitledItem", side);
            EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.TitledItem.title", side);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Book.title", side);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.AudioVisualItem.title", side);
            EMFCompareAssert.assertAddedToReference((List<Diff>)differences, "extlibrary.Book", "eSuperTypes", "extlibrary.TitledItem", side);
            EMFCompareAssert.assertAddedToReference((List<Diff>)differences, "extlibrary.Periodical", "eSuperTypes", "extlibrary.TitledItem", side);
            EMFCompareAssert.assertAddedToReference((List<Diff>)differences, "extlibrary.AudioVisualItem", "eSuperTypes", "extlibrary.TitledItem", side);
            EMFCompareAssert.assertAddedToReference((List<Diff>)differences, "extlibrary.Magazine", "eSuperTypes", "extlibrary.Periodical", side);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Book.subtitle", "eType", null, "ecore.EString", side);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.TitledItem.title", "eType", null, "ecore.EString", side);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Book.title", "eType", "ecore.EString", null, side);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.AudioVisualItem.title", "eType", "ecore.EString", null, side);
            EMFCompareAssert.assertChangedAttribute((List<Diff>)differences, "extlibrary.AudioVisualItem.length", "name", "minutesLength", "length", DifferenceSource.LEFT);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.BookOnTape.reader", DifferenceSource.LEFT);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.BookOnTape.reader", DifferenceSource.RIGHT);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Periodical.title", DifferenceSource.LEFT);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Periodical.title", DifferenceSource.RIGHT);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.BookOnTape.reader", "eType", "extlibrary.Person", null, DifferenceSource.LEFT);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.BookOnTape.reader", "eType", "extlibrary.Person", null, DifferenceSource.RIGHT);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Periodical.title", "eType", "ecore.EString", null, DifferenceSource.LEFT);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Periodical.title", "eType", "ecore.EString", null, DifferenceSource.RIGHT);
            EMFCompareAssert.assertChangedAttribute((List<Diff>)differences, "extlibrary.Person.familyName", "name", "lastName", "familyName", side);
            EMFCompareAssert.assertChangedAttribute((List<Diff>)differences, "extlibrary.AudioVisualItem.length", "name", "minutesLength", "minutes", side);
        } else {
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Person.familyName", DifferenceSource.LEFT);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Person.familyName", "eType", "ecore.EString", null, DifferenceSource.LEFT);
            DifferenceSource side = DifferenceSource.LEFT;
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.BookCategory.Manga", side);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.BookCategory.Manhwa", side);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Book.subtitle", side);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.Magazine", side);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.TitledItem", side);
            EMFCompareAssert.assertRemoved((List<Diff>)differences, "extlibrary.TitledItem.title", side);
            EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.Book.title", side);
            EMFCompareAssert.assertAdded((List<Diff>)differences, "extlibrary.AudioVisualItem.title", side);
            EMFCompareAssert.assertRemovedFromReference((List<Diff>)differences, "extlibrary.Book", "eSuperTypes", "extlibrary.TitledItem", side);
            EMFCompareAssert.assertRemovedFromReference((List<Diff>)differences, "extlibrary.Periodical", "eSuperTypes", "extlibrary.TitledItem", side);
            EMFCompareAssert.assertRemovedFromReference((List<Diff>)differences, "extlibrary.AudioVisualItem", "eSuperTypes", "extlibrary.TitledItem", side);
            EMFCompareAssert.assertRemovedFromReference((List<Diff>)differences, "extlibrary.Magazine", "eSuperTypes", "extlibrary.Periodical", side);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Book.subtitle", "eType", "ecore.EString", null, side);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.TitledItem.title", "eType", "ecore.EString", null, side);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.Book.title", "eType", null, "ecore.EString", side);
            EMFCompareAssert.assertChangedReference((List<Diff>)differences, "extlibrary.AudioVisualItem.title", "eType", null, "ecore.EString", side);
            EMFCompareAssert.assertChangedAttribute((List<Diff>)differences, "extlibrary.AudioVisualItem.length", "name", "minutes", "length", DifferenceSource.LEFT);
        }
        Assert.assertTrue((boolean)differences.isEmpty());
    }

    @ConflictTest
    public void testIdentifierConflictTest(IComparisonScope scope, Comparison comparison) {
        EList conflicts = comparison.getConflicts();
        if (!comparison.isThreeWay()) {
            Assert.assertTrue((boolean)conflicts.isEmpty());
            return;
        }
        Assert.assertEquals((long)7L, (long)conflicts.size());
        Conflict periodicalConflict = null;
        Conflict titleConflict = null;
        Conflict titleETypeConflict = null;
        Conflict lastNameConflict = null;
        Conflict minutesLengthConflict = null;
        Conflict readerConflict = null;
        Conflict readerETypeConflict = null;
        block0: for (Conflict conflict : conflicts) {
            for (Diff diff : conflict.getDifferences()) {
                boolean breakLoop = false;
                Match match = diff.getMatch();
                if (this.isMatchOf(match, "Periodical") && conflict.getDifferences().size() == 3) {
                    periodicalConflict = conflict;
                    breakLoop = true;
                } else if (this.isMatchOf(match, "Periodical")) {
                    titleConflict = conflict;
                    breakLoop = true;
                } else if (this.isMatchOf(match, "Person")) {
                    lastNameConflict = conflict;
                    breakLoop = true;
                } else if (this.isMatchOf(match, "BookOnTape")) {
                    readerConflict = conflict;
                    breakLoop = true;
                } else if (this.isMatchOf(match, "minutesLength")) {
                    minutesLengthConflict = conflict;
                    breakLoop = true;
                } else if (this.isMatchOf(match, "reader")) {
                    readerETypeConflict = conflict;
                    breakLoop = true;
                } else if (this.isMatchOf(match, "title")) {
                    titleETypeConflict = conflict;
                    breakLoop = true;
                }
                if (breakLoop) continue block0;
            }
        }
        Assert.assertNotNull(periodicalConflict);
        Assert.assertNotNull(titleConflict);
        Assert.assertNotNull(titleETypeConflict);
        Assert.assertNotNull(lastNameConflict);
        Assert.assertNotNull(minutesLengthConflict);
        Assert.assertNotNull(readerConflict);
        Assert.assertNotNull(readerETypeConflict);
        assert (periodicalConflict != null);
        assert (titleConflict != null);
        assert (titleETypeConflict != null);
        assert (lastNameConflict != null);
        assert (minutesLengthConflict != null);
        assert (readerConflict != null);
        assert (readerETypeConflict != null);
        ArrayList periodicalDiffs = Lists.newArrayList((Iterable)periodicalConflict.getDifferences());
        Assert.assertSame((Object)ConflictKind.REAL, (Object)periodicalConflict.getKind());
        EMFCompareAssert.assertRemoved(periodicalDiffs, "extlibrary.Periodical", DifferenceSource.LEFT);
        EMFCompareAssert.assertAddedToReference(periodicalDiffs, "extlibrary.Periodical", "eSuperTypes", "extlibrary.TitledItem", DifferenceSource.RIGHT);
        EMFCompareAssert.assertAddedToReference(periodicalDiffs, "extlibrary.Magazine", "eSuperTypes", "extlibrary.Periodical", DifferenceSource.RIGHT);
        Assert.assertTrue((boolean)periodicalDiffs.isEmpty());
        ArrayList nameDiffs = Lists.newArrayList((Iterable)lastNameConflict.getDifferences());
        Assert.assertSame((Object)ConflictKind.REAL, (Object)lastNameConflict.getKind());
        EMFCompareAssert.assertRemoved(nameDiffs, "extlibrary.Person.lastName", DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedAttribute(nameDiffs, "extlibrary.Person.familyName", "name", "lastName", "familyName", DifferenceSource.RIGHT);
        Assert.assertTrue((boolean)nameDiffs.isEmpty());
        ArrayList lengthDiffs = Lists.newArrayList((Iterable)minutesLengthConflict.getDifferences());
        Assert.assertSame((Object)ConflictKind.REAL, (Object)minutesLengthConflict.getKind());
        EMFCompareAssert.assertChangedAttribute(lengthDiffs, "extlibrary.AudioVisualItem.length", "name", "minutesLength", "length", DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedAttribute(lengthDiffs, "extlibrary.AudioVisualItem.length", "name", "minutesLength", "minutes", DifferenceSource.RIGHT);
        Assert.assertTrue((boolean)lengthDiffs.isEmpty());
        ArrayList titleDiffs = Lists.newArrayList((Iterable)titleConflict.getDifferences());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)titleConflict.getKind());
        EMFCompareAssert.assertRemoved(titleDiffs, "extlibrary.Periodical.title", DifferenceSource.LEFT);
        EMFCompareAssert.assertRemoved(titleDiffs, "extlibrary.Periodical.title", DifferenceSource.RIGHT);
        Assert.assertTrue((boolean)titleDiffs.isEmpty());
        ArrayList titleETypeDiffs = Lists.newArrayList((Iterable)titleETypeConflict.getDifferences());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)titleConflict.getKind());
        EMFCompareAssert.assertChangedReference(titleETypeDiffs, "extlibrary.Periodical.title", "eType", "ecore.EString", null, DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedReference(titleETypeDiffs, "extlibrary.Periodical.title", "eType", "ecore.EString", null, DifferenceSource.RIGHT);
        Assert.assertTrue((boolean)titleETypeDiffs.isEmpty());
        ArrayList readerDiffs = Lists.newArrayList((Iterable)readerConflict.getDifferences());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)readerConflict.getKind());
        EMFCompareAssert.assertRemoved(readerDiffs, "extlibrary.BookOnTape.reader", DifferenceSource.LEFT);
        EMFCompareAssert.assertRemoved(readerDiffs, "extlibrary.BookOnTape.reader", DifferenceSource.RIGHT);
        Assert.assertTrue((boolean)readerDiffs.isEmpty());
        ArrayList readerETypeDiffs = Lists.newArrayList((Iterable)readerETypeConflict.getDifferences());
        Assert.assertSame((Object)ConflictKind.PSEUDO, (Object)readerETypeConflict.getKind());
        EMFCompareAssert.assertChangedReference(readerETypeDiffs, "extlibrary.BookOnTape.reader", "eType", "extlibrary.Person", null, DifferenceSource.LEFT);
        EMFCompareAssert.assertChangedReference(readerETypeDiffs, "extlibrary.BookOnTape.reader", "eType", "extlibrary.Person", null, DifferenceSource.RIGHT);
        Assert.assertTrue((boolean)readerETypeDiffs.isEmpty());
    }

    private boolean isMatchOf(Match match, String name) {
        boolean isMatch = false;
        if (match.getLeft() instanceof ENamedElement && ((ENamedElement)match.getLeft()).getName().equals(name)) {
            isMatch = true;
        }
        if (!isMatch && match.getRight() instanceof ENamedElement && ((ENamedElement)match.getRight()).getName().equals(name)) {
            isMatch = true;
        }
        if (!isMatch && match.getOrigin() instanceof ENamedElement && ((ENamedElement)match.getOrigin()).getName().equals(name)) {
            isMatch = true;
        }
        return isMatch;
    }
}

