/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public abstract class AbstractInputData {
    protected Resource loadFromClassLoader(String string) throws IOException {
        URL fileURL = this.getClass().getResource(string);
        InputStream str = fileURL.openStream();
        URI uri = URI.createURI((String)fileURL.toString());
        Resource.Factory resourceFactory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
        if (resourceFactory == null) {
            resourceFactory = new XMIResourceFactoryImpl();
        }
        Resource res = resourceFactory.createResource(uri);
        res.load(str, Collections.emptyMap());
        str.close();
        return res;
    }

    protected Resource loadFromClassLoader(String path, ResourceSet resourceSet) throws IOException {
        Resource resource;
        block13: {
            URL fileURL = this.getClass().getResource(path);
            URI uri = URI.createURI((String)fileURL.toString());
            Resource existing = resourceSet.getResource(uri, false);
            if (existing != null) {
                return existing;
            }
            InputStream stream = null;
            resource = null;
            try {
                try {
                    resource = resourceSet.createResource(uri);
                    stream = fileURL.openStream();
                    resource.load(stream, Collections.emptyMap());
                }
                catch (IOException | WrappedException throwable) {
                    if (stream == null) break block13;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return resource;
    }

    public ResourceSet loadFromClassLoader(List<String> paths, ResourceSet resourceSet) throws IOException {
        for (String path : paths) {
            this.loadFromClassLoader(path, resourceSet);
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
        }
        return resourceSet;
    }
}

