/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.merge;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.CompareDiagramIDEUIPapyrusPlugin;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.CompareUIPapyrusMessages;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.ResourceAttachmentChangeMerger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class PapyrusResourceAttachmentChangeMerger
extends ResourceAttachmentChangeMerger {
    public static final List<String> FILE_EXTENSIONS = Arrays.asList("uml", "di", "notation", "sash");
    private static final Logger LOGGER = Logger.getLogger(PapyrusResourceAttachmentChangeMerger.class);

    public boolean isMergerFor(Diff target) {
        try {
            return target instanceof ResourceAttachmentChange && this.isPapyrusChange((ResourceAttachmentChange)target);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean apply(IMergeCriterion criterion) {
        return criterion == null;
    }

    protected void move(ResourceAttachmentChange diff, boolean rightToLeft) {
        this.dealWithAssociatedEmptyResources(diff, rightToLeft);
        super.move(diff, rightToLeft);
    }

    protected void addInTarget(ResourceAttachmentChange diff, boolean rightToLeft) {
        this.dealWithAssociatedEmptyResources(diff, rightToLeft);
        super.addInTarget(diff, rightToLeft);
    }

    protected void removeFromTarget(ResourceAttachmentChange diff, boolean rightToLeft) {
        this.dealWithAssociatedEmptyResources(diff, rightToLeft);
        super.removeFromTarget(diff, rightToLeft);
    }

    private void dealWithAssociatedEmptyResources(ResourceAttachmentChange diff, boolean rightToLeft) {
        Comparison comp = ComparisonUtil.getComparison((Diff)diff);
        Iterable relatedMatchResource = Iterables.filter((Iterable)comp.getMatchedResources(), (Predicate)this.concernsTheSamePapyrusVirtualNodeAs(diff));
        ResourceSet targetRS = rightToLeft ? this.getResourceSet(comp, DifferenceSource.LEFT) : this.getResourceSet(comp, DifferenceSource.RIGHT);
        for (MatchResource mr : relatedMatchResource) {
            URI targetURI;
            if (rightToLeft) {
                if (mr.getLeft() != null && mr.getLeft().getContents().isEmpty()) {
                    if (mr.getRight() != null) continue;
                    this.delete(targetRS, mr.getLeft().getURI());
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info((Object)("Deleted empty resource " + mr.getLeft().getURI()));
                    continue;
                }
                if (mr.getRight() == null || !mr.getRight().getContents().isEmpty()) continue;
                targetURI = mr.getRight().getURI();
                if (targetRS.getURIConverter().exists(targetURI, Collections.emptyMap())) continue;
                targetRS.createResource(targetURI);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("Created empty resource " + targetURI));
                continue;
            }
            if (mr.getRight() != null && mr.getRight().getContents().isEmpty()) {
                if (mr.getLeft() != null) continue;
                this.delete(targetRS, mr.getRight().getURI());
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("Deleted empty resource " + mr.getRight().getURI()));
                continue;
            }
            if (mr.getLeft() == null || !mr.getLeft().getContents().isEmpty()) continue;
            targetURI = mr.getLeft().getURI();
            if (targetRS.getURIConverter().exists(targetURI, Collections.emptyMap())) continue;
            targetRS.createResource(targetURI);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info((Object)("Created empty resource " + targetURI));
        }
    }

    private ResourceSet getResourceSet(Comparison comp, DifferenceSource side) {
        switch (side) {
            case LEFT: {
                for (MatchResource mr : comp.getMatchedResources()) {
                    if (mr.getLeft() == null || mr.getLeft().getResourceSet() == null) continue;
                    return mr.getLeft().getResourceSet();
                }
            }
            case RIGHT: {
                for (MatchResource mr : comp.getMatchedResources()) {
                    if (mr.getRight() == null || mr.getRight().getResourceSet() == null) continue;
                    return mr.getRight().getResourceSet();
                }
                break;
            }
        }
        throw new IllegalStateException();
    }

    private void delete(ResourceSet rs, URI uri) {
        Resource toDelete = rs.getResource(uri, false);
        if (toDelete == null) {
            return;
        }
        try {
            toDelete.delete(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            CompareDiagramIDEUIPapyrusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.diagram.ide.ui.papyrus", CompareUIPapyrusMessages.getString("PapyrusResourceAttachmentChangeMerge.deleteFailure"), (Throwable)e));
        }
    }

    private boolean isPapyrusChange(ResourceAttachmentChange change) {
        Match match = change.getMatch();
        EObject o = match.getLeft();
        if (o == null && (o = match.getRight()) == null) {
            o = match.getOrigin();
        }
        return FILE_EXTENSIONS.contains(o.eResource().getURI().fileExtension());
    }

    private SameVirtualNode concernsTheSamePapyrusVirtualNodeAs(ResourceAttachmentChange change) {
        return new SameVirtualNode(change);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SameVirtualNode
    implements Predicate<MatchResource> {
        private final URI leftURI;
        private final URI rightURI;
        private final URI originURI;

        private SameVirtualNode(ResourceAttachmentChange change) {
            Match match = change.getMatch();
            this.leftURI = this.getResourceURI(match.getLeft());
            this.rightURI = this.getResourceURI(match.getRight());
            this.originURI = this.getResourceURI(match.getOrigin());
        }

        private URI getResourceURI(EObject o) {
            if (o == null || o.eResource() == null) {
                return null;
            }
            return o.eResource().getURI();
        }

        public boolean apply(MatchResource input) {
            if (input.getLeft() != null && this.leftURI != null) {
                URI uri = input.getLeft().getURI();
                return !this.leftURI.equals(uri) && this.leftURI.trimFileExtension().equals(uri.trimFileExtension());
            }
            if (input.getRight() != null && this.rightURI != null) {
                URI uri = input.getRight().getURI();
                return !this.rightURI.equals(uri) && this.rightURI.trimFileExtension().equals(uri.trimFileExtension());
            }
            if (input.getOrigin() != null && this.originURI != null && this.originURI.trimFileExtension() != null) {
                URI uri = input.getOrigin().getURI();
                return !this.originURI.equals(uri) && this.originURI.trimFileExtension().equals(uri.trimFileExtension());
            }
            return false;
        }
    }
}

