/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;

public class RedoAction
extends Action {
    protected ICompareEditingDomain domain;

    public RedoAction(ICompareEditingDomain domain) {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item", new Object[]{""}));
        this.setEditingDomain(domain);
    }

    @Deprecated
    public RedoAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item", new Object[]{""}));
    }

    public void run() {
        if (this.domain != null) {
            this.domain.getCommandStack().redo();
        }
    }

    public void setEditingDomain(ICompareEditingDomain domain) {
        this.domain = domain;
        if (domain != null) {
            this.update();
        }
    }

    public void update() {
        if (this.domain == null) {
            return;
        }
        this.setEnabled(this.domain.getCommandStack().canRedo());
        Command redoCommand = this.domain.getCommandStack().getRedoCommand();
        if (redoCommand != null && redoCommand.getLabel() != null) {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item", new Object[]{redoCommand.getLabel()}));
        } else {
            this.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item", new Object[]{""}));
        }
        if (redoCommand != null && redoCommand.getDescription() != null) {
            this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item_description", new Object[]{redoCommand.getDescription()}));
        } else {
            this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item_simple_description"));
        }
    }
}

