/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;

final class LayerBStreamedEXTDTAReaderInputStream
extends EXTDTAReaderInputStream {
    private final DDMReader reader;
    private ByteArrayInputStream currentBuffer;

    LayerBStreamedEXTDTAReaderInputStream(DDMReader reader, boolean readStatusByte) throws DRDAProtocolException {
        super(true, readStatusByte);
        this.reader = reader;
        this.currentBuffer = reader.readLOBInitStream();
    }

    @Override
    public final int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        return read == 1 ? b[0] : -1;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        int val;
        if (this.currentBuffer == null) {
            return -1;
        }
        if (this.reader.doingLayerBStreaming()) {
            val = this.currentBuffer.read(b, off, len);
            if (this.currentBuffer.available() == 0) {
                this.currentBuffer = this.reader.readLOBContinuationStream();
            }
        } else if (this.readStatusByte) {
            int maxToRead = this.currentBuffer.available() - 1;
            val = this.currentBuffer.read(b, off, Math.min(maxToRead, len));
            if (maxToRead == 0) {
                this.checkStatus(this.currentBuffer.read());
                val = -1;
                this.currentBuffer = null;
            } else if (maxToRead == val) {
                this.checkStatus(this.currentBuffer.read());
                this.currentBuffer = null;
            }
        } else {
            val = this.currentBuffer.read(b, off, len);
            if (this.currentBuffer.available() == 0) {
                this.currentBuffer = null;
            }
        }
        return val;
    }

    @Override
    public final int available() {
        int avail = 0;
        if (this.currentBuffer != null) {
            avail = this.currentBuffer.available();
            if (this.readStatusByte && !this.reader.doingLayerBStreaming()) {
                --avail;
            }
        }
        return avail;
    }

    @Override
    protected void onClientSideStreamingError() {
        this.currentBuffer = null;
    }
}

