/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexChanger;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class IndexSetChanger {
    IndexRowGenerator[] irgs;
    long[] indexCIDS;
    private DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private StaticCompiledOpenConglomInfo[] indexSCOCIs;
    String[] indexNames;
    ConglomerateController baseCC;
    FormatableBitSet baseRowReadMap;
    TransactionController tc;
    TemporaryRowHolderImpl rowHolder;
    IndexChanger[] indexChangers;
    private int lockMode;
    boolean[] fixOnUpdate;
    boolean isOpen = false;
    private static final int NO_INDEXES = 0;
    private static final int UPDATE_INDEXES = 1;
    private static final int ALL_INDEXES = 2;
    private int whatIsOpen = 0;
    private int isolationLevel;
    private final Activation activation;

    public IndexSetChanger(IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, DynamicCompiledOpenConglomInfo[] indexDCOCIs, String[] indexNames, ConglomerateController baseCC, TransactionController tc, int lockMode, FormatableBitSet baseRowReadMap, int isolationLevel, Activation activation) throws StandardException {
        this.irgs = irgs;
        this.indexCIDS = indexCIDS;
        this.indexSCOCIs = indexSCOCIs;
        this.indexDCOCIs = indexDCOCIs;
        this.indexNames = indexNames;
        this.baseCC = baseCC;
        this.tc = tc;
        this.lockMode = lockMode;
        this.baseRowReadMap = baseRowReadMap;
        this.isolationLevel = isolationLevel;
        this.activation = activation;
        SanityManager.ASSERT(indexCIDS != null, "indexCIDS is null");
        this.indexChangers = new IndexChanger[irgs.length];
    }

    public void open(boolean[] fixOnUpdate) throws StandardException {
        SanityManager.ASSERT(!this.isOpen, "IndexSetChanger already open");
        this.fixOnUpdate = fixOnUpdate;
        this.isOpen = true;
    }

    public void setRowHolder(TemporaryRowHolderImpl rowHolder) {
        this.rowHolder = rowHolder;
    }

    private void openIndexes(int whatToOpen) throws StandardException {
        SanityManager.ASSERT(this.isOpen, "IndexSetChanger closed");
        if (this.whatIsOpen >= whatToOpen) {
            return;
        }
        for (int ix = 0; ix < this.indexChangers.length; ++ix) {
            if (whatToOpen == 1 && !this.fixOnUpdate[ix]) continue;
            if (this.indexChangers[ix] == null) {
                this.indexChangers[ix] = new IndexChanger(this.irgs[ix], this.indexCIDS[ix], this.indexSCOCIs == null ? (StaticCompiledOpenConglomInfo)null : this.indexSCOCIs[ix], this.indexDCOCIs == null ? (DynamicCompiledOpenConglomInfo)null : this.indexDCOCIs[ix], this.indexNames == null ? null : this.indexNames[ix], this.baseCC, this.tc, this.lockMode, this.baseRowReadMap, this.isolationLevel, this.activation);
                this.indexChangers[ix].setRowHolder(this.rowHolder);
            } else {
                this.indexChangers[ix].setBaseCC(this.baseCC);
            }
            this.indexChangers[ix].open();
        }
        this.whatIsOpen = whatToOpen;
    }

    public void delete(ExecRow baseRow, RowLocation baseRowLocation) throws StandardException {
        this.openIndexes(2);
        for (int ix = 0; ix < this.indexChangers.length; ++ix) {
            this.indexChangers[ix].delete(baseRow, baseRowLocation);
        }
    }

    public void insert(ExecRow baseRow, RowLocation baseRowLocation) throws StandardException {
        this.openIndexes(2);
        for (int ix = 0; ix < this.indexChangers.length; ++ix) {
            this.indexChangers[ix].insert(baseRow, baseRowLocation);
        }
    }

    public void update(ExecRow oldBaseRow, ExecRow newBaseRow, RowLocation baseRowLocation) throws StandardException {
        this.openIndexes(1);
        for (int ix = 0; ix < this.indexChangers.length; ++ix) {
            if (!this.fixOnUpdate[ix]) continue;
            this.indexChangers[ix].update(oldBaseRow, newBaseRow, baseRowLocation);
        }
    }

    public void setBaseCC(ConglomerateController baseCC) {
        for (int ix = 0; ix < this.indexChangers.length; ++ix) {
            if (this.indexChangers[ix] == null) continue;
            this.indexChangers[ix].setBaseCC(baseCC);
        }
        this.baseCC = baseCC;
    }

    public void finish() throws StandardException {
        for (int ix = 0; ix < this.indexChangers.length; ++ix) {
            if (this.indexChangers[ix] == null) continue;
            this.indexChangers[ix].finish();
        }
    }

    public void close() throws StandardException {
        this.whatIsOpen = 0;
        for (int ix = 0; ix < this.indexChangers.length; ++ix) {
            if (this.indexChangers[ix] == null) continue;
            this.indexChangers[ix].close();
        }
        this.fixOnUpdate = null;
        this.isOpen = false;
        this.rowHolder = null;
    }

    public String toString() {
        String whatIsOpen_s = null;
        switch (this.whatIsOpen) {
            case 0: {
                whatIsOpen_s = "No open indexes ";
                break;
            }
            case 1: {
                whatIsOpen_s = "Update indexes open ";
                break;
            }
            case 2: {
                whatIsOpen_s = "All indexes open ";
                break;
            }
            default: {
                SanityManager.THROWASSERT("bad whatIsOpen value " + this.whatIsOpen);
            }
        }
        Object fixOnUpdate_s = "fixOnUpdate=(";
        for (int ix = 0; ix < this.fixOnUpdate.length; ++ix) {
            if (ix > 0) {
                fixOnUpdate_s = (String)fixOnUpdate_s + ",";
            }
            fixOnUpdate_s = (String)fixOnUpdate_s + this.fixOnUpdate[ix];
        }
        fixOnUpdate_s = (String)fixOnUpdate_s + ")";
        Object indexDesc_s = "\n";
        for (int ix = 0; ix < this.indexCIDS.length; ++ix) {
            indexDesc_s = this.indexChangers[ix] == null ? (String)indexDesc_s + "    Index[" + ix + "] cid=" + this.indexCIDS[ix] + " closed. \n" : (String)indexDesc_s + "    " + this.indexChangers[ix].toString() + "\n";
        }
        return "IndexSetChanger: " + whatIsOpen_s + (String)fixOnUpdate_s + (String)indexDesc_s;
    }
}

