/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.lob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.IOUtil;

public final class CDOBlob
extends CDOLob<InputStream> {
    public CDOBlob(InputStream contents) throws IOException {
        this(contents, DEFAULT_STORE);
    }

    public CDOBlob(InputStream contents, CDOLobStore store) throws IOException {
        super(contents, store);
    }

    public CDOBlob(byte[] contents) throws IOException {
        this(contents, DEFAULT_STORE);
    }

    public CDOBlob(byte[] contents, CDOLobStore store) throws IOException {
        super(new ByteArrayInputStream(contents), store);
    }

    public CDOBlob(String contentsHexString) throws IOException {
        this(contentsHexString, DEFAULT_STORE);
    }

    public CDOBlob(String contentsHexString, CDOLobStore store) throws IOException {
        super(new ByteArrayInputStream(HexUtil.hexToBytes((String)contentsHexString)), store);
    }

    CDOBlob(byte[] id, long size) {
        super(id, size);
    }

    CDOBlob(ExtendedDataInput in) throws IOException {
        super(in);
    }

    @Override
    public File getStoreFile() {
        return this.getStore().getBinaryFile(this.getID());
    }

    @Override
    public InputStream getContents() throws IOException {
        return this.getStore().getBinary(this);
    }

    public byte[] getBytes() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = this.getContents();){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            return outputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getString() throws IOException {
        return HexUtil.bytesToHex((byte[])this.getBytes());
    }

    public void copyTo(OutputStream out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = this.getContents();){
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected CDOLobInfo put(InputStream contents) throws IOException {
        return this.getStore().putBinary(contents);
    }
}

