/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.buddies;

import java.text.MessageFormat;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.buddies.BuddiesUtil;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.ISessionManager;
import org.eclipse.net4j.buddies.ISessionManagerEvent;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.internal.buddies.Self;
import org.eclipse.net4j.internal.buddies.bundle.OM;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class SessionManager
extends Lifecycle
implements ISessionManager,
IListener {
    public static final SessionManager INSTANCE = new SessionManager();
    private IBuddySession session;
    private ISessionManager.State state = ISessionManager.State.DISCONNECTED;
    private boolean connecting;
    private boolean flashing;

    private SessionManager() {
    }

    @Override
    public IBuddySession getSession() {
        return this.session;
    }

    @Override
    public ISessionManager.State getState() {
        return this.state;
    }

    public void setState(ISessionManager.State state) {
        if (this.state != state) {
            ISessionManager.State oldState = this.state;
            this.state = state;
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                SessionManagerEvent event = new SessionManagerEvent(oldState, state, this.session);
                this.fireEvent(event, listeners);
            }
        }
    }

    @Override
    public boolean isFlashing() {
        return this.flashing;
    }

    @Override
    public boolean isConnecting() {
        return this.state == ISessionManager.State.CONNECTING;
    }

    public String getConnectorDescription() {
        return (String)OM.PREF_CONNECTOR_DESCRIPTION.getValue();
    }

    public String getUserID() {
        return (String)OM.PREF_USER_ID.getValue();
    }

    public String getPassword() {
        return (String)OM.PREF_PASSWORD.getValue();
    }

    public Boolean isAutoConnect() {
        return (Boolean)OM.PREF_AUTO_CONNECT.getValue();
    }

    @Override
    public void connect() {
        new Thread("buddies-connector"){

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    block10: {
                        String password;
                        String userID;
                        block9: {
                            userID = SessionManager.this.getUserID();
                            password = SessionManager.this.getPassword();
                            SessionManager.this.setState(ISessionManager.State.CONNECTING);
                            SessionManager.this.connecting = true;
                            if (!true) break block9;
                            if (SessionManager.this.session != null) return;
                            if (!SessionManager.this.connecting) break block10;
                        }
                        do {
                            IConnector connector;
                            if ((connector = Net4jUtil.getConnector((IManagedContainer)IPluginContainer.INSTANCE, (String)SessionManager.this.getConnectorDescription())) == null) {
                                throw new IllegalStateException("connector == null");
                            }
                            SessionManager.this.session = BuddiesUtil.openSession(connector, userID, password, 5000L);
                            if (SessionManager.this.session != null) {
                                if (SessionManager.this.connecting) {
                                    SessionManager.this.session.addListener(SessionManager.this);
                                    SessionManager.this.setState(ISessionManager.State.CONNECTED);
                                } else {
                                    SessionManager.this.session.close();
                                    SessionManager.this.session = null;
                                    SessionManager.this.setState(ISessionManager.State.DISCONNECTED);
                                }
                            }
                            if (SessionManager.this.session != null) return;
                        } while (SessionManager.this.connecting);
                    }
                    return;
                }
                finally {
                    SessionManager.this.connecting = false;
                }
            }
        }.start();
    }

    @Override
    public void disconnect() {
        this.connecting = false;
        if (this.session != null) {
            this.session.removeListener(this);
            this.session.close();
            this.session = null;
        }
        this.setState(ISessionManager.State.DISCONNECTED);
    }

    @Override
    public void flashMe() {
        if (this.session != null && !this.flashing) {
            final Self self = (Self)this.session.getSelf();
            final IBuddy.State original = self.getState();
            new Thread("buddies-flasher"){

                @Override
                public void run() {
                    SessionManager.this.flashing = true;
                    IBuddy.State state = original == IBuddy.State.AVAILABLE ? IBuddy.State.LONESOME : IBuddy.State.AVAILABLE;
                    int i = 0;
                    while (i < 15) {
                        self.setState(state);
                        ConcurrencyUtil.sleep((long)200L);
                        state = state == IBuddy.State.AVAILABLE ? IBuddy.State.LONESOME : IBuddy.State.AVAILABLE;
                        ++i;
                    }
                    self.setState(original);
                    SessionManager.this.flashing = false;
                }
            }.start();
        }
    }

    public void notifyEvent(IEvent event) {
        if (event.getSource() == this.session) {
            if (event instanceof ILifecycleEvent) {
                if (((ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                    this.disconnect();
                    if (this.isAutoConnect().booleanValue()) {
                        this.connect();
                    }
                }
            } else if (event instanceof IContainerEvent) {
                IContainerEvent e = (IContainerEvent)event;
                if (e.getDeltaKind() == IContainerDelta.Kind.ADDED) {
                    ((IBuddy)e.getDeltaElement()).addListener((IListener)this);
                } else if (e.getDeltaKind() == IContainerDelta.Kind.REMOVED) {
                    ((IBuddy)e.getDeltaElement()).removeListener((IListener)this);
                }
            }
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.isAutoConnect().booleanValue()) {
            this.connect();
        }
    }

    protected void doDeactivate() throws Exception {
        this.disconnect();
        super.doDeactivate();
    }

    private final class SessionManagerEvent
    extends Event
    implements ISessionManagerEvent {
        private static final long serialVersionUID = 1L;
        private ISessionManager.State oldState;
        private ISessionManager.State newState;
        private IBuddySession session;

        public SessionManagerEvent(ISessionManager.State oldState, ISessionManager.State newState, IBuddySession session) {
            super((INotifier)SessionManager.this);
            this.oldState = oldState;
            this.newState = newState;
            this.session = session;
        }

        @Override
        public ISessionManager.State getOldState() {
            return this.oldState;
        }

        @Override
        public ISessionManager.State getNewState() {
            return this.newState;
        }

        @Override
        public IBuddySession getSession() {
            return this.session;
        }

        public String toString() {
            return MessageFormat.format("SessionManagerEvent[source={0}, oldState={1}, newState={2}, session={3}]", new Object[]{this.getSource(), this.getOldState(), this.getNewState(), this.getSession()});
        }
    }
}

