/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.evolution.phased.Context;
import org.eclipse.emf.cdo.server.db.evolution.phased.ISchemaMigration;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IFeatureMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.internal.db.IObjectTypeMapper;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.MappingNames;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.ObjectTypeCache;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.ObjectTypeTable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.BatchingIDChanger;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.StatementBatcher;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.IDChanger;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.concurrent.Holder;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.PropertiesEvent;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class AbstractHorizontalMappingStrategy
extends AbstractMappingStrategy
implements ISchemaMigration {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalMappingStrategy.class);
    private static final EAttribute[] NO_PERSISTENT_LOB_ATTRIBUTES = new EAttribute[0];
    private ObjectTypeTable objects;
    private IObjectTypeMapper objectTypeMapper;
    private IClassMapping resourceFolderMapping;
    private IClassMapping modelResourceMapping;
    private IClassMapping textResourceMapping;
    private IClassMapping binaryResourceMapping;

    public final ObjectTypeTable objects() {
        return this.objects;
    }

    public IObjectTypeMapper getObjectTypeMapper() {
        return this.objectTypeMapper;
    }

    @Override
    public CDOClassifierRef readObjectType(IDBStoreAccessor accessor, CDOID id) {
        EClass type = this.readObjectType2(accessor, id);
        if (type == null) {
            return null;
        }
        return new CDOClassifierRef((EClassifier)type);
    }

    @Override
    public EClass readObjectType2(IDBStoreAccessor accessor, CDOID id) {
        return this.objectTypeMapper.getObjectType(accessor, id);
    }

    public boolean putObjectType(IDBStoreAccessor accessor, long timeStamp, CDOID id, EClass type) {
        return this.objectTypeMapper.putObjectType(accessor, timeStamp, id, type);
    }

    public boolean removeObjectType(IDBStoreAccessor accessor, CDOID id) {
        return this.objectTypeMapper.removeObjectType(accessor, id);
    }

    @Override
    public void repairAfterCrash(IDBAdapter dbAdapter, Connection connection) {
        IDBStore store = this.getStore();
        IRepository repository = store.getRepository();
        if (repository.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            IIDHandler idHandler = store.getIDHandler();
            if (repository.isSupportingBranches()) {
                CDOID minLocalID = this.getMinLocalID(connection);
                idHandler.setNextLocalObjectID(minLocalID);
            }
            CDOID maxID = this.objectTypeMapper.getMaxID(connection, idHandler);
            idHandler.setLastObjectID(maxID);
        }
    }

    @Override
    public void queryResources(IDBStoreAccessor accessor, IStoreAccessor.QueryResourcesContext context) {
        boolean shallContinue;
        if (context.getTimeStamp() != 0L && !this.hasAuditSupport()) {
            throw new IllegalArgumentException("Mapping Strategy does not support audits");
        }
        if (this.resourceFolderMapping == null) {
            this.resourceFolderMapping = this.getClassMapping(EresourcePackage.eINSTANCE.getCDOResourceFolder());
            this.modelResourceMapping = this.getClassMapping(EresourcePackage.eINSTANCE.getCDOResource());
            this.textResourceMapping = this.getClassMapping(EresourcePackage.eINSTANCE.getCDOTextResource());
            this.binaryResourceMapping = this.getClassMapping(EresourcePackage.eINSTANCE.getCDOBinaryResource());
        }
        if (shallContinue = true) {
            shallContinue = this.queryResources(accessor, this.resourceFolderMapping, context);
        }
        if (shallContinue) {
            shallContinue = this.queryResources(accessor, this.modelResourceMapping, context);
        }
        if (shallContinue) {
            shallContinue = this.queryResources(accessor, this.textResourceMapping, context);
        }
        if (shallContinue) {
            shallContinue = this.queryResources(accessor, this.binaryResourceMapping, context);
        }
    }

    @Override
    public void queryXRefs(IDBStoreAccessor accessor, IStoreAccessor.QueryXRefsContext context) {
        IIDHandler idHandler = this.getStore().getIDHandler();
        StringBuilder builder = null;
        for (CDOID targetID : context.getTargetObjects().keySet()) {
            if (builder == null) {
                builder = new StringBuilder("(");
            } else {
                builder.append(",");
            }
            idHandler.appendCDOID(builder, targetID);
        }
        builder.append(")");
        String idString = builder.toString();
        for (EClass eClass : context.getSourceCandidates().keySet()) {
            IClassMapping classMapping = this.getClassMapping(eClass);
            boolean more = classMapping.queryXRefs(accessor, context, idString);
            if (more) continue;
            return;
        }
    }

    @Override
    public void migrateSchema(Context context, IDBStoreAccessor accessor) throws SQLException {
        ModelEvolutionHelper helper = new ModelEvolutionHelper(context);
        helper.evolveSchema();
        helper.evolveUsedClasses(accessor);
    }

    @Override
    public void rawExport(IDBStoreAccessor accessor, CDODataOutput out, int fromBranchID, int toBranchID, long fromCommitTime, long toCommitTime) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(" WHERE a_t.");
        builder.append(DBUtil.quoted((String)MappingNames.ATTRIBUTES_CREATED));
        builder.append(" BETWEEN ");
        builder.append(fromCommitTime);
        builder.append(" AND ");
        builder.append(toCommitTime);
        String attrSuffix = builder.toString();
        IDBConnection connection = accessor.getDBConnection();
        Collection<IClassMapping> classMappings = this.getClassMappings(true).values();
        out.writeXInt(classMappings.size());
        for (IClassMapping classMapping : classMappings) {
            EClass eClass = classMapping.getEClass();
            out.writeCDOClassifierRef((EClassifier)eClass);
            IDBTable table = classMapping.getTable();
            DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)table, (String)"a_t", (String)attrSuffix);
            for (IListMapping listMapping : classMapping.getListMappings()) {
                this.rawExportList(out, connection, listMapping, table, attrSuffix);
            }
        }
        this.objectTypeMapper.rawExport((Connection)connection, out, fromCommitTime, toCommitTime);
    }

    protected void rawExportList(CDODataOutput out, IDBConnection connection, IListMapping listMapping, IDBTable attrTable, String attrSuffix) throws IOException {
        for (IDBTable table : listMapping.getDBTables()) {
            String listSuffix = ", " + attrTable + " a_t" + attrSuffix;
            String listJoin = this.getListJoinForRawExport("a_t", "l_t");
            if (listJoin != null) {
                listSuffix = String.valueOf(listSuffix) + listJoin;
            }
            DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)table, (String)"l_t", (String)listSuffix);
        }
    }

    protected String getListJoinForRawExport(String attrTable, String listTable) {
        return this.getListJoin(attrTable, listTable);
    }

    @Override
    public void rawImport(IDBStoreAccessor accessor, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        int size = in.readXInt();
        if (size == 0) {
            return;
        }
        int objectTypeMapperWork = 10;
        monitor.begin((double)(3 * size + objectTypeMapperWork));
        try {
            IDBConnection connection = accessor.getDBConnection();
            int i = 0;
            while (i < size) {
                EClass eClass = (EClass)in.readCDOClassifierRefAndResolve();
                IClassMapping classMapping = this.getClassMapping(eClass);
                IDBTable table = classMapping.getTable();
                DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)table, (OMMonitor)monitor.fork());
                this.rawImportReviseOldRevisions(connection, table, monitor.fork());
                this.rawImportUnreviseNewRevisions(connection, table, fromCommitTime, toCommitTime, monitor.fork());
                List<IListMapping> listMappings = classMapping.getListMappings();
                int listSize = listMappings.size();
                if (listSize == 0) {
                    monitor.worked();
                } else {
                    OMMonitor listMonitor = monitor.fork();
                    listMonitor.begin((double)listSize);
                    try {
                        for (IListMapping listMapping : listMappings) {
                            this.rawImportList(in, connection, listMapping, listMonitor.fork());
                        }
                    }
                    finally {
                        listMonitor.done();
                    }
                }
                ++i;
            }
            this.objectTypeMapper.rawImport((Connection)connection, in, monitor.fork((double)objectTypeMapperWork));
        }
        finally {
            monitor.done();
        }
    }

    protected void rawImportUnreviseNewRevisions(IDBConnection connection, IDBTable table, long fromCommitTime, long toCommitTime, OMMonitor monitor) {
        throw new UnsupportedOperationException("Must be overridden");
    }

    protected void rawImportReviseOldRevisions(IDBConnection connection, IDBTable table, OMMonitor monitor) {
        throw new UnsupportedOperationException("Must be overridden");
    }

    protected void rawImportList(CDODataInput in, IDBConnection connection, IListMapping listMapping, OMMonitor monitor) throws IOException {
        Collection<IDBTable> tables = listMapping.getDBTables();
        int size = tables.size();
        if (size == 0) {
            return;
        }
        monitor.begin((double)size);
        try {
            for (IDBTable table : tables) {
                DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)table, (OMMonitor)monitor.fork(), (DBUtil.DeserializeRowHandler)this.getImportListHandler());
            }
        }
        finally {
            monitor.done();
        }
    }

    protected DBUtil.DeserializeRowHandler getImportListHandler() {
        return null;
    }

    @Override
    public String getListJoin(String attrTable, String listTable) {
        return " AND " + attrTable + "." + DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID) + "=" + listTable + "." + DBUtil.quoted((String)MappingNames.LIST_REVISION_ID);
    }

    @Override
    protected boolean isMapped(EClass eClass) {
        return !eClass.isAbstract() && !eClass.isInterface();
    }

    @Override
    protected Collection<EClass> getClassesWithObjectInfo() {
        return this.getClassMappings().keySet();
    }

    @Override
    protected EAttribute[] getPersistentLobAttributes(EClass eClass) {
        if (!eClass.isAbstract() && !eClass.isInterface()) {
            return CDOModelUtil.getClassInfo((EClass)eClass).getAllPersistentLobAttributes();
        }
        return NO_PERSISTENT_LOB_ATTRIBUTES;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.objectTypeMapper == null) {
            this.objectTypeMapper = this.createObjectTypeMapper();
        }
        LifecycleUtil.activate((Object)this.objectTypeMapper);
    }

    @Override
    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.objectTypeMapper);
        this.resourceFolderMapping = null;
        this.modelResourceMapping = null;
        this.textResourceMapping = null;
        this.binaryResourceMapping = null;
        super.doDeactivate();
    }

    private IObjectTypeMapper createObjectTypeMapper() {
        this.objects = new ObjectTypeTable(this.getStore());
        int cacheSize = this.getObjectTypeCacheSize();
        if (cacheSize == 0) {
            return this.objects;
        }
        ObjectTypeCache cache = new ObjectTypeCache(cacheSize);
        cache.setMappingStrategy(this);
        cache.setDelegate(this.objects);
        return cache;
    }

    private int getObjectTypeCacheSize() {
        int objectTypeCacheSize = 100000;
        String value = this.getProperties().get("objectTypeCacheSize");
        if (value != null) {
            try {
                int intValue;
                objectTypeCacheSize = intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                OM.LOG.warn("Malformed configuration option for object type cache size. Using default.");
            }
        }
        return objectTypeCacheSize;
    }

    private boolean queryResources(IDBStoreAccessor accessor, IClassMapping classMapping, IStoreAccessor.QueryResourcesContext context) {
        CDOID folderID = context.getFolderID();
        String name = context.getName();
        boolean exactMatch = context.exactMatch();
        IIDHandler idHandler = this.getStore().getIDHandler();
        PreparedStatement stmt = classMapping.createResourceQueryStatement(accessor, folderID, name, exactMatch, (CDOBranchPoint)context);
        if (stmt == null) {
            return true;
        }
        ResultSet resultSet = null;
        try {
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CDOID id = idHandler.getCDOID(resultSet, 1);
                if (TRACER.isEnabled()) {
                    TRACER.trace("Resource query returned ID " + id);
                }
                if (context.addResource(id)) continue;
                return false;
            }
            return true;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    private CDOID getMinLocalID(Connection connection) {
        IIDHandler idHandler = this.getStore().getIDHandler();
        CDOID[] min = new CDOID[]{idHandler.getMaxCDOID()};
        String id = DBUtil.quoted((String)MappingNames.ATTRIBUTES_ID);
        String branch = DBUtil.quoted((String)MappingNames.ATTRIBUTES_BRANCH);
        String created = DBUtil.quoted((String)MappingNames.ATTRIBUTES_CREATED);
        String prefix = "SELECT MIN(t." + id + ") FROM " + this.objects + " o, ";
        String suffix = " t WHERE t." + branch + "<0 AND t." + id + "=o." + id + " AND t." + created + "=o." + created;
        this.getStore().visitAllTables(connection, (c, name) -> {
            Statement stmt = null;
            ResultSet resultSet = null;
            try {
                CDOID id1;
                stmt = connection.createStatement();
                resultSet = stmt.executeQuery(String.valueOf(prefix) + name + suffix);
                if (resultSet.next() && (id1 = idHandler.getCDOID(resultSet, 1)) != null && idHandler.compare(id1, min[0]) < 0) {
                    cDOIDArray[0] = id1;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        });
        return min[0];
    }

    private final class ModelEvolutionHelper {
        private final Context context;
        private final PropertiesEvent event;

        public ModelEvolutionHelper(Context context) {
            this.event = new PropertiesEvent((INotifier)AbstractHorizontalMappingStrategy.this){

                public PropertiesEvent fire() {
                    if (!EventUtil.fireEvent((Object)ModelEvolutionHelper.this.context.getSupport(), (IEvent)this)) {
                        AbstractHorizontalMappingStrategy.this.fireEvent((IEvent)this);
                    }
                    return this;
                }

                protected String formatEventName() {
                    return "SchemaMigrationEvent";
                }
            };
            this.context = context;
        }

        public void evolveSchema() throws SQLException {
            this.event.setType("StartingSchemaMigration").fire();
            Holder schemaTransactionHolder = new Holder(() -> {
                this.event.setType("OpeningSchemaTransaction").fire();
                IDBSchemaTransaction schemaTransaction = this.context.getSupport().getStore().getDatabase().openSchemaTransaction();
                this.event.setType("OpenedSchemaTransaction").addProperty("schemaTransaction", (Object)schemaTransaction).fire();
                return schemaTransaction;
            });
            Supplier<IDBSchema> workingCopySupplier = () -> ((IDBSchemaTransaction)schemaTransactionHolder.get()).getWorkingCopy();
            try {
                this.context.getOldPackages().values().forEach(oldPackage -> {
                    for (EClassifier oldClassifier : oldPackage.getEClassifiers()) {
                        EStructuralFeature[] addedFeatures;
                        EClass newClass;
                        EClass oldClass;
                        if (!(oldClassifier instanceof EClass) || !AbstractHorizontalMappingStrategy.this.isMapped(oldClass = (EClass)oldClassifier) || (newClass = this.context.getNewElement(oldClass)) == null || !AbstractHorizontalMappingStrategy.this.isMapped(newClass) || (addedFeatures = this.getAddedFeatures(oldClass, newClass)).length == 0) continue;
                        IClassMapping classMapping = AbstractHorizontalMappingStrategy.this.doCreateClassMapping(oldClass);
                        String tableName = classMapping.getTable().getName();
                        IDBTable table = ((IDBSchema)workingCopySupplier.get()).getTable(tableName);
                        this.context.log("Creating new feature mappings for class " + EMFUtil.getFullyQualifiedName((EObject)oldClass) + " in table " + table + ": " + Arrays.stream(addedFeatures).map(ENamedElement::getName).collect(Collectors.joining(", ")));
                        AbstractHorizontalClassMapping.createFeatureMappings(AbstractHorizontalMappingStrategy.this, newClass, table, addedFeatures);
                    }
                });
                schemaTransactionHolder.handleIfSet(schemaTransaction -> {
                    this.event.setType("CommittingSchemaTransaction").fire();
                    schemaTransaction.commit();
                    this.event.setType("CommittedSchemaTransaction").fire().removeProperty("schemaTransaction");
                });
            }
            finally {
                schemaTransactionHolder.handleIfSet(Closeable::close);
            }
        }

        public void evolveUsedClasses(IDBStoreAccessor accessor) throws SQLException {
            HashMap usedClasses = new HashMap();
            Map fromObjectsByURI = this.context.getElementMappings().getFromObjectsByURI();
            AbstractHorizontalMappingStrategy.this.objects.handleObjectTypes(accessor, (raw, metaID, uri) -> {
                Object object = ObjectUtil.ifNotNull((Object)((EClass)fromObjectsByURI.get(uri)), usedClass -> {
                    String string2 = usedClasses.put(usedClass, raw);
                });
            });
            this.event.setType("EvolvingUsedClasses").addProperty("usedClasses", usedClasses).fire();
            Throwable throwable = null;
            Object var5_6 = null;
            try (StatementBatcher batcher = this.createBatcher(accessor);){
                usedClasses.keySet().forEach(eClass -> this.evolveUsedClass(batcher, usedClasses, (EClass)eClass));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.event.setType("EvolvedUsedClasses").fire();
        }

        private void evolveUsedClass(StatementBatcher batcher, Map<EClass, String> usedClasses, EClass usedClass) {
            this.event.setType("EvolvingUsedClass").addProperty("usedClass", (Object)usedClass).fire();
            Holder classMappingHolder = new Holder(() -> Objects.requireNonNull(AbstractHorizontalMappingStrategy.this.getClassMapping(usedClass)));
            HashMap containerChanges = new HashMap();
            this.context.handleFeatureIDChanges(usedClass, this::getContainerReferences, (oldFeatureID, newFeatureID) -> {
                Integer n = containerChanges.put(oldFeatureID, newFeatureID);
            });
            if (!containerChanges.isEmpty()) {
                this.context.log("Adjusting container reference IDs for class " + EMFUtil.getFullyQualifiedName((EObject)usedClass));
                IDChanger.changeIDs(containerChanges, (IDChanger.ChangeHandler)new ContainerIDChanger(batcher, (IClassMapping)classMappingHolder.get()));
            }
            this.handleContainmentCandidates(usedClass, usedClasses.keySet(), (containerClass, containments) -> {
                HashMap containmentChanges = new HashMap();
                this.context.handleFeatureIDChanges((EClass)containerClass, ec -> containments, (oldFeatureID, newFeatureID) -> {
                    int oldID = -1 - oldFeatureID;
                    int newID = -1 - newFeatureID;
                    containmentChanges.put(oldID, newID);
                });
                if (!containmentChanges.isEmpty()) {
                    this.context.log("Adjusting containment reference IDs for class " + EMFUtil.getFullyQualifiedName((EObject)usedClass));
                    String rawContainerTypeID = (String)usedClasses.get(containerClass);
                    IDChanger.changeIDs(containmentChanges, (IDChanger.ChangeHandler)new ContainmentIDChanger(batcher, (IClassMapping)classMappingHolder.get(), AbstractHorizontalMappingStrategy.this.objects, rawContainerTypeID));
                }
            });
            for (EAttribute attribute : usedClass.getEAllAttributes()) {
                EEnum oldEnum;
                Map<Integer, Integer> changes;
                EClassifier type = attribute.getEType();
                if (!(type instanceof EEnum) || ObjectUtil.isEmpty(changes = this.context.getEnumLiteralChanges(oldEnum = (EEnum)type))) continue;
                this.context.log("Adjusting enum literal IDs for attribute " + EMFUtil.getFullyQualifiedName((EObject)usedClass) + "." + attribute.getName());
                IClassMapping classMapping = (IClassMapping)classMappingHolder.get();
                IFeatureMapping featureMapping = classMapping.getFeatureMapping((EStructuralFeature)attribute);
                IDBField valueField = featureMapping.getField();
                IDChanger.changeIDs(changes, (IDChanger.ChangeHandler)new BatchingIDChanger(batcher, valueField));
            }
            this.event.setType("EvolvedUsedClass").fire().removeProperty("usedClass");
        }

        private EStructuralFeature[] getAddedFeatures(EClass oldClass, EClass newClass) {
            HashSet<EStructuralFeature> existingNewFeatures = new HashSet<EStructuralFeature>();
            EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getClassInfo((EClass)oldClass).getAllPersistentFeatures();
            int n = eStructuralFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature oldFeature = eStructuralFeatureArray[n2];
                EStructuralFeature newFeature = this.context.getNewElement(oldFeature);
                if (newFeature != null) {
                    existingNewFeatures.add(newFeature);
                }
                ++n2;
            }
            ArrayList<EStructuralFeature> addedNewFeatures = new ArrayList<EStructuralFeature>();
            EStructuralFeature[] eStructuralFeatureArray2 = CDOModelUtil.getClassInfo((EClass)newClass).getAllPersistentFeatures();
            int n3 = eStructuralFeatureArray2.length;
            n = 0;
            while (n < n3) {
                EStructuralFeature newFeature = eStructuralFeatureArray2[n];
                if (!existingNewFeatures.contains(newFeature)) {
                    addedNewFeatures.add(newFeature);
                }
                ++n;
            }
            return addedNewFeatures.toArray(new EStructuralFeature[0]);
        }

        private List<EStructuralFeature> getContainerReferences(EClass eClass) {
            return eClass.getEAllReferences().stream().filter(EReference::isContainer).collect(Collectors.toList());
        }

        private void handleContainmentCandidates(EClass eClass, Collection<EClass> usedClasses, BiConsumer<EClass, List<EReference>> handler) {
            usedClasses.forEach(containerClass -> {
                List containments = containerClass.getEAllContainments().stream().filter(ref -> EMFUtil.isPersistent((EStructuralFeature)ref) && ref.getEReferenceType().isSuperTypeOf(eClass)).collect(Collectors.toList());
                if (!containments.isEmpty()) {
                    handler.accept((EClass)containerClass, containments);
                }
            });
        }

        private StatementBatcher createBatcher(IDBStoreAccessor accessor) throws SQLException {
            StatementBatcher batcher = this.context.createStatementBatcher(accessor.getConnection());
            this.event.setType("CreatedStatementBatcher").addProperty("batcher", (Object)batcher).fire();
            return batcher;
        }

        private class ContainerIDChanger
        extends BatchingIDChanger {
            public ContainerIDChanger(StatementBatcher batcher, IClassMapping classMapping) {
                super(batcher, classMapping.getTable().getField(MappingNames.ATTRIBUTES_FEATURE));
            }
        }

        private final class ContainmentIDChanger
        extends ContainerIDChanger {
            private final ObjectTypeTable objects;
            private final String rawContainerTypeID;
            private final IDBField containerField;

            public ContainmentIDChanger(StatementBatcher batcher, IClassMapping classMapping, ObjectTypeTable objects, String rawContainerTypeID) {
                super(batcher, classMapping);
                this.objects = objects;
                this.rawContainerTypeID = rawContainerTypeID;
                this.containerField = Objects.requireNonNull(this.table.getField(MappingNames.ATTRIBUTES_CONTAINER));
            }

            protected String sql(Object newValue, String condition) {
                return String.valueOf(super.sql(newValue, condition)) + " AND (SELECT " + this.objects.clazz() + " FROM " + this.objects + " WHERE " + this.objects.id() + "=" + this.containerField + ")=" + this.rawContainerTypeID;
            }
        }
    }
}

