/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DateTimeValue;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.Typdef;

public class DateTime {
    private static final int dateRepresentationLength = 10;
    private static final int timeRepresentationLength = 8;
    private static final int timestampRepresentationLength = 29;

    private DateTime() {
    }

    static final java.sql.Date dateBytesToDate(byte[] buffer, int offset, Calendar recyclableCal, Charset encoding) {
        String date = new String(buffer, offset, 10, encoding);
        if (date.charAt(4) != '-') {
            throw new IllegalArgumentException(SqlException.getMessageUtil().getTextMessage("22018", new Object[0]));
        }
        int yearIndx = 0;
        int monthIndx = 5;
        int dayIndx = 8;
        int zeroBase = 48;
        int year = 1000 * (date.charAt(yearIndx) - zeroBase) + 100 * (date.charAt(yearIndx + 1) - zeroBase) + 10 * (date.charAt(yearIndx + 2) - zeroBase) + (date.charAt(yearIndx + 3) - zeroBase);
        int month = 10 * (date.charAt(monthIndx) - zeroBase) + (date.charAt(monthIndx + 1) - zeroBase) - 1;
        int day = 10 * (date.charAt(dayIndx) - zeroBase) + (date.charAt(dayIndx + 1) - zeroBase);
        Calendar cal = DateTime.getCleanCalendar(recyclableCal);
        cal.set(year, month, day);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    static final Time timeBytesToTime(byte[] buffer, int offset, Calendar recyclableCal, Charset encoding) {
        String time = new String(buffer, offset, 8, encoding);
        int zeroBase = 48;
        int hour = 10 * (time.charAt(0) - zeroBase) + (time.charAt(1) - zeroBase);
        int minute = 10 * (time.charAt(3) - zeroBase) + (time.charAt(4) - zeroBase);
        int second = 10 * (time.charAt(6) - zeroBase) + (time.charAt(7) - zeroBase);
        Calendar cal = DateTime.getCleanCalendar(recyclableCal);
        cal.set(1970, 0, 1, hour, minute, second);
        return new Time(cal.getTimeInMillis());
    }

    static final Timestamp timestampBytesToTimestamp(byte[] buffer, int offset, Calendar recyclableCal, Charset encoding, boolean supportsTimestampNanoseconds) {
        String timestamp = new String(buffer, offset, DateTime.getTimestampLength(supportsTimestampNanoseconds), encoding);
        Calendar cal = DateTime.getCleanCalendar(recyclableCal);
        int nanos = DateTime.parseTimestampString(timestamp, cal, supportsTimestampNanoseconds);
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanos);
        return ts;
    }

    private static int parseTimestampString(String timestamp, Calendar cal, boolean supportsTimestampNanoseconds) {
        int zeroBase = 48;
        cal.set(1, 1000 * (timestamp.charAt(0) - zeroBase) + 100 * (timestamp.charAt(1) - zeroBase) + 10 * (timestamp.charAt(2) - zeroBase) + (timestamp.charAt(3) - zeroBase));
        cal.set(2, 10 * (timestamp.charAt(5) - zeroBase) + (timestamp.charAt(6) - zeroBase) - 1);
        cal.set(5, 10 * (timestamp.charAt(8) - zeroBase) + (timestamp.charAt(9) - zeroBase));
        cal.set(10, 10 * (timestamp.charAt(11) - zeroBase) + (timestamp.charAt(12) - zeroBase));
        cal.set(12, 10 * (timestamp.charAt(14) - zeroBase) + (timestamp.charAt(15) - zeroBase));
        cal.set(13, 10 * (timestamp.charAt(17) - zeroBase) + (timestamp.charAt(18) - zeroBase));
        int nanos = 100000000 * (timestamp.charAt(20) - zeroBase) + 10000000 * (timestamp.charAt(21) - zeroBase) + 1000000 * (timestamp.charAt(22) - zeroBase) + 100000 * (timestamp.charAt(23) - zeroBase) + 10000 * (timestamp.charAt(24) - zeroBase) + 1000 * (timestamp.charAt(25) - zeroBase);
        if (supportsTimestampNanoseconds) {
            nanos += 100 * (timestamp.charAt(26) - zeroBase);
            nanos += 10 * (timestamp.charAt(27) - zeroBase);
            nanos += timestamp.charAt(28) - zeroBase;
        }
        cal.set(14, nanos / 1000000);
        return nanos;
    }

    public static final int dateToDateBytes(byte[] buffer, int offset, DateTimeValue date) throws SqlException {
        int year = date.getYear();
        if (year > 9999) {
            throw new SqlException(null, new ClientMessageId("22003.S.1"), year, "9999");
        }
        int month = date.getMonth() + 1;
        int day = date.getDayOfMonth();
        char[] dateChars = new char[10];
        int zeroBase = 48;
        dateChars[0] = (char)(year / 1000 + zeroBase);
        dateChars[1] = (char)(year % 1000 / 100 + zeroBase);
        dateChars[2] = (char)(year % 100 / 10 + zeroBase);
        dateChars[3] = (char)(year % 10 + zeroBase);
        dateChars[4] = 45;
        dateChars[5] = (char)(month / 10 + zeroBase);
        dateChars[6] = (char)(month % 10 + zeroBase);
        dateChars[7] = 45;
        dateChars[8] = (char)(day / 10 + zeroBase);
        dateChars[9] = (char)(day % 10 + zeroBase);
        byte[] dateBytes = new String(dateChars).getBytes(Typdef.UTF8ENCODING);
        System.arraycopy(dateBytes, 0, buffer, offset, 10);
        return 10;
    }

    public static final int timeToTimeBytes(byte[] buffer, int offset, DateTimeValue time) {
        int hour = time.getHours();
        int minute = time.getMinutes();
        int second = time.getSeconds();
        char[] timeChars = new char[8];
        int zeroBase = 48;
        timeChars[0] = (char)(hour / 10 + zeroBase);
        timeChars[1] = (char)(hour % 10 + zeroBase);
        timeChars[2] = 58;
        timeChars[3] = (char)(minute / 10 + zeroBase);
        timeChars[4] = (char)(minute % 10 + zeroBase);
        timeChars[5] = 58;
        timeChars[6] = (char)(second / 10 + zeroBase);
        timeChars[7] = (char)(second % 10 + zeroBase);
        byte[] timeBytes = new String(timeChars).getBytes(Typdef.UTF8ENCODING);
        System.arraycopy(timeBytes, 0, buffer, offset, 8);
        return 8;
    }

    public static final int timestampToTimestampBytes(byte[] buffer, int offset, DateTimeValue timestamp, boolean supportsTimestampNanoseconds) throws SqlException {
        int year = timestamp.getYear();
        if (year > 9999) {
            throw new SqlException(null, new ClientMessageId("22003.S.1"), year, "9999");
        }
        int month = timestamp.getMonth() + 1;
        int day = timestamp.getDayOfMonth();
        int hour = timestamp.getHours();
        int minute = timestamp.getMinutes();
        int second = timestamp.getSeconds();
        int microsecond = timestamp.getNanos() / 1000;
        int arrayLength = DateTime.getTimestampLength(supportsTimestampNanoseconds);
        char[] timestampChars = new char[arrayLength];
        int zeroBase = 48;
        timestampChars[0] = (char)(year / 1000 + zeroBase);
        timestampChars[1] = (char)(year % 1000 / 100 + zeroBase);
        timestampChars[2] = (char)(year % 100 / 10 + zeroBase);
        timestampChars[3] = (char)(year % 10 + zeroBase);
        timestampChars[4] = 45;
        timestampChars[5] = (char)(month / 10 + zeroBase);
        timestampChars[6] = (char)(month % 10 + zeroBase);
        timestampChars[7] = 45;
        timestampChars[8] = (char)(day / 10 + zeroBase);
        timestampChars[9] = (char)(day % 10 + zeroBase);
        timestampChars[10] = 45;
        timestampChars[11] = (char)(hour / 10 + zeroBase);
        timestampChars[12] = (char)(hour % 10 + zeroBase);
        timestampChars[13] = 46;
        timestampChars[14] = (char)(minute / 10 + zeroBase);
        timestampChars[15] = (char)(minute % 10 + zeroBase);
        timestampChars[16] = 46;
        timestampChars[17] = (char)(second / 10 + zeroBase);
        timestampChars[18] = (char)(second % 10 + zeroBase);
        timestampChars[19] = 46;
        timestampChars[20] = (char)(microsecond / 100000 + zeroBase);
        timestampChars[21] = (char)(microsecond % 100000 / 10000 + zeroBase);
        timestampChars[22] = (char)(microsecond % 10000 / 1000 + zeroBase);
        timestampChars[23] = (char)(microsecond % 1000 / 100 + zeroBase);
        timestampChars[24] = (char)(microsecond % 100 / 10 + zeroBase);
        timestampChars[25] = (char)(microsecond % 10 + zeroBase);
        if (supportsTimestampNanoseconds) {
            int nanosecondsOnly = timestamp.getNanos() % 1000;
            timestampChars[26] = (char)(nanosecondsOnly / 100 + zeroBase);
            timestampChars[27] = (char)(nanosecondsOnly % 100 / 10 + zeroBase);
            timestampChars[28] = (char)(nanosecondsOnly % 10 + zeroBase);
        }
        String newtimestampString = new String(timestampChars);
        byte[] timestampBytes = newtimestampString.getBytes(Typdef.UTF8ENCODING);
        System.arraycopy(timestampBytes, 0, buffer, offset, arrayLength);
        return arrayLength;
    }

    static final Timestamp dateBytesToTimestamp(byte[] buffer, int offset, Calendar recyclableCal, Charset encoding) {
        String date = new String(buffer, offset, 10, encoding);
        int yearIndx = 0;
        int monthIndx = 5;
        int dayIndx = 8;
        int zeroBase = 48;
        int year = 1000 * (date.charAt(yearIndx) - zeroBase) + 100 * (date.charAt(yearIndx + 1) - zeroBase) + 10 * (date.charAt(yearIndx + 2) - zeroBase) + (date.charAt(yearIndx + 3) - zeroBase);
        int month = 10 * (date.charAt(monthIndx) - zeroBase) + (date.charAt(monthIndx + 1) - zeroBase) - 1;
        int day = 10 * (date.charAt(dayIndx) - zeroBase) + (date.charAt(dayIndx + 1) - zeroBase);
        Calendar cal = DateTime.getCleanCalendar(recyclableCal);
        cal.set(year, month, day, 0, 0, 0);
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(0);
        return ts;
    }

    static final Timestamp timeBytesToTimestamp(byte[] buffer, int offset, Calendar recyclableCal, Charset encoding) {
        String time = new String(buffer, offset, 8, encoding);
        int zeroBase = 48;
        int hour = 10 * (time.charAt(0) - zeroBase) + (time.charAt(1) - zeroBase);
        int minute = 10 * (time.charAt(3) - zeroBase) + (time.charAt(4) - zeroBase);
        int second = 10 * (time.charAt(6) - zeroBase) + (time.charAt(7) - zeroBase);
        Calendar cal = DateTime.getCleanCalendar(recyclableCal);
        cal.setTime(new Date());
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    static final java.sql.Date timestampBytesToDate(byte[] buffer, int offset, Calendar recyclableCal, Charset encoding) {
        String timestamp = new String(buffer, offset, 29, encoding);
        int zeroBase = 48;
        int year = 1000 * (timestamp.charAt(0) - zeroBase) + 100 * (timestamp.charAt(1) - zeroBase) + 10 * (timestamp.charAt(2) - zeroBase) + (timestamp.charAt(3) - zeroBase);
        int month = 10 * (timestamp.charAt(5) - zeroBase) + (timestamp.charAt(6) - zeroBase) - 1;
        int day = 10 * (timestamp.charAt(8) - zeroBase) + (timestamp.charAt(9) - zeroBase);
        Calendar cal = DateTime.getCleanCalendar(recyclableCal);
        cal.set(year, month, day);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    static final Time timestampBytesToTime(byte[] buffer, int offset, Calendar recyclableCal, Charset encoding) {
        String timestamp = new String(buffer, offset, 29, encoding);
        Calendar cal = DateTime.getCleanCalendar(recyclableCal);
        DateTime.parseTimestampString(timestamp, cal, false);
        cal.set(1970, 0, 1);
        return new Time(cal.getTimeInMillis());
    }

    private static Calendar getCleanCalendar(Calendar recyclableCal) {
        if (recyclableCal != null) {
            recyclableCal.clear();
            return recyclableCal;
        }
        GregorianCalendar result = new GregorianCalendar();
        result.clear();
        return result;
    }

    public static int getTimestampLength(boolean supportsTimestampNanoseconds) {
        return supportsTimestampNanoseconds ? 29 : 26;
    }
}

