/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.net4j.util.concurrent.ExecutorServiceFactory;
import org.eclipse.net4j.util.concurrent.IExecutorServiceProvider;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IOUtil;

public final class ConcurrencyUtil {
    private ConcurrencyUtil() {
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    public static void sleep(long millis, int nanos) {
        try {
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    public static ExecutorService getExecutorService(IManagedContainer container) {
        return ExecutorServiceFactory.get(container);
    }

    public static ExecutorService getExecutorService(Object object) {
        if (object instanceof IExecutorServiceProvider) {
            try {
                return ((IExecutorServiceProvider)object).getExecutorService();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object instanceof IManagedContainer) {
            try {
                return ConcurrencyUtil.getExecutorService((IManagedContainer)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void execute(Object executor, Runnable runnable) {
        if (executor instanceof Executor) {
            ((Executor)executor).execute(runnable);
            return;
        }
        ExecutorService executorService = ConcurrencyUtil.getExecutorService(executor);
        if (executorService == null && executor instanceof IManagedContainer) {
            executorService = ConcurrencyUtil.getExecutorService((IManagedContainer)executor);
        }
        if (executorService != null) {
            executorService.execute(runnable);
            return;
        }
        Thread thread = new Thread(runnable, runnable.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    public static void setThreadName(Thread thread, String name) {
        thread.setName(name);
    }

    public static void setThreadName(String name) {
        ConcurrencyUtil.setThreadName(Thread.currentThread(), name);
    }

    public static void log(String msg) {
        IOUtil.OUT().println(String.valueOf(Thread.currentThread().getName()) + ": " + msg);
    }

    public static void checkCancelation(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

