/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.master;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.impl.store.replication.ReplicationLogger;
import org.apache.derby.impl.store.replication.buffer.LogBufferFullException;
import org.apache.derby.impl.store.replication.buffer.ReplicationLogBuffer;
import org.apache.derby.impl.store.replication.master.AsynchronousLogShipper;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.ReplicationMessageTransmit;
import org.apache.derby.impl.store.replication.net.SlaveAddress;
import org.apache.derby.shared.common.error.StandardException;

public class MasterController
implements MasterFactory,
ModuleControl,
ModuleSupportable {
    private static final int DEFAULT_LOG_BUFFER_SIZE = 32768;
    private static final int LOG_BUFFER_SIZE_MIN = 8192;
    private static final int LOG_BUFFER_SIZE_MAX = 0x100000;
    private RawStoreFactory rawStoreFactory;
    private DataFactory dataFactory;
    private LogFactory logFactory;
    private ReplicationLogBuffer logBuffer;
    private AsynchronousLogShipper logShipper;
    private ReplicationMessageTransmit transmitter;
    private ReplicationLogger repLogger;
    private String replicationMode;
    private SlaveAddress slaveAddr;
    private String dbname;
    private int logBufferSize = 0;
    private boolean active = false;
    private static final int SLAVE_CONNECTION_ATTEMPT_TIMEOUT = 5000;

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        this.replicationMode = properties.getProperty("derby.__rt.replication.master.mode");
    }

    @Override
    public boolean canSupport(Properties startParams) {
        String modeParam = startParams.getProperty("derby.__rt.replication.master.mode");
        return modeParam != null && modeParam.equals("derby.__rt.asynch");
    }

    @Override
    public void stop() {
        try {
            this.stopMaster();
        }
        catch (StandardException se) {
            this.repLogger.logError("R008", se);
        }
    }

    @Override
    public void startMaster(RawStoreFactory rawStore, DataFactory dataFac, LogFactory logFac, String slavehost, int slaveport, String dbname) throws StandardException {
        if (this.active) {
            throw StandardException.newException("XRE22.C", dbname);
        }
        try {
            this.slaveAddr = new SlaveAddress(slavehost, slaveport);
        }
        catch (UnknownHostException uhe) {
            throw StandardException.newException("XRE04.C.1", uhe, dbname, this.getHostName(), String.valueOf(this.getPortNumber()));
        }
        this.dbname = dbname;
        this.rawStoreFactory = rawStore;
        this.dataFactory = dataFac;
        this.logFactory = logFac;
        this.repLogger = new ReplicationLogger(dbname);
        this.getMasterProperties();
        this.logBuffer = new ReplicationLogBuffer(this.logBufferSize, this);
        try {
            this.logFactory.startReplicationMasterRole(this);
            this.rawStoreFactory.unfreeze();
            this.setupConnection();
            if (this.replicationMode.equals("derby.__rt.asynch")) {
                this.logShipper = new AsynchronousLogShipper(this.logBuffer, this.transmitter, this, this.repLogger);
                this.logShipper.setDaemon(true);
                this.logShipper.start();
            }
        }
        catch (StandardException se) {
            this.repLogger.logError("R005", se);
            this.logFactory.stopReplicationMasterRole();
            this.teardownNetwork();
            throw se;
        }
        this.active = true;
        Monitor.logTextMessage("R007", dbname);
    }

    @Override
    public void stopMaster() throws StandardException {
        if (!this.active) {
            throw StandardException.newException("XRE07", new Object[0]);
        }
        this.active = false;
        this.logFactory.stopReplicationMasterRole();
        try {
            this.logShipper.flushBuffer();
        }
        catch (IOException ioe) {
            this.repLogger.logError("R009", ioe);
        }
        catch (StandardException se) {
            this.repLogger.logError("R009", se);
        }
        finally {
            this.teardownNetwork();
        }
        Monitor.logTextMessage("R008", this.dbname);
    }

    @Override
    public void startFailover() throws StandardException {
        if (!this.active) {
            throw StandardException.newException("XRE07", new Object[0]);
        }
        ReplicationMessage ack = null;
        this.active = false;
        this.rawStoreFactory.freeze();
        try {
            this.logShipper.flushBuffer();
            ReplicationMessage mesg = new ReplicationMessage(21, null);
            ack = this.transmitter.sendMessageWaitForReply(mesg);
        }
        catch (IOException ioe) {
            this.handleFailoverFailure(ioe);
        }
        catch (StandardException se) {
            this.handleFailoverFailure(se);
        }
        if (ack == null) {
            this.handleFailoverFailure(null);
        } else {
            if (ack.getType() == 11) {
                this.teardownNetwork();
                this.rawStoreFactory.unfreeze();
                throw StandardException.newException("XRE20.D", this.dbname);
            }
            this.handleFailoverFailure(null);
        }
    }

    private void getMasterProperties() {
        this.logBufferSize = PropertyUtil.getSystemInt("derby.replication.logBufferSize", 32768);
        if (this.logBufferSize < 8192) {
            this.logBufferSize = 8192;
            this.repLogger.logText("Replication log buffer size property too small. Set to minimum value: " + this.logBufferSize, false);
        } else if (this.logBufferSize > 0x100000) {
            this.logBufferSize = 0x100000;
            this.repLogger.logText("Replication log buffer size property too big. Set to maximum value: " + this.logBufferSize, false);
        }
    }

    private void handleFailoverFailure(Throwable t) throws StandardException {
        this.teardownNetwork();
        this.rawStoreFactory.unfreeze();
        if (t != null) {
            throw StandardException.newException("XRE21.C", t, this.dbname);
        }
        throw StandardException.newException("XRE21.C", this.dbname);
    }

    @Override
    public void appendLog(long greatestInstant, byte[] log, int logOffset, int logLength) {
        try {
            this.logBuffer.appendLog(greatestInstant, log, logOffset, logLength);
        }
        catch (LogBufferFullException lbfe) {
            try {
                this.logShipper.forceFlush();
                this.logBuffer.appendLog(greatestInstant, log, logOffset, logLength);
            }
            catch (LogBufferFullException lbfe2) {
                this.printStackAndStopMaster(lbfe2);
            }
            catch (IOException ioe) {
                this.printStackAndStopMaster(ioe);
            }
            catch (StandardException se) {
                this.printStackAndStopMaster(se);
            }
        }
    }

    @Override
    public void flushedTo(long instant) {
        this.logShipper.flushedInstance(instant);
    }

    private void setupConnection() throws StandardException {
        try {
            if (this.transmitter != null) {
                this.transmitter.tearDown();
            }
            this.transmitter = new ReplicationMessageTransmit(this.slaveAddr);
            if (this.logShipper != null && this.logShipper.getHighestShippedInstant() != -1L) {
                this.transmitter.initConnection(5000, this.logShipper.getHighestShippedInstant());
            } else {
                this.transmitter.initConnection(5000, this.logFactory.getFirstUnflushedInstantAsLong());
            }
        }
        catch (SocketTimeoutException ste) {
            throw StandardException.newException("XRE06", this.dbname);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XRE04.C.1", ioe, this.dbname, this.getHostName(), String.valueOf(this.getPortNumber()));
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception e) {
            throw StandardException.newException("XRE04.C.1", e, this.dbname, this.getHostName(), String.valueOf(this.getPortNumber()));
        }
    }

    ReplicationMessageTransmit handleExceptions(Exception exception) {
        if (exception instanceof IOException) {
            this.repLogger.logError("R009", exception);
            Monitor.logTextMessage("R010", this.dbname);
            while (this.active) {
                try {
                    this.transmitter = new ReplicationMessageTransmit(this.slaveAddr);
                    if (this.logShipper != null && this.logShipper.getHighestShippedInstant() != -1L) {
                        this.transmitter.initConnection(5000, this.logShipper.getHighestShippedInstant());
                    } else {
                        this.transmitter.initConnection(5000, this.logFactory.getFirstUnflushedInstantAsLong());
                    }
                    break;
                }
                catch (SocketTimeoutException ste) {
                }
                catch (IOException ioe) {
                }
                catch (Exception e) {
                    this.printStackAndStopMaster(e);
                    return null;
                }
            }
        } else if (exception instanceof StandardException) {
            this.printStackAndStopMaster(exception);
            return null;
        }
        return this.transmitter;
    }

    private void printStackAndStopMaster(Exception e) {
        this.repLogger.logError("R009", e);
        try {
            this.stopMaster();
        }
        catch (StandardException se) {
            this.repLogger.logError("R008", se);
        }
    }

    @Override
    public void workToDo() {
        this.logShipper.workToDo();
    }

    private void teardownNetwork() {
        if (this.logShipper != null) {
            this.logShipper.stopLogShipment();
        }
        if (this.transmitter != null) {
            try {
                ReplicationMessage mesg = new ReplicationMessage(20, null);
                this.transmitter.sendMessage(mesg);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.transmitter.tearDown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    String getDbName() {
        return this.dbname;
    }

    private String getHostName() {
        return this.slaveAddr.getHostAddress().getHostName();
    }

    private int getPortNumber() {
        return this.slaveAddr.getPortNumber();
    }
}

