/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests.apps;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.CountDownLatch;
import org.eclipse.net4j.util.io.IOUtil;

public class Performance {
    public static void main(String[] args) throws Exception {
        Performance.testInetAddress();
        Performance.testServerSocket();
        Performance.testSocket();
        Performance.testSelector();
    }

    public static void testInetAddress() throws Exception {
        System.out.println(InetAddress.class.getName());
        int i = 0;
        while (i < 2) {
            long start = System.currentTimeMillis();
            InetAddress inet = InetAddress.getByName("localhost");
            inet.getHostAddress();
            long duration = System.currentTimeMillis() - start;
            System.out.println(duration);
            ++i;
        }
    }

    public static void testServerSocket() throws IOException {
        System.out.println(ServerSocket.class.getName());
        int i = 0;
        while (i < 2) {
            long start = System.currentTimeMillis();
            ServerSocket serverSocket = new ServerSocket(2036);
            long duration = System.currentTimeMillis() - start;
            System.out.println(duration);
            serverSocket.close();
            ++i;
        }
    }

    public static void testRouter() throws Exception {
        System.out.println(Socket.class.getName() + " (ROUTER)");
        int i = 0;
        while (i < 2) {
            InetSocketAddress endpoint = new InetSocketAddress(InetAddress.getByName("192.168.1.1"), 80);
            Socket socket = new Socket(Proxy.NO_PROXY);
            long start = System.currentTimeMillis();
            socket.connect(endpoint);
            long duration = System.currentTimeMillis() - start;
            System.out.println(duration);
            socket.close();
            Thread.sleep(500L);
            ++i;
        }
    }

    public static void testSocket() throws Exception {
        System.out.println(Socket.class.getName() + " (LOOPBACK)");
        int i = 0;
        while (i < 2) {
            final InetSocketAddress endpoint = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 2036);
            final CountDownLatch latch = new CountDownLatch(1);
            new Thread(){

                @Override
                public void run() {
                    try {
                        ServerSocket serverSocket = new ServerSocket();
                        serverSocket.bind(endpoint);
                        latch.countDown();
                        Socket socket = serverSocket.accept();
                        socket.close();
                        serverSocket.close();
                    }
                    catch (IOException ex) {
                        IOUtil.print((Throwable)ex);
                        latch.countDown();
                    }
                }
            }.start();
            latch.await();
            Thread.sleep(500L);
            Socket socket = new Socket(Proxy.NO_PROXY);
            long start = System.currentTimeMillis();
            socket.connect(endpoint);
            long duration = System.currentTimeMillis() - start;
            System.out.println(duration);
            socket.close();
            Thread.sleep(500L);
            ++i;
        }
    }

    public static void testSelector() throws IOException {
        SelectorProvider provider = SelectorProvider.provider();
        System.out.println(provider.getClass().getName());
        int i = 0;
        while (i < 2) {
            long start = System.currentTimeMillis();
            AbstractSelector selector = provider.openSelector();
            long duration = System.currentTimeMillis() - start;
            System.out.println(duration);
            ((Selector)selector).close();
            ++i;
        }
    }
}

