/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.lock;

import java.util.Map;
import java.util.Random;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockAreaImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockChangeInfoImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockOwnerImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockStateImpl;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public final class CDOLockUtil {
    public static final int DURABLE_SESSION_ID = 0;
    public static final int DURABLE_VIEW_ID = 0;

    private CDOLockUtil() {
    }

    public static CDOID getLockedObjectID(Object lockedObject) {
        if (lockedObject instanceof CDOID) {
            return (CDOID)lockedObject;
        }
        if (lockedObject instanceof CDOIDAndBranch) {
            return ((CDOIDAndBranch)lockedObject).getID();
        }
        return null;
    }

    public static CDOBranch getLockedObjectBranch(Object lockedObject) {
        if (lockedObject instanceof CDOIDAndBranch) {
            return ((CDOIDAndBranch)lockedObject).getBranch();
        }
        return null;
    }

    public static CDOLockState copyLockState(CDOLockState lockState) {
        return CDOLockUtil.copyLockState(lockState, lockState.getLockedObject());
    }

    public static CDOLockState copyLockState(CDOLockState lockState, Object lockedObject) {
        CheckUtil.checkArg((boolean)(lockState instanceof CDOLockStateImpl), (String)"lockState instanceof CDOLockStateImpl");
        return ((CDOLockStateImpl)lockState).copy(lockedObject);
    }

    public static CDOLockState createLockState(Object target) {
        return new CDOLockStateImpl(target);
    }

    public static CDOLockState createLockState(RWOLockManager.LockState<Object, ? extends CDOCommonView> lockState) {
        CDOCommonView writeOptionOwner;
        CheckUtil.checkArg(lockState, (String)"lockState");
        CDOLockStateImpl cdoLockState = new CDOLockStateImpl(lockState.getLockedObject());
        for (CDOCommonView view : lockState.getReadLockOwners()) {
            cdoLockState.addReadLockOwner(CDOLockUtil.createLockOwner(view));
        }
        CDOCommonView writeLockOwner = (CDOCommonView)lockState.getWriteLockOwner();
        if (writeLockOwner != null) {
            cdoLockState.setWriteLockOwner(CDOLockUtil.createLockOwner(writeLockOwner));
        }
        if ((writeOptionOwner = (CDOCommonView)lockState.getWriteOptionOwner()) != null) {
            cdoLockState.setWriteOptionOwner(CDOLockUtil.createLockOwner(writeOptionOwner));
        }
        return cdoLockState;
    }

    public static CDOLockOwner createLockOwner(CDOCommonView view) {
        int sessionID = view.getSessionID();
        int viewID = view.getViewID();
        String durableLockingID = view.getDurableLockingID();
        return CDOLockUtil.createLockOwner(sessionID, viewID, durableLockingID);
    }

    public static CDOLockOwner createLockOwner(int sessionID, int viewID, String durableLockingID) {
        return new CDOLockOwnerImpl(sessionID, viewID, durableLockingID);
    }

    public static CDOLockChangeInfo createLockChangeInfo(long timestamp, CDOLockOwner lockOwner, CDOBranch branch, CDOLockChangeInfo.Operation op, IRWLockManager.LockType lockType, CDOLockState[] cdoLockStates) {
        return new CDOLockChangeInfoImpl(branch.getPoint(timestamp), lockOwner, cdoLockStates, op, lockType);
    }

    public static CDOLockChangeInfo createLockChangeInfo() {
        return new CDOLockChangeInfoImpl();
    }

    public static CDOLockChangeInfo createLockChangeInfo(long timestamp, CDOCommonView view, CDOBranch viewedBranch, CDOLockChangeInfo.Operation op, IRWLockManager.LockType lockType, CDOLockState[] cdoLockStates) {
        CDOLockOwner lockOwner = CDOLockUtil.createLockOwner(view);
        return CDOLockUtil.createLockChangeInfo(timestamp, lockOwner, viewedBranch, op, lockType, cdoLockStates);
    }

    public static IDurableLockingManager.LockArea createLockArea(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return new CDOLockAreaImpl(durableLockingID, userID, branchPoint, readOnly, locks);
    }

    public static IDurableLockingManager.LockArea createLockArea(String durableLockingID) {
        return new CDOLockAreaImpl(durableLockingID);
    }

    public static String createDurableLockingID() {
        return CDOLockUtil.createDurableLockingID(32);
    }

    public static String createDurableLockingID(int bytes) {
        byte[] buffer = new byte[bytes];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(buffer);
        return HexUtil.bytesToHex((byte[])buffer);
    }
}

