/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.om.monitor.AbstractMonitor;
import org.eclipse.net4j.util.om.monitor.MonitorCanceledException;

public class Monitor
extends AbstractMonitor {
    public static final long DEFAULT_ASYNC_SCHEDULE_PERIOD = 1000L;
    private static Timer TIMER;
    private boolean canceled;
    private RuntimeException cancelException;

    public void cancel() {
        this.cancel(null);
    }

    public void cancel(RuntimeException cancelException) {
        this.cancelException = cancelException;
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void checkCanceled() throws MonitorCanceledException {
        if (this.cancelException != null) {
            throw new MonitorCanceledException(this.cancelException);
        }
        if (this.canceled) {
            throw new MonitorCanceledException();
        }
    }

    @Override
    protected long getAsyncSchedulePeriod() {
        return 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Timer getTimer() {
        Class<Monitor> clazz = Monitor.class;
        synchronized (Monitor.class) {
            if (TIMER == null) {
                TIMER = new Timer("monitor-timer", true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return TIMER;
        }
    }

    @Override
    protected void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        try {
            this.getTimer().scheduleAtFixedRate(task, delay, period);
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
        }
    }
}

